@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
{{--<link rel="stylesheet" href="/css/selectize.min.css" />--}}
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--已經有在default引入了--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
{{--<script src="/js/selectize.min.js"></script>--}}


{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }

        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
        .seeline{
            border: #ffffff 1px solid;
        }


</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '23'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 3vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 10vh;align-items: center">
                        <div class="col-md-3 float-right">
                        </div>
                    </div>
                    <div style="height: 2vh;width: 100%"></div>
                    {{--表格呈現-須審核加班單列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 75vh"></table>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{-- 不同意彈出視窗 --}}
    <div class="modal fade" id="DisagreeOvertime" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">確認加班資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("disagree_overtime") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="name" >姓名</label>
                                <div class="col-6">
                                    <input id='d_name' style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="category" >日期</label>
                                <div class="col-6">
                                    <input id='d_date' style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="reason" >加班時間</label>
                                <div class="col-6">
                                    <input id='d_time' style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="start" >加班原因</label>
                                <div class="col-6">
                                    <input id='d_reason' style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-5 col-form-label" for="disagree" >請填寫不同意加班原因</label>
                                <div class="col-6">
                                    <input id='no' name="no" style="text-align: center"  type="hidden">
                                    <input id='disagree' name="disagree" style="text-align: center"  type="text" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    <script>
        //不同意資料處理
        function disagree_overtime(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("d_name").value=jdata[jdata_index].name;
            document.getElementById("d_date").value=jdata[jdata_index].date;
            document.getElementById("d_time").value=jdata[jdata_index].start +"-"+jdata[jdata_index].end;
            document.getElementById("d_reason").value=jdata[jdata_index].reason;
            document.getElementById("no").value=jdata[jdata_index].no;
        }
        {{--審核--}}
        function agree_overtime(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("agree_overtime") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--表格設定(boostrap-tabel)--}}
    <script>
        // 載入資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        //動態載入表格之前，先銷毀表格
        $('#tableL01').bootstrapTable('destroy');
        var tableColumns = [
            {field: 'name',title: '人員名稱', sortable: false},
            {field: 'date',title: '日期', sortable: true},
            {field: 'start', title: '開始時間', sortable: true},
            {field: 'end', title: '結束時間', sortable: true},
            {field: 'reason', title: '原因', sortable: true},
            {field: 'agree', title: '審核', sortable: false},
            {field: 'disagree', title: '退回', sortable: false},
        ];
        //設定欄位標題
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'date', // 預設排序
        });

    </script>

@endsection
