<?php
session_start()
?>

@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    <script src="/js/3.1.1/jquery.min.js"></script>
<script src="/js/jquery.validate.min.js"></script>
{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        .seeline{
            border: #000000 1px solid;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .error {
            color: #66A8CC;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '6'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-10" style="background:#e0e6ec">
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 10vh;align-items: center">
                        <div class="col-6" style="padding-right: 0px;">
                            <form method="POST" action="{{ route('search_user') }}">
                            {{ csrf_field() }}
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04">
                                    <option value="default" selected>請選擇類別</option>
                                    <option value="1">使用者帳號</option>
                                    <option value="2">身份</option>
                                    <option value="3">姓名</option>
                                </select>
                                <input name="search_text" type="text" class="form-control" placeholder="欲搜尋內容" >
                                <div class="input-group-append">
                                    <button class="btn btn-dark" type="submit">搜尋</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        <div class="col-6 float-right">
                            @if($level=="3" or $level == "4")
                                <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="post_delete_user()">批量刪除</button>
                                <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertMemberModalCenter">新增人員</button>
                                <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#Department">部門編修</button>
                            @endif
                            {{--<button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="word()">申請單</button>--}}
                        </div>
                    </div>
                    <p></p>
                    {{--表格呈現-使用者列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 75vh"></table>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{-- 新增彈出視窗 --}}
    <div class="modal fade" id="InsertMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增人員</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="insertuser" action="{{ route("post_insert_user") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="col-1"></div>
                            <input  type="hidden" class="form-control" id="inputID" name="user_id" placeholder="請輸入使用者編號" required>
                            <input  type="hidden" class="form-control" id="inputName" name="user_name" placeholder="請輸入姓名" required>

                            <!--
                            <div class="form-group row">
                                <label for="inputID" class="col-2 col-form-label" style="text-align: right">ID</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="inputID" name="user_id" placeholder="請輸入使用者編號" required>
                                </div>
                            </div>
                            !-->
                            <div class="form-group row">
                                
                                <!-- <label for="inputPersonId" class="col-2 col-form-label" style="text-align: right">人員ID</label> !-->
                                <label for="inputPersonId" class="col-2 col-form-label" style="text-align: right">人員姓名</label>
                                <div class="col-9">
                                    <!-- <select class="custom-select form-control" id="inputPersonId" name="user_personid" required> !-->
                                    <select id="user_personid" class="custom-select form-control" id="inputPersonId" name="user_personid" onchange="selectPerson()" required>
                                        <option selected disabled >請選擇人員</option>
                                        @foreach($persons as $person)
                                            <Option value="{{ $person["id"] }}">{{ $person["name"] }}</Option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!--
                            <div class="form-group row">
                                <label for="inputName" class="col-2 col-form-label" style="text-align: right">姓名</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="inputName" name="user_name" placeholder="請輸入姓名" required>
                                </div>
                            </div>
                            -->

                            
                            <div class="form-group row">
                                <label for="inputDepartment" class="col-2 col-form-label" style="text-align: right">部門</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="inputDepartment" name="user_department" required>
                                        <option selected disabled >請選擇部門</option>
                                        @foreach($departments as $department)
                                            <Option value="{{ $department["no"] }}">{{ $department["department"] }}</Option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label" for="selectGroup" style="text-align: right">身份</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="selectGroup" name="user_role" required>
                                        <option selected disabled >請選擇人員身份</option>
                                        @foreach($userroles as $userrole)
                                            <Option value="{{ $userrole["id"] }}">{{ $userrole["name"] }}</Option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <label for="inputOnBoard" class="col-2 col-form-label" style="text-align: right">到職日期</label>
                                    <div class="col-9">
                                        <input name="user_onboard" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" placeholder="請輸入到職日期" required/>
                                        <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputEmail" class="col-2 col-form-label" style="text-align: right">Email</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="inputEmail" name="user_email" placeholder="請輸入Email" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputUserName" class="col-4 col-form-label" style="text-align: right">使用者名稱</label>
                                <div class="col-7">
                                    <input type="text" class="form-control" id="inputUserName" name="user_username" placeholder="請輸入使用者名稱" required>
                                </div>
                                <div class="col-1"></div>
                            </div>
                            <div class="form-group row">
                                <label for="inputpwd" class="col-4 col-form-label" style="text-align: right">使用者密碼</label>
                                <div class="col-7">
                                    <input type="password" class="form-control" id="inputpwd" name="user_password" maxlength="12" placeholder="請輸入使用者密碼" required>
                                </div>
                                <div class="col-1"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 新增權限彈出視窗 --}}
    <div class="modal fade" id="InsertAuthority" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="overflow:visible;" >
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content" style="height: 600px">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增權限</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="insert_userfeatures" action="{{ route("insert_user_features") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <input type="hidden" class="form-control" id="features_user" name="features_user" readonly>
                        <div class="col-12" style="height: 420px; overflow: auto">
                            <table class="table table-striped table-bordered table-hover" id="tableL02">
                                <tbody>
                                @foreach($features as $feature)
                                    <tr>
                                        <th><input type="checkbox" id="features_{{$feature["no"]}}" name="user_features_{{$feature["no"]}}" value="{{$feature["no"]}}" /></th>
                                        <td>{{$feature["no"]}}</td>
                                        <td>{{$feature["major_title"]}}</td>
                                        <td>{{$feature["name"]}}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" >
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
        <div>
        </div>
    </div>
    {{-- 修改資料彈出視窗 --}}
    <div class="modal fade" id="ModifyMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">修改人員資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="modifyuser" action="{{ route("modify_user") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            @if($level=="3" or $level=="4")
                                <div class="form-group row">
                                    <label for="inputID" class="col-2 col-form-label" style="text-align: right">ID</label>
                                    <div class="col-9">
                                        <input type="text" class="form-control" id="modifyID" name="modify_user_id" placeholder="請輸入使用者編號" readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputPersonId" class="col-2 col-form-label" style="text-align: right">人員</label>
                                    <div class="col-9">
                                        <select class="custom-select form-control" id="modifyPersonId" name="modify_user_personid" required>
                                            <option selected disabled >請選擇人員</option>
                                            @foreach($persons as $person)
                                                <Option value="{{ $person["id"] }}">{{ $person["name"] }}</Option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputName" class="col-2 col-form-label" style="text-align: right">姓名</label>
                                    <div class="col-9">
                                        <input type="text" class="form-control" id="modifyName" name="modify_user_name" placeholder="請輸入姓名">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputDepartment" class="col-2 col-form-label" style="text-align: right">部門</label>
                                    <div class="col-9">
                                        <select class="custom-select form-control" id="modifyDepartment" name="modify_user_department" required>
                                            <option selected disabled >請選擇部門</option>
                                            @foreach($departments as $department)
                                                <Option value="{{ $department["no"] }}">{{ $department["department"] }}</Option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-2 col-form-label" for="selectGroup" style="text-align: right">身份</label>
                                    <div class="col-9">
                                        <select class="custom-select form-control" id="modifyselectGroup" name="modify_user_role" required>
                                            <option selected value="0" disabled >請選擇人員身份</option>
                                            @foreach($userroles as $userrole)
                                                <Option value="{{ $userrole["id"] }}">{{ $userrole["name"] }}</Option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                        <label for="inputOnBoard" class="col-2 col-form-label" style="text-align: right">到職日期</label>
                                        <div class="col-9">
                                            <input id="modifyOnBoard" name="modify_user_onboard" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" placeholder="請輸入到職日期" required/>
                                            <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="form-group row">
                                    <label for="inputID" class="col-2 col-form-label" style="text-align: right">ID</label>
                                    <div class="col-9">
                                        <input type="text" class="form-control" id="modifyID" name="modify_user_id" placeholder="請輸入使用者編號" readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputPersonId" class="col-2 col-form-label" style="text-align: right">人員</label>
                                    <div class="col-9">
                                        <input type="hidden" class="form-control" id="modifyPersonId" name="modify_user_personid" placeholder="請輸入人員編號" readonly>
                                        <input type="text" class="form-control" id="modifyPersonName"  readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputName" class="col-2 col-form-label" style="text-align: right">姓名</label>
                                    <div class="col-9">
                                        <input type="text" class="form-control" id="modifyName" name="modify_user_name" placeholder="請輸入姓名" readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputDepartment" class="col-2 col-form-label" style="text-align: right">部門</label>
                                    <div class="col-9">
                                        <input type="hidden" class="form-control" id="modifyDepartment" name="modify_user_department" placeholder="請輸入部門" readonly>
                                        <input type="text" class="form-control" id="modifyDepartmentName" readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-2 col-form-label" for="selectGroup" style="text-align: right">身份</label>
                                    <div class="col-9">
                                        <input type="hidden" class="form-control" id="modifyselectGroup" name="modify_user_role" placeholder="請輸入身分" readonly>
                                        <input type="text" class="form-control" id="modifyRoleName" readonly>

                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                        <label for="inputOnBoard" class="col-2 col-form-label" style="text-align: right">到職日期</label>
                                        <div class="col-9">
                                            <input id="modifyOnBoard" name="modify_user_onboard" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" placeholder="請輸入到職日期" required readonly/>
                                            <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="form-group row">
                                <label for="inputEmail" class="col-2 col-form-label" style="text-align: right">Email</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="modifyEmail" name="modify_user_email" placeholder="請輸入Email" >
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 修改密碼彈出視窗 --}}
    <div class="modal fade" id="ModifyMemberPWDModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">修改人員資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="modifyuser" action="{{ route("update_userpwd") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="form-group row">
                                <label for="inputID" class="col-2 col-form-label" style="text-align: right">ID</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="modifyID_pwd" name="modify_user_id" placeholder="請輸入使用者編號" readonly>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputUserName" class="col-4 col-form-label" style="text-align: right">使用者名稱</label>
                                <div class="col-7">
                                    <input readonly type="text" class="form-control" id="modifyUserName" name="modify_username" placeholder="請輸入使用者名稱" required>
                                </div>
                                <div class="col-1"></div>
                            </div>
                            <div class="form-group row">
                                <label for="inputpwd" class="col-4 col-form-label" style="text-align: right">使用者密碼</label>
                                <div class="col-7">
                                    <input type="password" class="form-control" id="modifytpwd" maxlength="12" name="modify_password" placeholder="請輸入使用者密碼" required>
                                </div>
                                <div class="col-1"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- 部門編修彈出視窗 --}}
    <div class="modal fade" id="Department" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="overflow:visible;" >
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content" style="height: 600px">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">部門編修</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    <div class="modal-body row">
                        <input type="hidden" class="form-control" id="features_user" name="features_user" readonly>
                        <div class="col-12 text-center" style="height: 420px; overflow: auto">
                            <form action="{{ route("department_insert") }}" method="POST" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="form-group row">
                                    <label for="insert_department" class="col-3 col-form-label" style="text-align: right">部門名稱</label>
                                    <div class="col-7">
                                        <input type="text" class="form-control" id="insert_department" name="department_name" placeholder="請輸入部門名稱" required>
                                    </div>
                                    <div class="col-2">
                                        <button type="submit" class="btn btn-outline-primary">新增</button>
                                    </div>
                                </div>
                            </form>

                            <table class="table table-striped table-bordered table-hover" id="tableL03">
                                <tbody>
                                @foreach($departments as $department)
                                    <tr>
                                        <td>{{$department["no"]}}</td>
                                        <td>
                                            <h5 style="display: inline;cursor: pointer;" id="d_{{$department["no"]}}" onclick="updateDepartment_change('{{$department["no"]}}')">{{$department["department"]}}</h5>
                                            <input type="hidden" class="form-control" id="d_{{$department["no"]}}_input" name="insert_department" placeholder="請輸入部門名稱" value="{{$department["department"]}}" required>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-outline-info" onclick="updateDepartment('{{$department["no"]}}')">送出</button>
                                            <button type="button" class="btn btn-outline-danger" onclick="deleteDepartment('{{$department["no"]}}')">刪除</button>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" >
                        <button type="button" class="btn btn-primary" data-dismiss="modal">確定</button>
                    </div>
            </div>
        </div>
        <div>
        </div>
    </div>



    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif
    
    
<script>
    function selectPerson()
    {
        var person = document.getElementById("user_personid");
        var selectIndex = person.selectedIndex;
        document.getElementById("inputID").value=person.value;
        document.getElementById("inputName").value=person.options[selectIndex].text;

        //alert(person.value);
        //alert(person.options[selectIndex].text);
    }
    function updateDepartment_change(id)
    {
        var d_id = "d_"+id;
        var d_input_id = "d_"+id+"_input";
        var d_name = document.getElementById(d_id);
        var d_input = document.getElementById(d_input_id);
        d_name.style.display="none";
        d_input.type="text";
    }
    function updateDepartment(id)
    {
        var d_input_id = "d_"+id+"_input";
        var department_name = document.getElementById(d_input_id).value;
        //alert(department_name);
        var form=document.createElement("form");
        form.setAttribute("method","post");
        form.setAttribute("action","{{Route("department_update")}}");
        var no = document.createElement("input");
        no.setAttribute("type", "hidden");
        no.setAttribute("name", "department_no");
        no.setAttribute("value",id);
        form.appendChild(no);
        var name = document.createElement("input");
        name.setAttribute("type", "hidden");
        name.setAttribute("name", "department_name");
        name.setAttribute("value",department_name);
        form.appendChild(name);
        var csrfField=document.createElement("input");
        csrfField.setAttribute("type", "hidden");
        csrfField.setAttribute("name", "_token");
        csrfField.setAttribute("value", "{{ csrf_token() }}");
        form.appendChild(csrfField);
        document.body.appendChild(form);
        form.submit();
    }
    function deleteDepartment(id)
    {
        //alert(id);
        var form=document.createElement("form");
        form.setAttribute("method","post");
        form.setAttribute("action","{{Route("department_delete")}}");
        var no = document.createElement("input");
        no.setAttribute("type", "hidden");
        no.setAttribute("name", "department_no");
        no.setAttribute("value",id);
        form.appendChild(no);
        var csrfField=document.createElement("input");
        csrfField.setAttribute("type", "hidden");
        csrfField.setAttribute("name", "_token");
        csrfField.setAttribute("value", "{{ csrf_token() }}");
        form.appendChild(csrfField);
        document.body.appendChild(form);
        form.submit();
    }
</script>


    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
            <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif
    <script>
        $(function () {
            $("#logout").on("click",function () {
                alert("使用者已登出");
            })
        })
    </script>
{{--    boostrap tabel js--}}
    <script>
        // 載入人員資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷燬表格
        var tableColumns = [
            {field: 'state', checkbox: true,},
            {field: 'username',title: '使用者帳號',sortable: true},
            {field: 'role', title: '身份', sortable: true},
            {field: 'name', title: '姓名', sortable: true},
            {field: 'modify', title: '', sortable: false},
        ];
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'role', // 預設排序
        });
        var tableColumns2 = [
            {field: 'state', checkbox: false,},
            {field: 'no',title: '編號',sortable: false},
            {field: 'major_title', title: '類型', sortable: false},
            {field: 'name', title: '說明', sortable: false},
        ];
        $('#tableL02').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns2,  //表頭
            // width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            // height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'major_title', // 預設排序
        });
        
        var tableColumns3 = [
            {field: 'no',title: '編號',sortable: false,},
            {field: 'department', title: '名稱', sortable: false,width:"300"},
            {field: '', title: '', sortable: false},
        ];
        $('#tableL03').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns3,  //表頭
            //data:jdata3, //通過ajax返回的資料
            // width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            // height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'major_title', // 預設排序
        });

        
        // 修改人員資料處理
        function person_modify(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("modifyName").value=jdata[jdata_index].name;
            document.getElementById("modifyID").value=jdata[jdata_index].id;
            document.getElementById("modifyPersonId").value=jdata[jdata_index].person_id;
            document.getElementById("modifyDepartment").value=jdata[jdata_index].department;
            document.getElementById("modifyselectGroup").value=jdata[jdata_index].role_id;
            document.getElementById("modifyOnBoard").value=jdata[jdata_index].on_board;
            document.getElementById("modifyEmail").value=jdata[jdata_index].email;
            document.getElementById("modifyUserName").value=jdata[jdata_index].username;
            document.getElementById("modifytpwd").value=jdata[jdata_index].password;
            document.getElementById("modifyPersonName").value=jdata[jdata_index].person_name;
            document.getElementById("modifyDepartmentName").value=jdata[jdata_index].department_name;
            document.getElementById("modifyRoleName").value=jdata[jdata_index].role;
            // document.getElementById("role").value=jdata[jdata_index].role_id;
            // var role="0";
            // switch(jdata[jdata_index].role){
            //     case("Manager"):
            //         role = "3";
            //         break;
            //     case("User"):
            //         role ="5";
            //         break;
            //     default:
            //         break;
            // }
        }
        function person_modify_pwd(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("modifyID_pwd").value=jdata[jdata_index].id;
            document.getElementById("modifyUserName").value=jdata[jdata_index].username;
            document.getElementById("modifytpwd").value=jdata[jdata_index].password;
        }
        function features_modify(obj) {
            @foreach($features as $feature)
                document.getElementById("features_"+{{$feature["no"]}}).checked=false;
            @endforeach
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("features_user").value=jdata[jdata_index].id;
            // document.getElementById("features_user_role").value=jdata[jdata_index].role_id
            var auth=jdata[jdata_index].authority;
            // var auth_array=new Array();
            var auth_array=auth.split(",");
            // document.getElementById("features_"+auth_array[2]).checked=true;
            // document.getElementById("features_"+).checked=true;
            for (var i = 0; i < auth_array.length; i++) {
                // alert(auth_array[i]);
                if(auth_array[i]!="")
                {
                    document.getElementById("features_"+auth_array[i]).checked=true;
                }
            }
        }
        // html string to element
        function htmlToElement(html) {
            var template = document.createElement('template');
            html = html.trim(); // Never return a text node of whitespace as the result
            template.innerHTML = html;
            return template.content.firstChild;
        }
    </script>
    <script>
        function word() {
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("user_word") }}");
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <script>
        {{--    取得已選取目標--}}
        function getIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.id
            })
        }
        {{--刪除使用者--}}
        function post_delete_user() {
            let idselections=getIdSelections();
            if (confirm("是否刪除" +idselections)){
                var form=document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{Route("post_delete_user")}}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value",idselections);
                form.appendChild(idselectionsField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- datetimepicker3 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker3').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <script>
        $(function(){
            $("#insertuser").validate({
                rules: {
                    user_id: {
                        required: true,
                    },
                    user_name: {
                        required: true,
                    },
                    user_role: {
                        required: true,
                    },
                    user_username: {
                        required: true,
                    },
                    user_password: {
                        required: true,
                        minlength: 8,
                        checkpwdhard:true,
                    },
                },
                messages: {
                    user_id: {
                        required: '必填',
                    },
                    user_name: {
                        required: '必填',
                    },
                    user_role: {
                        required: '必填',
                    },
                    user_username: {
                        required: '必填',
                    },
                    user_password: {
                        required: '必填',
                        minlength: '請填寫8個字元',
                        checkpwdhard:'需英數混合',
                    },
                },
            });
        });
        jQuery.validator.addMethod("checkpwdhard", function( value, element ) {
            var str = value;
            var result = false;

            if(str.length > 0){
                var patt = /^[a-zA-Z0-9]{8,12}$/;
                var result1 = patt.test(str);
                //先測試是否有英文
                var pattEN = /[a-zA-Z]{1,}/;
                result2 = pattEN.test(str);
                //先測試是否有數字
                var pattDigit = /[0-9]{1,}/;
                result3 = pattDigit.test(str);

                if(result1 == true && result2 == true && result3 == true){
                    result = true;
                } else{
                    result = false;
                }
            } else {
                result = true;
            }
            return result;
        }, "密碼為 6個字元的英文字母、數字混合");
    </script>
    <script>
        $(function(){
            $("#modifyuser").validate({
                rules: {
                    modify_user_id: {
                        required: true,
                    },
                    modify_user_name: {
                        required: true,
                    },
                    modify_user_role: {
                        required: true,
                    },
                    modify_user_username: {
                        required: true,
                    },
                    modify_password: {
                        required: true,
                        minlength: 8,
                        checkpwdhard:true,
                    },
                },
                messages: {
                    modify_user_id: {
                        required: '必填',
                    },
                    modify_user_name: {
                        required: '必填',
                    },
                    modify_user_role: {
                        required: '必填',
                    },
                    modify_username: {
                        required: '必填',
                    },
                    modify_password: {
                        required: '必填',
                        minlength: '請填寫8個字元',
                        checkpwdhard:'請再次輸入密碼，需英數混合',
                    },
                },
            });
        });

    </script>
@endsection
