from base_resource import BaseResource
from mysql_model import DeviceTypeModel

# ========== 新增裝置資源 ==========
class DeviceTypeInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertDeviceType")
        self.parser.add_argument('name', required=True, help="設備名稱，上限 15 字")
        self.parser.add_argument('vendor', help="設備供應商名稱，上限 50 字")
        self.parser.add_argument('vendor_contact_person', help="設備供應商窗口，上限 20 字")
        self.parser.add_argument('vendor_contact_way', help="設備供應商窗口聯絡方式，上限 50 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceTypeModel.FromDBByName(args['name'], self.log.SetMessage)
        if not model.isExist:
            model.SetName(args['name'])
            model.SetVendor(args['vendor'])
            model.SetVendorContactPerson(args['vendor_contact_person'])
            model.SetVendorContactWay(args['vendor_contact_way'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "{0} inserted".format(args['name'])
            else:
                self.message = "{0} insert failed".format(args['name'])
        else:
            self.message = "{0} is exist in database".format(args['name'])
        return self.GetResponse()

# ========== 更新裝置資源 ==========
class DeviceTypeUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateDeviceType")
        self.parser.add_argument('id', required=True, help="設備編號")
        self.parser.add_argument('name', help="設備名稱，上限 15 字")
        self.parser.add_argument('vendor', help="設備供應商名稱，上限 50 字")
        self.parser.add_argument('vendor_contact_person', help="設備供應商窗口，上限 20 字")
        self.parser.add_argument('vendor_contact_way', help="設備供應商窗口聯絡方式，上限 50 字")
    def post(self):
        args = self.parser.parse_args()
        model = DeviceTypeModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            model.SetName(args['name'])
            model.SetVendor(args['vendor'])
            model.SetVendorContactPerson(args['vendor_contact_person'])
            model.SetVendorContactWay(args['vendor_contact_way'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeName():
                    self.message.append(
                        "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
                    )
                if model.HasChangeVendor():
                    self.message.append(
                        "Vendor: {0} -> {1}".format(model.GetOldVendor(), model.GetVendor())
                    )
                if model.HasChangeVendorContactPerson():
                    self.message.append(
                        "VendorContactPerson: {0} -> {1}".format(model.GetOldVendorContactPerson(), model.GetVendorContactPerson())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "{0} failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 刪除裝置資源 ==========
class DeviceTypeDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDeviceType")
        self.parser.add_argument('id', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = DeviceTypeModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['id'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 查詢所有裝置資源 ==========
class DeviceTypeSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectAllDeviceType")
    def post(self, ID=None):
        models = DeviceTypeModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()