from base_resource import BaseResource
from features_role_relation_model import FeaturesRoleRelationModel
# from werkzeug.datastructures import FileStorage
import os, werkzeug, base64, pandas as pd

# ========== 新增功能角色關係記錄 ==========
class FeaturesRoleRelationInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertFeaturesRoleRelation")
        self.parser.add_argument('role_id', required=True, help="角色編號")
        self.parser.add_argument('features_id', required=True, help="功能編號")
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesRoleRelationModel.FromDBByRoleFeatures(args['role_id'], args['features_id'], self.log.SetMessage)
        if not model.isExist:
            model.SetRoleId(args['role_id'])
            model.SetFeaturesId(args['features_id'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "Role：{0} Features：{1} inserted".format(args['role_id'], args['features_id'])
            else:
                self.message = "Role：{0} Features：{1} insert failed".format(args['role_id'], args['features_id'])
        else:
            self.message = "Role：{0} Features：{1} is exist in database".format(args['role_id'], args['features_id'])
        return self.GetResponse()

# ========== 更新功能角色關係紀錄 ==========
class FeaturesRoleRelationUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateFeaturesRoleRelation")
        self.parser.add_argument('no', required=True, help="關係編號")
        self.parser.add_argument('role_id', required=True, help="角色編號")
        self.parser.add_argument('features_id', required=True, help="功能編號")
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesRoleRelationModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetRoleId(args['role_id'])
            model.SetFeaturesId(args['features_id'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeRoleId():
                    self.message.append(
                        "RoleId: {0} -> {1}".format(model.GetOldRoleId(), model.GetRoleId())
                    )
                if model.HasChangeFeaturesId():
                    self.message.append(
                        "FeaturesId: {0} -> {1}".format(model.GetOldFeaturesId(), model.GetFeaturesId())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "Relation：{0} update failed".format(args['no'])
        else:
            self.message = "Relation：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()
# ========== 刪除功能角色關係紀錄 ==========
class FeaturesRoleRelationDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteFeaturesRoleRelation")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesRoleRelationModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "Relation：{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "Relation：{0} delete failed".format(args['no'])
        else:
            self.message = "Relation：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有功能角色關係紀錄 ==========
class FeaturesRoleRelationSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectFeaturesRoleRelation")
    def post(self, ID=None):
        models = FeaturesRoleRelationModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    