from mysql_model import BaseModel
import os, json, base64, requests
from dbsql import MySQL


env = os.environ
host = env['MYSQL_HOST']      if 'MYSQL_HOST' in env else "192.168.6.194"
port = int(env['MYSQL_PORT']) if 'MYSQL_PORT' in env else 23306
usr  = env['MYSQL_USR']       if 'MYSQL_USR'  in env else "root"
pwd  = env['MYSQL_PWD']       if 'MYSQL_PWD'  in env else "123456"
db   = env['MYSQL_DB']        if 'MYSQL_DB'   in env else "ecom"
mysql = MySQL(host, port, usr, pwd, db)

# ========== 班別資料庫模型 ==========
class ShiftModel(BaseModel):
    def __init__(self, ID=None):
        super().__init__()
        self.table = 'shift'
        if(ID != None):
            self.data['no'] = ID if isinstance(ID, str) else str(ID) 
        self.data['name'] = None
        self.data['start'] = None
        self.data['end'] = None
        self.data['note'] = None
    # ===== no ========================================
    def GetNo(self):
        return self.data['no'] if 'no' in self.data else None
    # ===== name ========================================
    def SetName(self, name):
        return self.SetValue('name', name, str, False)
    def GetName(self):
        return self.data['name'] if 'name' in self.data else None
    def GetOldName(self):
        return self.change['name']
    def HasChangeName(self):
        return 'name' in self.change
    # ===== start ========================================
    def SetStart(self, start):
        return self.SetValue('start', start, str, False)
    def GetStart(self):
        return self.data['start'] if 'start' in self.data else None
    def GetOldStart(self):
        return self.change['start']
    def HasChangeStart(self):
        return 'start' in self.change
    # ===== end ========================================
    def SetEnd(self, end):
        return self.SetValue('end', end, str, False)
    def GetEnd(self):
        return self.data['end'] if 'end' in self.data else None
    def GetOldEnd(self):
        return self.change['end']
    def HasChangeEnd(self):
        return 'end' in self.change
    # ===== note ========================================
    def SetNote(self, note):
        return self.SetValue('note', note, str, True)
    def GetNote(self):
        return self.data['note'] if 'note' in self.data else None
    def GetOldNote(self):
        return self.change['note']
    def HasChangeNote(self):
        return 'note' in self.change
    
    # ===== operate database ========================================
    def InsertToDB(self, log):
        keys = self.data.keys()
        values = [ self.data[x] for x in keys ]
        mysql.SetLog(log)
        script = mysql.Insert(self.table, keys, values)
        return script.Fetch()
    def UpdateToDB(self, log):
        script = None
        for k in self.data.keys():
            mysql.SetLog(log)
            script = mysql.Update(self.table, k, self.data[k]) if script is None else script.Add(k, self.data[k])
        script = script.Where('no', '=', self.data['no'])
        return script.FetchOne()
    def DeleteFromDB(self, log):
        script = mysql.Delete(self.table).Where('no', '=', self.data['no'])
        mysql.SetLog(log)
        return script.FetchOne()
    def ToDict(self):
        return {
            'no': self.GetNo(),
            'name': self.GetName(),
            'start': self.GetStart(),
            'end': self.GetEnd(),
            'note': self.GetNote(),
        }
    # ===== other ========================================
    @staticmethod
    def FromDB(ID, log):            
        model = ShiftModel(ID)
        mysql.SetLog(log)
        script = mysql.Select('shift').Where('no', '=', ID).FetchOne()
        if isinstance(script, tuple):
            model.SetName(script[1])
            model.SetStart(script[2])
            model.SetEnd(script[3])
            model.SetNote(script[4])
            model.SetCreated(script[5])
            model.SetUpdated(script[6])
            model.SetDeleted(script[7])
            model.isExist = True
        return model
    @staticmethod
    def FromDBByName(Name, log):            
        model = ShiftModel()
        mysql.SetLog(log)
        script = mysql.Select('shift').Where('name', '=', Name).FetchOne()
        if isinstance(script, tuple):
            model.SetName(script[1])
            model.SetStart(script[2])
            model.SetEnd(script[3])
            model.SetNote(script[4])
            model.SetCreated(script[5])
            model.SetUpdated(script[6])
            model.SetDeleted(script[7])
            model.isExist = True
        return model    
    @staticmethod
    def AllFromDB(log):
        models = []
        mysql.SetLog(log)
        script = mysql.Select('shift').FetchAll()
        for row in script:
            model = ShiftModel(row[0])
            model.SetName(row[1])
            model.SetStart(row[2])
            model.SetEnd(row[3])
            model.SetNote(row[4])
            model.SetCreated(row[5])
            model.SetUpdated(row[6])
            model.SetDeleted(row[7])
            model.isExist = True
            models.append(model)
        return models