from base_resource import BaseResource
from depart_leave_unit_model import DepartLeaveUnitModel

# ========== 新增部門請假簽呈單位 ==========
class DepartLeaveUnitInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertDepartLeaveUnit")
        self.parser.add_argument('department', help="隸屬部門")
        self.parser.add_argument('signing_unit_1', help="簽呈單位1")
        self.parser.add_argument('signing_unit_2', help="簽呈單位2")
        self.parser.add_argument('signing_unit_3', help="簽呈單位3")
    def post(self):
        args = self.parser.parse_args()
        model = DepartLeaveUnitModel.FromDBByDepartment(args['department'], self.log.SetMessage)
        if not model.isExist:
            model.SetDepartment(args['department'])
            model.SetSigningUnit1(args['signing_unit_1'])
            model.SetSigningUnit2(args['signing_unit_2'])
            model.SetSigningUnit3(args['signing_unit_3'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "Department：{0} inserted".format(args['department'])
            else:
                self.message = "Department：{0} insert failed".format(args['department'])
        else:
            self.message = "Department：{0} is exist in database".format(args['department'])
        return self.GetResponse()

# ========== 更新部門請假簽呈單位 ==========
class DepartLeaveUnitUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateDepartLeaveUnit")
        self.parser.add_argument('no', required=True, help="部門請假簽呈單位編號")        
        self.parser.add_argument('department', help="隸屬部門")
        self.parser.add_argument('signing_unit_1', help="簽呈單位1")
        self.parser.add_argument('signing_unit_2', help="簽呈單位2")
        self.parser.add_argument('signing_unit_3', help="簽呈單位3")
    def post(self):
        args = self.parser.parse_args()
        model = DepartLeaveUnitModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetDepartment(args['department'])
            model.SetSigningUnit1(args['signing_unit_1'])
            model.SetSigningUnit2(args['signing_unit_2'])
            model.SetSigningUnit3(args['signing_unit_3'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeDepartment():
                    self.message.append(
                        "Department: {0} -> {1}".format(model.GetOldDepartment(), model.GetDepartment())
                    )
                if model.HasChangeSigningUnit1():
                    self.message.append(
                        "SigningUnit1: {0} -> {1}".format(model.GetOldSigningUnit1(), model.GetSigningUnit1())
                    )
                if model.HasChangeSigningUnit2():
                    self.message.append(
                        "SigningUnit2: {0} -> {1}".format(model.GetOldSigningUnit2(), model.GetSigningUnit2())
                    )  
                if model.HasChangeSigningUnit3():
                    self.message.append(
                        "SigningUnit3: {0} -> {1}".format(model.GetOldSigningUnit3(), model.GetSigningUnit3())
                    )                   
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "Department：{0} update failed".format(args['department'])
        else:
            self.message = "Department：{0} isn't exist in database".format(args['department'])
        return self.GetResponse()
# ========== 刪除部門請假簽呈單位 ==========
class DepartLeaveUnitDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteDepartLeaveUnit")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = DepartLeaveUnitModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['no'])
        else:
            self.message = "{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有部門請假簽呈單位 ==========
class DepartLeaveUnitSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectDepartLeaveUnit")
    def post(self, ID=None):
        models = DepartLeaveUnitModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    