from base_resource import BaseResource
from features_user_relation_model import FeaturesUserRelationModel
# from werkzeug.datastructures import FileStorage
import os, werkzeug, base64, pandas as pd

# ========== 新增功能使用者關係記錄 ==========
class FeaturesUserRelationInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertFeaturesUserRelation")
        self.parser.add_argument('user_id', required=True, help="使用者編號")
        self.parser.add_argument('features_id', required=True, help="功能編號")
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesUserRelationModel.FromDBByUserFeatures(args['user_id'], args['features_id'], self.log.SetMessage)
        if not model.isExist:
            model.SetUserId(args['user_id'])
            model.SetFeaturesId(args['features_id'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "User：{0} Features：{1} inserted".format(args['user_id'], args['features_id'])
            else:
                self.message = "User：{0} Features：{1} insert failed".format(args['user_id'], args['features_id'])
        else:
            self.message = "User：{0} Features：{1} is exist in database".format(args['user_id'], args['features_id'])
        return self.GetResponse()

# ========== 更新功能使用者關係紀錄 ==========
class FeaturesUserRelationUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateFeaturesUserRelation")
        self.parser.add_argument('no', required=True, help="關係編號")
        self.parser.add_argument('user_id', required=True, help="使用者編號")
        self.parser.add_argument('features_id', required=True, help="功能編號")
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesUserRelationModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            model.SetUserId(args['user_id'])
            model.SetFeaturesId(args['features_id'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeUserId():
                    self.message.append(
                        "UserId: {0} -> {1}".format(model.GetOldUserId(), model.GetUserId())
                    )
                if model.HasChangeFeaturesId():
                    self.message.append(
                        "FeaturesId: {0} -> {1}".format(model.GetOldFeaturesId(), model.GetFeaturesId())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "Relation：{0} update failed".format(args['no'])
        else:
            self.message = "Relation：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()
# ========== 刪除功能使用者關係紀錄 ==========
class FeaturesUserRelationDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteFeaturesUserRelation")
        self.parser.add_argument('no', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = FeaturesUserRelationModel.FromDB(args['no'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "Relation：{0} deleted".format(args['no'], model.GetNow())
            else:
                self.message = "Relation：{0} delete failed".format(args['no'])
        else:
            self.message = "Relation：{0} isn't exist in database".format(args['no'])
        return self.GetResponse()    
# ========== 查詢所有功能使用者關係紀錄 ==========
class FeaturesUserRelationSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectFeaturesUserRelation")
    def post(self, ID=None):
        models = FeaturesUserRelationModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()    