﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
/// <summary>
/// 功能: 建立讀取資料夾之背景程序物件。
/// 維護: 
/// [108/04/24][14:35] > 完成基礎代碼撰寫，未測試。
/// 建立於: 108/04/24
/// </summary>
namespace ETC_App1
{
    public partial class ETCBackgroundWorker2 : BackgroundWorker
    {
        public string[] AllowExtension { get; set; } = { ".jpg", ".jpeg" };

        public string Filename { get; set; }

        public ETCBackgroundWorker2()
        {
            InitializeComponent();
        }

        private double Elapsed(long milliseconds, out string message)
        {
            double elapsed = Convert.ToDouble(milliseconds);

            message = "共耗時";

            if (elapsed >= 1000)
            {
                elapsed = elapsed / 1000;

                if (elapsed >= 60)
                {
                    elapsed = elapsed / 60;

                    if (elapsed >= 60)
                    {
                        elapsed = elapsed / 60;

                        if (elapsed >= 24)
                        {
                            elapsed = elapsed / 24;

                            message = message + "約 " + elapsed + " 天。";

                            return elapsed;
                        }

                        message = message + "約 " + elapsed + " 小時。";

                        return elapsed;
                    }

                    message = message + "約 " + elapsed + " 分鐘。";

                    return elapsed;
                }

                message = message + "約 " + elapsed + " 秒。";

                return elapsed;
            }

            message = message + " " + elapsed + " 毫秒。";

            return elapsed;
        }

        private string[] GetFiles(string path)
        {
            List<string> extension = new List<string>(AllowExtension);

            List<string> files = new List<string>();

            var temp = from f in Directory.GetFiles(path) where extension.Contains(Path.GetExtension(f)) select f;

            foreach (string d in Directory.GetDirectories(path))
            {
                files.AddRange(GetFiles(d));
            }

            files.AddRange(temp.ToArray());

            return files.ToArray();
        }

        protected override void OnDoWork(DoWorkEventArgs e)
        {
            Dictionary<string, string> images = new Dictionary<string, string>();

            string filename = (Filename = e.Argument as string);

            if (Directory.Exists(filename))
            {
                Stopwatch stopwatch = Stopwatch.StartNew();

                ReportProgress(0, "檔案搜尋中...");

                foreach (string d in Directory.GetDirectories(filename))
                {
                    string[] f = GetFiles(d);

                    for (int i = 0; i < f.Length; i++)
                    {
                        string name = Path.GetFileNameWithoutExtension(f[i]);

                        int index = name.IndexOf('_') + 1;

                        string key = name.Substring(index, name.Length - index);

                        images.Add(images.ContainsKey(key) ? key + "#" + i : key, f[i]);
                    }

                    ReportProgress(0, "找到 " + images.Count + " 個影像檔。");
                }

                ReportProgress(0, "檔案搜尋完成。");

                stopwatch.Stop();

                ReportProgress(Convert.ToInt32(Elapsed(stopwatch.ElapsedMilliseconds, out string message) * 100), "檔案搜尋，" + message);
            }

            e.Result = images;
        }
    }
}
