﻿using NPOI.HSSF.UserModel;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;




namespace ETC_App1
{
    
    public partial class Form1 : Form
    {
        private int index = 0;

        public Form1()
        {
            InitializeComponent();
        }

        private int ToolStripWidth
        {
            set
            {
                int width = value;

                toolStripComboBox1.Size = new Size(etcToolStrip1.UnusedWidth / 7, toolStripTextBox1.Size.Height);

                toolStripTextBox1.Size = new Size(etcToolStrip1.UnusedWidth / 7, toolStripTextBox1.Size.Height);

                toolStripTextBox2.Size = new Size(etcToolStrip1.UnusedWidth / 7, toolStripTextBox1.Size.Height);

                width = width - toolStripComboBox1.Size.Width - toolStripTextBox1.Size.Width - toolStripTextBox2.Size.Width;

                toolStripTextBox3.Size = new Size(width / 2, toolStripTextBox1.Size.Height);

                toolStripTextBox4.Size = new Size(width / 2, toolStripTextBox1.Size.Height);
            }
        }

        private bool IsLock
        {
            set
            {
                etcPictureCheckBox1.Visible = !value;

                toolStripTextBox1.Enabled = toolStripTextBox2.Enabled = value;

                toolStripButton1.Text = value ? "登入" : "登出";

                toolStripTextBox3.Enabled = toolStripTextBox4.Enabled = toolStripComboBox1.Enabled = !value;

                toolStripButton2.Enabled = toolStripButton3.Enabled = !value;

                toolStripButton4.Enabled = toolStripButton6.Enabled = !value;

                toolStripButton5.Enabled = false;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            TextBox textBox = toolStripTextBox2.Control as TextBox;
            
            textBox.PasswordChar = '*';

            ToolStripWidth = etcToolStrip1.UnusedWidth;

            //StatusStripWidth = etcStatusStrip1.Size.Width;

            IsLock = true;

            Text = "E-Eye 電子眼圖像辨識系統";
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            //Clipboard.SetText(Size.Width + "," + Size.Height);

            //Text = ClientSize.Width + "x" + ClientSize.Height;
        }

        private void EtcToolStrip1_Resize(object sender, EventArgs e)
        {
            ToolStripWidth = etcToolStrip1.UnusedWidth;
        }

        private void ToolStripButton1_Click(object sender, EventArgs e)
        {
            //int change=0;
            string ID = toolStripTextBox1.Text;
            string Password = toolStripTextBox2.Text;       //取得輸入的帳密
                                                            //if (change == 0)
                                                            //{
            if (Authentication.Authentication_1(ID, Password))
            {
                //change = 1;
                etcPictureCheckBox1.UsingID = ID;
                IsLock = false;                         //登入成功
            }
            //}
            /*
            else if (change == 1)
            {
                change = 0;
                IsLock = true;
            }
            */
        }


        private void ToolStripButton2_Click(object sender, EventArgs e)
        {
            string text = toolStripTextBox3.Text;

            toolStripTextBox3.Text = openFileDialog1.ShowDialog() == DialogResult.OK ? openFileDialog1.FileName : text;
        }

        private void ToolStripTextBox3_TextChanged(object sender, EventArgs e)
        {
            string text = toolStripTextBox3.Text;

            if (File.Exists(text) && !etcBackgroundWorker11.IsBusy)
            {
                toolStripTextBox3.ToolTipText = Path.GetFileName(text);

                toolStripTextBox4.Text = Path.GetDirectoryName(text);

                etcPictureCheckBox1.Clear();

                etcBackgroundWorker11.RunWorkerAsync(text);
            }
            else
                toolStripTextBox3.Text = etcBackgroundWorker11.Filename;
        }

        private void EtcBackgroundWorker11_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            etcPictureCheckBox1.ToolStripStatusLabel1 = e.UserState as string;

            toolStripButton1.Enabled = toolStripButton2.Enabled = false;

            toolStripComboBox1.Enabled = false;

            toolStripButton4.Enabled = toolStripButton5.Enabled = toolStripButton6.Enabled = false;
        }

        private void EtcBackgroundWorker11_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            Dictionary<string, List<Dictionary<string, string>>> data = e.Result as Dictionary<string, List<Dictionary<string, string>>>;

            etcBackgroundWorker31.Data.Clear();

            etcBackgroundWorker31.Data = data;

            toolStripButton1.Enabled = toolStripButton2.Enabled = true;

            toolStripComboBox1.Enabled = true;

            toolStripComboBox1.Items.AddRange(etcBackgroundWorker31.Data.Keys.ToArray());

            toolStripComboBox1.SelectedIndex = toolStripComboBox1.Items.Count > 0 ? 0 : -1;

            toolStripButton4.Enabled = toolStripButton6.Enabled = true;
        }

        private void ToolStripComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            int index = toolStripComboBox1.SelectedIndex;

            string key = index > -1 ? toolStripComboBox1.Items[index].ToString() : etcBackgroundWorker31.SelectedKey;

            etcBackgroundWorker31.SelectedKey = key;
        }
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            string text = toolStripTextBox4.Text;

            toolStripTextBox4.Text = folderBrowserDialog1.ShowDialog() == DialogResult.OK ? folderBrowserDialog1.SelectedPath : text;
        }

        private void toolStripTextBox4_TextChanged(object sender, EventArgs e)
        {
            string text = toolStripTextBox4.Text;

            if (Directory.Exists(text) && !etcBackgroundWorker21.IsBusy)
            {
                toolStripTextBox4.ToolTipText = Path.GetFileName(text);

                etcBackgroundWorker21.RunWorkerAsync(text);
            }
            else
                toolStripTextBox4.Text = etcBackgroundWorker21.Filename;
        }

        private void etcBackgroundWorker21_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            etcPictureCheckBox1.ToolStripStatusLabel2 = e.UserState as string;

            toolStripButton1.Enabled = toolStripButton3.Enabled = false;

            toolStripButton4.Enabled = toolStripButton5.Enabled = toolStripButton6.Enabled = false;
        }

        private void etcBackgroundWorker21_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            etcBackgroundWorker31.Images.Clear();

            etcBackgroundWorker31.Images = e.Result as Dictionary<string, string>;

            toolStripButton1.Enabled = toolStripButton3.Enabled = true;

            toolStripButton4.Enabled = toolStripButton6.Enabled = true;
        }

        private void ToolStripButton4_Click(object sender, EventArgs e)
        {
            toolStripComboBox1.Items.Clear();
            if (!etcBackgroundWorker31.IsBusy)
            {
                etcBackgroundWorker31.RunWorkerAsync(index);
            }
        }
        private void EtcBackgroundWorker31_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (e.UserState is Json)
            {
                etcPictureCheckBox1.Add(e.UserState as Json);
            }
            else
            {
                etcPictureCheckBox1.ToolStripStatusLabel4 = e.UserState as string;
            }

            etcPictureCheckBox1.ToolStripProgressBar = e.ProgressPercentage;

            etcPictureCheckBox1.ToolStripStatusLabel1 = "完成正確：" + etcPictureCheckBox1.Success;

            etcPictureCheckBox1.ToolStripStatusLabel2 = "資料異常：" + etcPictureCheckBox1.Failed;

            etcPictureCheckBox1.ToolStripStatusLabel3 = "影像遺失：" + etcPictureCheckBox1.Lost;

            toolStripButton1.Enabled = toolStripButton3.Enabled = false;

            toolStripButton4.Enabled = toolStripButton6.Enabled = false;

            toolStripButton5.Enabled = true;
        }

        private void EtcBackgroundWorker31_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            toolStripButton1.Enabled = toolStripButton3.Enabled = true;

            toolStripButton4.Enabled = toolStripButton6.Enabled = true;

            toolStripButton5.Enabled = false;

            index = Convert.ToInt32(e.Result);
        }

        private void ToolStripButton5_Click(object sender, EventArgs e)
        {
            etcBackgroundWorker11.CancelAsync();

            etcBackgroundWorker21.CancelAsync();

            etcBackgroundWorker31.CancelAsync();
        }

        private void ToolStripButton6_Click(object sender, EventArgs e)
        {
            BackgroundWorker worker = new BackgroundWorker() { WorkerReportsProgress = true, WorkerSupportsCancellation = true };

            worker.RunWorkerAsync(new object[] { etcPictureCheckBox1.Data, etcBackgroundWorker31.Data[etcBackgroundWorker31.SelectedKey] , toolStripTextBox4.Text });

            worker.DoWork += Worker_DoWork;
            worker.DoWork += Worker_DoWork_fail;
            etcPictureCheckBox1.SaveLogs(toolStripTextBox4.Text);

        }

        private void Worker_DoWork(object sender, DoWorkEventArgs e)
        {
            object[] arg = e.Argument as object[];

            List<Json> jsonData = arg[0] as List<Json>;

            List<Dictionary<string, string>> execlData = arg[1] as List<Dictionary<string, string>>;
            string file_path = arg[2] + "/success.xls";


            {
                HSSFWorkbook workbook2003 = new HSSFWorkbook(); //新建工作簿
                workbook2003.CreateSheet("Sheet1");  //新建1個Sheet工作表            
                HSSFSheet SheetOne = (HSSFSheet)workbook2003.GetSheet("Sheet1"); //獲取名稱為Sheet1的工作表
                SheetOne.CreateRow(0);
                SheetOne.GetRow(0).CreateCell(0).SetCellValue("序號");
                SheetOne.GetRow(0).CreateCell(1).SetCellValue("申訴單位");
                SheetOne.GetRow(0).CreateCell(2).SetCellValue("公警隊別");
                SheetOne.GetRow(0).CreateCell(3).SetCellValue( "起站國道編號");
                SheetOne.GetRow(0).CreateCell(4).SetCellValue( "起站收費區");
                SheetOne.GetRow(0).CreateCell(5).SetCellValue( "起站門架座落地點");
                SheetOne.GetRow(0).CreateCell(6).SetCellValue( "訖站國道編號");
                SheetOne.GetRow(0).CreateCell(7).SetCellValue( "訖站收費區");
                SheetOne.GetRow(0).CreateCell(8).SetCellValue( "訖站門架座落地點");
                SheetOne.GetRow(0).CreateCell(9).SetCellValue( "訖站時間");
                SheetOne.GetRow(0).CreateCell(10).SetCellValue( "帳單編號");
                SheetOne.GetRow(0).CreateCell(11).SetCellValue( "交易日");
                SheetOne.GetRow(0).CreateCell(12).SetCellValue( "車牌號碼");
                SheetOne.GetRow(0).CreateCell(13).SetCellValue( "車型");
                SheetOne.GetRow(0).CreateCell(14).SetCellValue( "車主");
                SheetOne.GetRow(0).CreateCell(15).SetCellValue( "車主證號");
                SheetOne.GetRow(0).CreateCell(16).SetCellValue( "改寄人");
                SheetOne.GetRow(0).CreateCell(17).SetCellValue( "改寄人證號");
                SheetOne.GetRow(0).CreateCell(18).SetCellValue( "改寄人生日");
                SheetOne.GetRow(0).CreateCell(19).SetCellValue( "改寄人應到案處所");
                SheetOne.GetRow(0).CreateCell(20).SetCellValue( "申裝類別");
                SheetOne.GetRow(0).CreateCell(21).SetCellValue( "通行費淨額");
                SheetOne.GetRow(0).CreateCell(22).SetCellValue( "欠費原因");
                SheetOne.GetRow(0).CreateCell(23).SetCellValue( "繳款期限");
                SheetOne.GetRow(0).CreateCell(24).SetCellValue( "偵測之eTag ID");
                SheetOne.GetRow(0).CreateCell(25).SetCellValue( "帳單地址");
                SheetOne.GetRow(0).CreateCell(26).SetCellValue( "帳單地址類別");
                SheetOne.GetRow(0).CreateCell(27).SetCellValue( "改寄類別");
                int i = 0;                                     //紀錄筆數
                int j = 1;                                     //資料寫入第幾列

                foreach (Json json in jsonData)
                {
                    bool success = json.success;
                    if (success)
                        if (i < execlData.Count)
                        {
                            SheetOne.CreateRow(j);

                            SheetOne.GetRow(j).CreateCell(0).SetCellValue(execlData[i]["序號"]);
                            SheetOne.GetRow(j).CreateCell(1).SetCellValue(execlData[i]["申訴單位"]);
                            SheetOne.GetRow(j).CreateCell(2).SetCellValue(execlData[i]["公警隊別"]);
                            SheetOne.GetRow(j).CreateCell(3).SetCellValue(execlData[i]["起站國道編號"]);
                            SheetOne.GetRow(j).CreateCell(4).SetCellValue(execlData[i]["起站收費區"]);
                            SheetOne.GetRow(j).CreateCell(5).SetCellValue(execlData[i]["起站門架座落地點"]);
                            SheetOne.GetRow(j).CreateCell(6).SetCellValue(execlData[i]["訖站國道編號"]);
                            SheetOne.GetRow(j).CreateCell(7).SetCellValue(execlData[i]["訖站收費區"]);
                            SheetOne.GetRow(j).CreateCell(8).SetCellValue(execlData[i]["訖站門架座落地點"]);
                            SheetOne.GetRow(j).CreateCell(9).SetCellValue(execlData[i]["訖站時間"]);
                            SheetOne.GetRow(j).CreateCell(10).SetCellValue(execlData[i]["帳單編號"]);
                            SheetOne.GetRow(j).CreateCell(11).SetCellValue(execlData[i]["交易日"]);
                            SheetOne.GetRow(j).CreateCell(12).SetCellValue(execlData[i]["車牌號碼"]);
                            SheetOne.GetRow(j).CreateCell(13).SetCellValue(execlData[i]["車型"]);
                            SheetOne.GetRow(j).CreateCell(14).SetCellValue(execlData[i]["車主"]);
                            SheetOne.GetRow(j).CreateCell(15).SetCellValue(execlData[i]["車主證號"]);
                            SheetOne.GetRow(j).CreateCell(16).SetCellValue(execlData[i]["改寄人"]);
                            SheetOne.GetRow(j).CreateCell(17).SetCellValue(execlData[i]["改寄人證號"]);
                            SheetOne.GetRow(j).CreateCell(18).SetCellValue(execlData[i]["改寄人生日"]);
                            SheetOne.GetRow(j).CreateCell(19).SetCellValue(execlData[i]["改寄人應到案處所"]);
                            SheetOne.GetRow(j).CreateCell(20).SetCellValue(execlData[i]["申裝類別"]);
                            SheetOne.GetRow(j).CreateCell(21).SetCellValue(execlData[i]["通行費淨額"]);
                            SheetOne.GetRow(j).CreateCell(22).SetCellValue(execlData[i]["欠費原因"]);
                            SheetOne.GetRow(j).CreateCell(23).SetCellValue(execlData[i]["繳款期限"]);
                            SheetOne.GetRow(j).CreateCell(24).SetCellValue(execlData[i]["偵測之eTag ID"]);
                            SheetOne.GetRow(j).CreateCell(25).SetCellValue(execlData[i]["帳單地址"]);
                            SheetOne.GetRow(j).CreateCell(26).SetCellValue(execlData[i]["帳單地址類別"]);
                            SheetOne.GetRow(j).CreateCell(27).SetCellValue(execlData[i]["改寄類別"]);

                            j += 1;
                        }
                    i = i + 1;
                }
                FileStream file2003 = new FileStream(file_path, FileMode.Create);
                workbook2003.Write(file2003);
                file2003.Close();
                workbook2003.Close();
            }
               
            }


        private void Worker_DoWork_fail(object sender, DoWorkEventArgs e)   //失敗結果的存檔(正確結果用括弧表示)
        {
            object[] arg = e.Argument as object[];

            List<Json> jsonData = arg[0] as List<Json>;  //判斷單號的json

            List<Dictionary<string, string>> execlData = arg[1] as List<Dictionary<string, string>>; //讀原excel的資料

            string file_path = arg[2] + "/failed.xls";  //指定存檔位置(改檔名)

            HSSFWorkbook workbook2003 = new HSSFWorkbook(); //新建工作簿
            workbook2003.CreateSheet("Sheet1");  //新建1個Sheet工作表            
            HSSFSheet SheetOne = (HSSFSheet)workbook2003.GetSheet("Sheet1"); //獲取名稱為Sheet1的工作表
            SheetOne.CreateRow(0);                                          //建立第一列的開頭資料
            SheetOne.GetRow(0).CreateCell(0).SetCellValue("序號");
            SheetOne.GetRow(0).CreateCell(1).SetCellValue("申訴單位");
            SheetOne.GetRow(0).CreateCell(2).SetCellValue("公警隊別");
            SheetOne.GetRow(0).CreateCell(3).SetCellValue("起站國道編號");
            SheetOne.GetRow(0).CreateCell(4).SetCellValue("起站收費區");
            SheetOne.GetRow(0).CreateCell(5).SetCellValue("起站門架座落地點");
            SheetOne.GetRow(0).CreateCell(6).SetCellValue("訖站國道編號");
            SheetOne.GetRow(0).CreateCell(7).SetCellValue("訖站收費區");
            SheetOne.GetRow(0).CreateCell(8).SetCellValue("訖站門架座落地點");
            SheetOne.GetRow(0).CreateCell(9).SetCellValue("訖站時間");
            SheetOne.GetRow(0).CreateCell(10).SetCellValue("帳單編號");
            SheetOne.GetRow(0).CreateCell(11).SetCellValue("交易日");
            SheetOne.GetRow(0).CreateCell(12).SetCellValue("車牌號碼");
            SheetOne.GetRow(0).CreateCell(13).SetCellValue("車型");
            SheetOne.GetRow(0).CreateCell(14).SetCellValue("車主");
            SheetOne.GetRow(0).CreateCell(15).SetCellValue("車主證號");
            SheetOne.GetRow(0).CreateCell(16).SetCellValue("改寄人");
            SheetOne.GetRow(0).CreateCell(17).SetCellValue("改寄人證號");
            SheetOne.GetRow(0).CreateCell(18).SetCellValue("改寄人生日");
            SheetOne.GetRow(0).CreateCell(19).SetCellValue("改寄人應到案處所");
            SheetOne.GetRow(0).CreateCell(20).SetCellValue("申裝類別");
            SheetOne.GetRow(0).CreateCell(21).SetCellValue("通行費淨額");
            SheetOne.GetRow(0).CreateCell(22).SetCellValue("欠費原因");
            SheetOne.GetRow(0).CreateCell(23).SetCellValue("繳款期限");
            SheetOne.GetRow(0).CreateCell(24).SetCellValue("偵測之eTag ID");
            SheetOne.GetRow(0).CreateCell(25).SetCellValue("帳單地址");
            SheetOne.GetRow(0).CreateCell(26).SetCellValue("帳單地址類別");
            SheetOne.GetRow(0).CreateCell(27).SetCellValue("改寄類別");
            int i = 0;                                     //紀錄筆數
            int j = 1;                                     //資料寫入第幾列，J=1是為了預留第一列的空間放開頭

            foreach (Json json in jsonData)                 //尋找每一筆資料對應的json結果
            {
                bool success = json.success;
                if (!success)                               //如果不對則寫入(判斷對的時候去掉"!")
                    if (i < execlData.Count)                //確保不會超出
                    {
                        SheetOne.CreateRow(j);              //建立相對的列

                        SheetOne.GetRow(j).CreateCell(0).SetCellValue(execlData[i]["序號"]);
                        SheetOne.GetRow(j).CreateCell(1).SetCellValue(execlData[i]["申訴單位"]);
                        SheetOne.GetRow(j).CreateCell(2).SetCellValue(execlData[i]["公警隊別"]);
                        SheetOne.GetRow(j).CreateCell(3).SetCellValue(execlData[i]["起站國道編號"]);
                        SheetOne.GetRow(j).CreateCell(4).SetCellValue(execlData[i]["起站收費區"]);
                        SheetOne.GetRow(j).CreateCell(5).SetCellValue(execlData[i]["起站門架座落地點"]);
                        SheetOne.GetRow(j).CreateCell(6).SetCellValue(execlData[i]["訖站國道編號"]);
                        SheetOne.GetRow(j).CreateCell(7).SetCellValue(execlData[i]["訖站收費區"]);
                        SheetOne.GetRow(j).CreateCell(8).SetCellValue(execlData[i]["訖站門架座落地點"]);
                        SheetOne.GetRow(j).CreateCell(9).SetCellValue(execlData[i]["訖站時間"]);
                        SheetOne.GetRow(j).CreateCell(10).SetCellValue(execlData[i]["帳單編號"]);
                        SheetOne.GetRow(j).CreateCell(11).SetCellValue(execlData[i]["交易日"]);
                        SheetOne.GetRow(j).CreateCell(12).SetCellValue(execlData[i]["車牌號碼"]);
                        SheetOne.GetRow(j).CreateCell(13).SetCellValue(execlData[i]["車型"]);
                        SheetOne.GetRow(j).CreateCell(14).SetCellValue(execlData[i]["車主"]);
                        SheetOne.GetRow(j).CreateCell(15).SetCellValue(execlData[i]["車主證號"]);
                        SheetOne.GetRow(j).CreateCell(16).SetCellValue(execlData[i]["改寄人"]);
                        SheetOne.GetRow(j).CreateCell(17).SetCellValue(execlData[i]["改寄人證號"]);
                        SheetOne.GetRow(j).CreateCell(18).SetCellValue(execlData[i]["改寄人生日"]);
                        SheetOne.GetRow(j).CreateCell(19).SetCellValue(execlData[i]["改寄人應到案處所"]);
                        SheetOne.GetRow(j).CreateCell(20).SetCellValue(execlData[i]["申裝類別"]);
                        SheetOne.GetRow(j).CreateCell(21).SetCellValue(execlData[i]["通行費淨額"]);
                        SheetOne.GetRow(j).CreateCell(22).SetCellValue(execlData[i]["欠費原因"]);
                        SheetOne.GetRow(j).CreateCell(23).SetCellValue(execlData[i]["繳款期限"]);
                        SheetOne.GetRow(j).CreateCell(24).SetCellValue(execlData[i]["偵測之eTag ID"]);
                        SheetOne.GetRow(j).CreateCell(25).SetCellValue(execlData[i]["帳單地址"]);
                        SheetOne.GetRow(j).CreateCell(26).SetCellValue(execlData[i]["帳單地址類別"]);
                        SheetOne.GetRow(j).CreateCell(27).SetCellValue(execlData[i]["改寄類別"]);
                        j += 1;         //有寫入資料要換下一列

                    }
                i = i + 1;              //判斷完資料要換下一筆
            }
            FileStream file2003 = new FileStream(file_path, FileMode.Create);
            workbook2003.Write(file2003);
            file2003.Close();
            workbook2003.Close();
        }
    }
    }

