﻿using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;

namespace NHPB
{
    public class ImageList
    {
        public static Bitmap Combine(string[] filenames)
        {
            List<Bitmap> images1 = new List<Bitmap>();

            List<Bitmap> images2 = new List<Bitmap>();

            Bitmap image1 = null, image2 = null;

            int width = 0, height = 0;

            for (int i = 0; i < filenames.Length; i++)
            {
                FileStream file = new FileStream(filenames[i], FileMode.Open);

                MemoryStream memory = new MemoryStream();

                file.CopyTo(memory);

                file.Close();

                memory.Flush();

                Bitmap image = new Bitmap(memory);

                if (image.Size.Width >= image.Size.Height)
                {
                    images1.Add(image);

                    width = width + image.Size.Width;

                    height = height + image.Size.Height;

                    //width = width > image.Size.Width || width == 0 ? image.Size.Width : width;

                    //height = height > image.Size.Height || height == 0 ? image.Size.Height : height;
                }
                else
                {
                    //images2.Add(image);

                    image.RotateFlip(RotateFlipType.Rotate90FlipNone);

                    images1.Add(image);
                }
            }

            width = width / images1.Count;

            height = height / images1.Count;

            switch (images1.Count)
            {
                //case 2:
                //    image1 = Combine2(images1.ToArray(), 0, width, height); break;
                //case 3:
                //    image1 = Combine3(images1.ToArray(), 0, width, height); break;
                //case 4:
                //    image1 = Combine4(images1.ToArray(), 0, width, height); break;
                //case 5:
                //    image1 = Combine5(images1.ToArray(), 0, width, height); break;
                //case 6:
                //    image1 = Combine6(images1.ToArray(), 0, width, height); break;
                //case 7:
                //    image1 = Combine7(images1.ToArray(), 0, width, height); break;
                //case 8:
                //    image1 = Combine8(images1.ToArray(), 0, width, height); break;
                //case 9:
                //    image1 = Combine9(images1.ToArray(), 0, width, height); break;
                case 2:
                    image1 = Combine6(images1.ToArray(), 0, width, height); break;
                case 3:
                    image1 = Combine6(images1.ToArray(), 0, width, height); break;
                case 4:
                    image1 = Combine6(images1.ToArray(), 0, width, height); break;
                case 5:
                    image1 = Combine6(images1.ToArray(), 0, width, height); break;
                case 6:
                    image1 = Combine6(images1.ToArray(), 0, width, height); break;
                default:
                    image1 = Combine6(images1.ToArray(), 0, width, height); break;
            }

            //switch (images2.Count)
            //{
            //    case 2:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 1);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //    case 3:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 1);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //    case 4:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 1);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //    case 5:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 2);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //    case 6:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 2);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //    case 7:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 2);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //    case 8:
            //        image2 = Combine(images2.ToArray(), 0, width / 4, height, 3, 2);

            //        image1 = images1.Count > 0 ? Combine(new Bitmap[] { image1, image2 }, 0, width, height, 1, 2) : image2;

            //        break;
            //}

            return image1;
        }

        public static Bitmap Combine(Bitmap[] images, int startIndex, int maxWidth, int maxHeight, int countX, int countY)
        {
            //Bitmap image = new Bitmap(maxWidth / (countX == countY ? 1 : countY), maxHeight / (countX == countY ? 1 : countX));

            Bitmap image = new Bitmap(maxWidth * countX, maxHeight * countY);

            Graphics g = Graphics.FromImage(image);

            int i = startIndex, max = countX > countY ? countX : countY;

            g.InterpolationMode = InterpolationMode.High;

            g.SmoothingMode = SmoothingMode.HighQuality;

            g.Clear(Color.Black);

            for (int y = 0; y < countY && i < images.Length; y++)
            {
                for (int x = 0; x < countX && i < images.Length; x++)
                {
                    //Rectangle rect1 = new Rectangle(x * maxWidth / countX, y * maxHeight / countY, maxWidth / max, maxHeight / max);

                    Rectangle rect1 = new Rectangle(x * maxWidth, y * maxHeight, maxWidth, maxHeight);

                    Rectangle rect2 = new Rectangle(0, 0, images[i].Width, images[i].Height);

                    g.DrawImage(images[i++], rect1, rect2, GraphicsUnit.Pixel);

                    g.Save();
                }
            }
            
            return image;
        }

        public static Bitmap Combine2(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            return Combine(images, startIndex, maxWidth, maxHeight, 1, 2);
        }

        public static Bitmap Combine3(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            return Combine(images, startIndex, maxWidth, maxHeight, 2, 2);
        }

        public static Bitmap Combine4(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            return Combine(images, startIndex, maxWidth, maxHeight, 2, 2);
        }

        public static Bitmap Combine5(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            return Combine6(images, startIndex, maxWidth, maxHeight);
        }

        public static Bitmap Combine6(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            Bitmap image = new Bitmap(maxWidth, maxHeight);

            Graphics g = Graphics.FromImage(image);

            Font f1 = new Font(FontFamily.GenericMonospace, 144, FontStyle.Bold);

            Font f2 = new Font(FontFamily.GenericMonospace, 72, FontStyle.Bold);

            Point p1 = new Point(image.Width / 20, image.Height / 20);

            Point p2 = new Point(image.Width / 40, image.Height / 40);

            //Rectangle rect1 = new Rectangle(0, 0, maxWidth * 2 / 3, maxHeight * 2 / 3);

            Rectangle rect1 = new Rectangle(maxWidth / 3, 0, maxWidth * 2 / 3, maxHeight * 2 / 3);

            Rectangle rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

            g.InterpolationMode = InterpolationMode.High;

            g.SmoothingMode = SmoothingMode.HighQuality;

            g.Clear(Color.Black);

            if (startIndex < images.Length)
            {
                Graphics tmp = Graphics.FromImage(images[startIndex]);

                rect1 = new Rectangle(0, 0, maxWidth / 3, maxHeight / 3);

                rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

                SizeF size = tmp.MeasureString(startIndex.ToString(), f2);

                while (maxHeight / 20 > size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size + 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                while (maxHeight / 20 < size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size - 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                tmp.DrawString(startIndex.ToString(), f2, Brushes.Red, p2);

                tmp.Save();

                g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            }

            if (startIndex < images.Length)
            {
                Graphics tmp = Graphics.FromImage(images[startIndex]);

                rect1 = new Rectangle(0, 0, maxWidth / 3, maxHeight / 3);

                rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

                SizeF size = tmp.MeasureString(startIndex.ToString(), f2);

                while (maxHeight / 20 > size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size + 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                while (maxHeight / 20 < size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size - 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                tmp.DrawString(startIndex.ToString(), f1, Brushes.Red, p1);

                tmp.Save();

                g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            }

            if (startIndex < images.Length)
            {
                Graphics tmp = Graphics.FromImage(images[startIndex]);

                rect1 = new Rectangle(0, maxHeight / 3, maxWidth / 3, maxHeight / 3);

                rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

                SizeF size = tmp.MeasureString(startIndex.ToString(), f2);

                while (maxHeight / 20 > size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size + 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                while (maxHeight / 20 < size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size - 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                tmp.DrawString(startIndex.ToString(), f1, Brushes.Red, p1);

                tmp.Save();

                g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            }

            if (startIndex < images.Length)
            {
                Graphics tmp = Graphics.FromImage(images[startIndex]);

                rect1 = new Rectangle(0, maxHeight * 2 / 3, maxWidth / 3, maxHeight / 3);

                rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

                SizeF size = tmp.MeasureString(startIndex.ToString(), f2);

                while (maxHeight / 20 > size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size + 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                while (maxHeight / 20 < size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size - 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                tmp.DrawString(startIndex.ToString(), f1, Brushes.Red, p1);

                tmp.Save();

                g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            }

            if (startIndex < images.Length)
            {
                Graphics tmp = Graphics.FromImage(images[startIndex]);

                rect1 = new Rectangle(maxWidth / 3, maxHeight * 2 / 3, maxWidth / 3, maxHeight / 3);

                rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

                SizeF size = tmp.MeasureString(startIndex.ToString(), f2);

                while (maxHeight / 20 > size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size + 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                while (maxHeight / 20 < size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size - 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                tmp.DrawString(startIndex.ToString(), f1, Brushes.Red, p1);

                tmp.Save();

                g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            }

            if (startIndex < images.Length)
            {
                Graphics tmp = Graphics.FromImage(images[startIndex]);

                rect1 = new Rectangle(maxWidth * 2 / 3, maxHeight * 2 / 3, maxWidth / 3, maxHeight / 3);

                rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

                SizeF size = tmp.MeasureString(startIndex.ToString(), f2);

                while (maxHeight / 20 > size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size + 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }

                while (maxHeight / 20 < size.Height)
                {
                    f2 = new Font(f2.FontFamily, f2.Size - 1, f2.Style);

                    size = tmp.MeasureString(startIndex.ToString(), f2);
                }
                
                tmp.DrawString(startIndex.ToString(), f1, Brushes.Red, p1);

                tmp.Save();

                g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            }

            //if (startIndex < images.Length)
            //{
            //    rect1 = new Rectangle(maxWidth * 2 / 3, 0, maxWidth / 3, maxHeight / 3);

            //    rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

            //    g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            //}

            //if (startIndex < images.Length)
            //{
            //    rect1 = new Rectangle(maxWidth * 2 / 3, maxHeight / 3, maxWidth / 3, maxHeight / 3);

            //    rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

            //    g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            //}

            //if (startIndex < images.Length)
            //{
            //    rect1 = new Rectangle(0, maxHeight * 2 / 3, maxWidth / 3, maxHeight / 3);

            //    rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

            //    g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            //}

            //if (startIndex < images.Length)
            //{
            //    rect1 = new Rectangle(maxWidth / 3, maxHeight * 2 / 3, maxWidth / 3, maxHeight / 3);

            //    rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

            //    g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            //}

            //if (startIndex < images.Length)
            //{
            //    rect1 = new Rectangle(maxWidth * 2 / 3, maxHeight * 2 / 3, maxWidth / 3, maxHeight / 3);

            //    rect2 = new Rectangle(0, 0, images[startIndex].Width, images[startIndex].Height);

            //    g.DrawImage(images[startIndex++], rect1, rect2, GraphicsUnit.Pixel);
            //}

            return image;
        }

        public static Bitmap Combine7(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            int i = startIndex;

            Bitmap[] newImages = new Bitmap[] { images[i++], images[i++], images[i++], Combine4(images, i, maxWidth, maxHeight) };

            return Combine(newImages, 0, maxWidth, maxHeight, 2, 2);
        }

        public static Bitmap Combine8(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            int i = startIndex;

            Bitmap[] newImages = new Bitmap[] { images[i++], images[i++], images[i++], Combine5(images, i, maxWidth, maxHeight) };

            return Combine(newImages, 0, maxWidth, maxHeight, 2, 2);
        }

        public static Bitmap Combine9(Bitmap[] images, int startIndex, int maxWidth, int maxHeight)
        {
            int i = startIndex;

            Bitmap[] newImages = new Bitmap[] { images[i++], images[i++], images[i++], Combine6(images, i, maxWidth, maxHeight) };

            return Combine(newImages, 0, maxWidth, maxHeight, 2, 2);
        }
    }
}
