#!/usr/bin/env python

# NOTE: Run with PYTHONPATH=. python example/app.py

from flask import Flask,session
from flask_sqlalchemy import SQLAlchemy
from flask_cors import CORS
from flask_restful_swagger_2 import Api, swagger
from datetime import timedelta

app = Flask(__name__)
# 設置session SECRET_KEY
app.config['SECRET_KEY'] = "Ecom84253675"
# 設置session life time
app.config['PERMANENT_SESSION_LIFETIME'] = timedelta(days=1)

CORS(app)
api = Api(app, api_version='0.1', api_spec_url='/api/swagger')
# 設定資料庫位置，並建立 app
app.config['SQLALCHEMY_TRACK_MODIFICATIONS']=True
app.config['SQLALCHEMY_DATABASE_URI'] = 'mysql+pymysql://root:123456@TicketRecognitionMysqlDev:3306/ecom'
db = SQLAlchemy(app)

def auth(api_key, endpoint, method):
    # Space for your fancy authentication. Return True if access is granted, otherwise False
    print(api_key, endpoint, method)
    if('login' in endpoint):
        return True
    if(session.get('account') is None):
        return False
    else:
        return True

if __name__ == '__main__':
    import os, sys
    sys.path.append(os.path.join('./', 'resources'))
    from UserResource import GetAllUsers,GetUser,CreateUser,DeleteUser,UpdateUser,UserLogin,UserLogout
        
    swagger.auth = auth

    api.add_resource(GetAllUsers, '/api/users')
    api.add_resource(GetUser, '/api/user/<string:account>')
    api.add_resource(CreateUser, '/api/create/user')
    api.add_resource(DeleteUser, '/api/delete/user')
    api.add_resource(UpdateUser, '/api/update/user')
    api.add_resource(UserLogin, '/api/login')
    api.add_resource(UserLogout, '/api/logout')
    
    @app.route('/swagger')
    def index():
        return """<head>
        <meta http-equiv="refresh" content="0; url=http://petstore.swagger.io/?url=http://localhost:5000/api/swagger.json" />
        </head>"""
    
    app.run(debug=True, host='0.0.0.0',port=8000)
