from flask_restful.reqparse import RequestParser
from flask_restful_swagger_2 import swagger, Resource
from flask import session
import os, sys
sys.path.append(os.path.join('./', 'models'))

from UserModel import Users,db

class GetAllUsers(Resource):
    @swagger.doc({
        'tags': ['user'],
        'description': 'Returns all user',
        'parameters': [
        ],
        'responses': {
            '200': {
                'description': 'User',
                'examples': {
                    'application/json': {
                        "count":1,
                        "users":{
                            'id': 1,
                            'name': 'somebody',
                            'account':'account'
                        }
                        
                    }
                }
            }
        }
     })
    def get(self):
        users = db.session.query(Users).all()
        response = {"count":len(users),"users":[]}
        for user in users:
            data = {"id":user._id,"account":user.account,"name":user.name}
            response["users"].append(data)
        return response,200
    
class GetUser(Resource):
    @swagger.doc({
        'tags': ['user'],
        'description': 'Returns all user',
        'parameters': [
        ],
        'responses': {
            '200': {
                'description': 'User',
                'examples': {
                    'application/json': {
                        "count":1,
                        "users":{
                            'id': 1,
                            'name': 'somebody',
                            'account':'account'
                        }
                        
                    }
                }
            }
        }
     })
    def get(self,account):
        users = db.session.query(Users).filter_by(account=account).all()
        response = {"count":len(users),"users":[]}
        for user in users:
            data = {"id":user._id,"account":user.account,"name":user.name}
            response["users"].append(data)
        return response,200
            
        
        
class CreateUser(Resource):
    post_parser = RequestParser()
    post_parser.add_argument('name', type=str, required=True)
    post_parser.add_argument('account', type=str, required=True)
    post_parser.add_argument('password', type=str, required=True)
    post_parser.add_argument('repassword', type=str, required=True)
    @swagger.doc({
        'tags': ['user'],
        'description': 'Create user',
        'reqparser': {'name': 'UserModel',
                      'parser': post_parser},
        'responses': {
            '201': {
                'description': 'User',
                'examples': {
                    'application/json': {
                        'msg':"新增成功"
                    }
                },
            }
        }
     })
    def post(self):
        args = self.post_parser.parse_args()
        # 檢查是否有重複帳號
        if(db.session.query(Users).filter_by(account=args['account']).count()>0):
            return {"msg":"已有重複帳號"},500
        # 檢查密碼兩次輸入是否相同
        if(args["password"] != args["repassword"]):
            return {"msg":"兩次輸入的密碼不同"},500
        # 新增至資料庫
        new_user = Users(name=args["name"],account=args["account"],password=args["password"])
        db.session.add(new_user)
        db.session.commit()
        db.session.refresh(new_user)
        return {"msg":"新增成功",'id':new_user._id},201


class DeleteUser(Resource):
    post_parser = RequestParser()
    post_parser.add_argument('id', type=int, required=True)
    @swagger.doc({
        'tags': ['user'],
        'description': 'Delete user',
        'reqparser': {'name': 'UserModel',
                      'parser': post_parser},
        'responses': {
            '200': {
                'description': 'User',
                'examples': {
                    'application/json': {
                        'msg':"山除成功"
                    }
                },
            }
        }
     })
    def post(self):
        args = self.post_parser.parse_args()
        # 檢查帳號是否存
        user = db.session.query(Users).filter_by(_id=args['id'])
        if(user.count() == 0):
            return {"msg":"帳號不存在"},500
        # 刪除帳號
        user.delete()
        db.session.commit()
        return {"msg":"刪除成功",'id':args['id']},200
    
    
class UpdateUser(Resource):
    post_parser = RequestParser()
    post_parser.add_argument('name', type=str, required=True)
    post_parser.add_argument('account', type=str, required=True)
    post_parser.add_argument('password', type=str, required=True)
    post_parser.add_argument('repassword', type=str, required=True)
    @swagger.doc({
        'tags': ['user'],
        'description': 'update user',
        'reqparser': {'name': 'UserModel',
                      'parser': post_parser},
        'responses': {
            '201': {
                'description': 'User',
                'examples': {
                    'application/json': {
                        'msg':"修改成功"
                    }
                },
            }
        }
     })
    def post(self):
        args = self.post_parser.parse_args()
        # 檢查是否有重複帳號
        users = db.session.query(Users).filter_by(account=args['account'])
        if(users.count() == 0):
            return {"msg":"帳號不存在"},500
        # 檢查密碼兩次輸入是否相同
        if(args["password"] != args["repassword"]):
            return {"msg":"兩次輸入的密碼不同"},500
        # 更新至資料庫
        users[0].name =args["name"]
        users[0].password = args["password"]
        db.session.commit()
        return {"msg":"更新成功"},200
    
    
class UserLogin(Resource):
    post_parser = RequestParser()
    post_parser.add_argument('account', type=str, required=True)
    post_parser.add_argument('password', type=str, required=True)
    @swagger.doc({
        'tags': ['user'],
        'description': 'user login',
        'reqparser': {'name': 'UserModel',
                      'parser': post_parser},
        'responses': {
            '200': {
                'description': 'User',
                'examples': {
                    'application/json': {
                        "msg":"登入成功"
                        }
                        
                    }
                }
            }
     })
    def post(self):
        args = self.post_parser.parse_args()
        users = db.session.query(Users).filter_by(account=args['account']).all()
        if(len(users) == 0):
            return {"msg":"帳號不存在"},500
        if(users[0].password != args['password']):
            return {"msg":"密碼錯誤"},500
        session["account"] = args['account']
        return {"msg":"登入成功"},200
    
class UserLogout(Resource):
    def post(self):
        session["account"] = None
        return {"msg":"登出成功"},200