import threading
from queue import Queue

from .Camera_x86 import Camera

import time, numpy as np, cv2

class StreamMux(object):
    def __init__(self):
        self.CameraThreads=[]
        self.ListenThreads=[]
        self.isRunning=False
        self.resultQueue = Queue()
        
    def add(self,index,source):
        _cam=Camera(index,source,encoder = "h264",width=1920,height=1080)        
        self.CameraThreads.append(_cam)        
        self.ListenThreads.append(threading.Thread(target = self.ListenOnCamera,\
                                                   args = (_cam,)))        
    
    def start(self):
        self.isRunning=True
        for i in range(len(self.CameraThreads)):
            self.CameraThreads[i].start()
            self.ListenThreads[i].start()        
    
    def ListenOnCamera(self,_cam):
        while self.isRunning:
            while not _cam.resultQueue.empty():
                ret,frame =  _cam.resultQueue.get()                
                if ret:                    
                    self.resultQueue.put((_cam.ID,frame))
            
    def __del__(self):
        if self.isRunning:
            self.isRunning=False
            for thread in CameraThreads:
                del(thread)