from AlprTritonClient.yolo import TrtYOLO
from AlprTritonClient.yolo_shared_memory import TrtYOLOSHM

#from AlprTritonClient.EZLPR import EZLPR

from VideoAnalysis.SystemModule import DisplayMeta
#from VideoAnalysis.SystemModule import TrafficFlowMeta
from VideoAnalysis.CentroidTrack import CentroidTracker
#from VideoAnalysis.SystemModule import InfluxdbRecordThread
from VideoAnalysis.Camera_Jetson import Camera
from OtherModule.SaveAnnotation import AnnoWriter
import cv2
import sys
import time
import numpy as np

def time_span(stime):
    span=time.time()-stime
    stime=time.time()
    return span,stime

'''

PlanB_test0614.py  在運行階段將會把偵測結果儲存（座標,類別,原圖,截圖），用於儲存訓練 Yolo 所用的樣本
為減輕效能本範例沒有使用 {車牌辨識 車流判斷 }

'''

'''

 Init 
 
'''

#yolo = TrtYOLO()
# yolo triton server shared memory
yolo = TrtYOLOSHM()
#easyLPR=EZLPR()

#source="/home/tx2/Videos/20220504173000.mp4"
#source="/home/tx2/Videos/Kevin_Car.MOV"
#source = "../Ch17-20220314-190000.mp4"

source="rtsp://192.168.5.218/txg/01"
#source="rtsp://140.120.65.31/live.sdp"
cam=Camera(1,source,encoder = "h265",width=1920,height=1080,use_gstr=False)

camera_id=1
break_flag=False

displayMeta=DisplayMeta(camera_id,None)
 
CT=CentroidTracker(camera_id = camera_id ,maxDisappeared = 10, max_dist = 150)   
#TFMeta=TrafficFlowMeta(width=1920,height=1080,polyPoints = [[658 , 307],[1302 , 804],[1149 , 910],[531 , 340]] )
# [[422,961],[230,667],[492,608],[826,802]]
                                                            # 左上 右上 右下 左下 順時鐘點位
#InfluxWriter=InfluxdbRecordThread("127.0.0.1","admin","Ecom84253675","TrafficRecord")
AW = AnnoWriter(SleepPutTime = 1000) # 用於儲存 yolo 辨識結果 紀錄成 annotaion ，SleepPutTime 代表每微秒取樣一次

'''

prepare

'''
cam.start()
#InfluxWriter.start()
clsName={'2.0':'car','0.0':'person','3.0':'motorbike','5.0':'bus','7.0':'truck'}
LPR_target=['2.0','3.0','5.0','7.0']
FPS=list()
is_display=True;  # 是否要畫面顯示的 flag   p.s. 建議:若要儲存 Annotation 則不要 display ，否則會將渲染在原圖的 文字or 框線 儲存進圖片
AW.start()

'''

start main

'''
try:
    if is_display:
        cv2.namedWindow("1",cv2.WINDOW_NORMAL)
        cv2.resizeWindow("1",1280,720)
    while True:
        if break_flag:
            break
        while not cam.resultQueue.empty():
            if is_display:
                displayMeta.clear()
            ret,frame=cam.resultQueue.get()
            if (ret):                
                stime=time.time()
                staic_stime=stime
                displayMeta.frame=frame
                stime=time.time()
                results=yolo.detect(frame,0.25)
                yolo_span,stime=time_span(stime) # !
                obj_bbox_xyxys =[]
                obj_crop_imgs = []
                obj_ids=[]
                obj_names=[]
                for cls,box in results:
                    x1,y1,x2,y2=box
                    w,h=x2-x1,y2-y1
                    rect=(x1,y1,w,h)
                    obj_bbox_xyxys.append([x1,y1,x2,y2])
                    obj_crop_imgs.append(frame[y1:y2,x1:x2,:].copy())
                    #obj_crop_imgs.append(None)
                    obj_names.append(clsName[str(cls)] if str(cls) in clsName else str(cls))
                    obj_ids.append(str(int(cls)))
                processResult_span,stime=time_span(stime) # !
                AW.put(frame , obj_bbox_xyxys , obj_ids , obj_names , obj_crop_imgs)
                objects = CT.update(obj_bbox_xyxys,obj_crop_imgs,obj_ids,obj_names)
                tracker_span,stime=time_span(stime) # !
                
          
#                 TFMeta.UpdateTrafficFlow(objects)
#                 TF_span,stime=time_span(stime) # !
#                 if is_display:
#                     displayMeta.frame = TFMeta.osd(frame)  # 車流判斷的疊圖很耗時可考慮註解
                for index,obj in objects.items():                
                    # draw trajectory
                    if obj.rect is not None:                        
                        x1,y1,x2,y2=obj.rect
                        x,y,w,h=obj.rect[0],obj.rect[1],obj.rect[2]-obj.rect[0],obj.rect[3]-obj.rect[1]
                        if is_display:
                            displayMeta.line_param.append(obj.trajectory)
                            displayMeta.rect_param.append([x,y,w,h])
                            objname=f"{obj.ID}_{obj.object_name}"
                            displayMeta.text_param.append(objname+"_"+ obj.lpr_plate_num if obj.lpr_plate_num else objname)
#                         # Process EZLPR
#                         if obj.object_id in LPR_target and not obj.lock_plate_num:
#                             obj.update_lpr_time()
#                             easyLPR.put(obj.ID,frame[y1:y2,x1:x2,:].copy())                            

#                 InputLPR_span,stime=time_span(stime) # !
                     
#                 for index,platNum in easyLPR.out():
#                     if index in CT.objects:
#                         print(index, platNum)
#                         CT.objects[index].update_lpr_candis(platNum)
#                 OutputLPR_span,stime=time_span(stime) # !
                
                CT.GetDisposeBuffer()
                #for obj in CT.GetDisposeBuffer():
                #    InfluxWriter.put(obj)

                FPS.append(1/(time.time()-staic_stime))
                if is_display:    
                    displayMeta.rect_param.append((50,50,400,1))
                    displayMeta.text_param.append(f"Object Count:{CT.nextObjectID}, Fps:{int(FPS[-1])}")
                    displayMeta.draw()
                    draw_span,stime=time_span(stime) # !

                total_span=time.time()-staic_stime
                
                sys.stdout.write(f"\rObject Count:{CT.nextObjectID}, Fps:{int(np.mean(FPS))}")

#                 sys.stdout.write(f"\rObject Count:{CT.nextObjectID}, Fps:{int(1/(total_span))}"
#                       f",yolo_span:{int((yolo_span/total_span)*100)}%"
#                       f",draw_span:{int((draw_span/total_span)*100)}%"
#                      f",tracker_span:{int((tracker_span/total_span)*100)}%"
#                      f",TF_span:{int((TF_span/total_span)*100)}%"
#                      f",InputLPR_span:{int((InputLPR_span/total_span)*100)}%"
#                      f",OutputLPR_span:{int((OutputLPR_span/total_span)*100)}%")
#                 sys.stdout.write(f"\rCTDispose_Buffer:{CT.disposeBuffer.qsize()}"
#                                 f"Influx_Buffer:{InfluxWriter.ObjectMetaUploadQueue.qsize()}")
                if is_display:
                    cv2.imshow("1",displayMeta.frame)
                    key=cv2.waitKey(1)
                    if key==ord('q'):
                        break_flag=True
                        break
except Exception as e:
    raise(e)
    cam.stop()
    del (cam)
    #del (InfluxWriter)
    #del (easyLPR)
    del (AW)
    cv2.destroyAllWindows()
            
finally:
    cam.stop()
    del (cam)
    #del (InfluxWriter)
    #del (easyLPR)
    del (AW)
    cv2.destroyAllWindows()
            

    
