import cv2
import numpy as np
import time

import threading, queue
#from influxdb import InfluxDBClient
import sys
import os
sys.path.append(os.path.dirname(__file__))
from ObjectMeta import ObjectMeta


# from .StreamMux import StreamMux


# class ObjectMeta:
#     def __init__(self,_id,parent_id):
#         self.parent_id=parent_id
#         self.ID=_id
#         self.lifespan=0
#         self.ClassifierList=[]
#         self.RecognitionList=[]
#         self.RectList=[]    # x,y,w,h
#         self.TrackedList=[] # central_x,central_y
        
#     def getRecognition(self):
#         return np.bincount(self.RecognitionList).argmax() if len(self.RecognitionList) > 0 else ""
#     def getClassifier(self):
#         return np.bincount(self.ClassifierList).argmax() if len(self.ClassifierList) > 0 else ""
#     def getRect(self):
#         return self.RectList[-1] if len(self.RectList)>0 else None
#     def getLastTracked(self):
#         return self.TrackedList[-1] if len(self.TrackedList)>0 else None
    
#     def updatePrimary(self,class_name,rect):
#         self.ClassifierList.append(class_name)
#         self.RectList.append(rect)
#         self.TrackedList.append((rect[0]+rect[2]//2,rect[1]+rect[3]//2))
#         self.lifespan+=1
        
#     def updateSecondary(self,result):
#         for v in result:
#             self.RecognitionList.append(v)
            

# class FrameMeta:
#     def __init__(self,_id,parent_id):
#         self.parent_id=parent_id
#         self.ID=_id
#         self.frame_count=0
#         self.frame=None
#         self.ObjectDist=dict()
#         self.Object_count=0
#         self.DisplayMeta = DisplayMeta(self.ID,self.frame)
#         self.TrackerMethod = nearest_centroid_match
#         self.LPR_Module = None
#         self.InputLPR_Module_Thread = threading.Thread(target = self.InputToLPR_Module)
#         self.is_ScondaryTask_Running=True
#         self.InputLPR_Module_Thread.start()
        
#     def __call__(self,frame):
#         if isinstance(frame,np.ndarray) and frame.size>0:
#             self.frame=frame
#             self.frame_count+=1
#             self.DisplayMeta.frame=frame           
#             self.disposeLostTrackedObjectMeta()
#             return self
        
#     def updateObjectMetaPrimary(self,objectInfos):
#         ref_ids=[]
#         exsist_points=[]
#         unknow_points=[(v[0]+v[2]//2,v[1]+v[3]//2) for v in objectInfos[1]]
#         for _objectMeta in list(self.ObjectDist.values()):
#             point = _objectMeta.getLastTracked()
#             if (point):
#                 exsist_points.append(point)
#                 ref_ids.append(_objectMeta.ID)
#         match_pairs = self.TrackerMethod(exsist_points,unknow_points)
#         for pair in match_pairs:
#             exsist_index = ref_ids[pair[0]]
#             unknow_index = pair[1]
#             if (exsist_index in self.ObjectDist):
#                 self.ObjectDist[exsist_index].updatePrimary(objectInfos[0][unknow_index],objectInfos[1][unknow_index])
#             else:
#                 self.ObjectDist[self.Object_count]=ObjectMeta(self.Object_count,self.ID)
#                 self.ObjectDist[self.Object_count].updatePrimary(objectInfos[0][unknow_index],objectInfos[1][unknow_index])
#                 self.Object_count+=1
#         self.updateDisplayMeta()
                
#     def updateObjectMetaSecondary(self,index,result):
#         if index in self.ObjectDist:
#             self.ObjectDist[index].updateSecondary(result)
#         self.updateDisplayMeta()
        
#     def updateDisplayMeta(self):
#         self.DisplayMeta.clear()
#         for k,v in self.ObjectDist.items():
#             rect = v.getRect()
#             if (rect):
#                 self.DisplayMeta.rect_param.append(rect)
#                 self.DisplayMeta.text_param.append(v.getRecognition())
#                 if v.TrackedList != []:
#                     self.DisplayMeta.line_param.append(v.TrackedList)
#                 self.DisplayMeta.draw()
                
#     def disposeLostTrackedObjectMeta(self):        
#         disposeList=[]
#         for index,objectMeta in self.ObjectDist.items():
#             if self.frame_count - 30 > objectMeta.lifespan:
#                 disposeList.append(index)
#         for index in disposeList:
#             self.ObjectDist.pop(index)
            
#     def InputToLPR_Module(self):
#         while self.is_ScondaryTask_Running:
#             if self.LPR_Module is not None:
#                 if isinstance(frame,np.ndarray) and frame.size>0:
#                     for index,objectMeta in self.ObjectDist.items():
#                         rect=objectMeta.getRect()
#                         if rect is not None:
#                             x1,y1,x2,y2=rect[0],rect[1],rect[0]+rect[2],rect[1]+rect[3]
#                             self.LPR_Module.input([self.ID,index],self.frame[y1:y2,x1:x2])
#             time.sleep(0.1)
                
#     def __del__(self):
#         self.is_ScondaryTask_Running=False        
                        
# class BatchMeta:
#     def __init__(self,_id,source=""):
#         self.Source=source
#         self.ID=_id
#         self.FramMetaDist=dict()
#         self.count=0
#     def updateFrameMeta(self,frame,frame_id):        
#         if (frame_id in self.FramMetaDist):            
#             self.FramMetaDist[frame_id](frame)            
#         else:            
#             _frameMeta=FrameMeta(self.count,self.ID)
#             self.FramMetaDist[self.count]=_frameMeta(frame)            
#             self.count+=1
#     def updateObjectMeta(self,objectInfos,frame_id):
#         # objectInfos = ([className1,className2....],[rect1,rect2....])
#         if (frame_id in self.FramMetaDist):
#             self.FramMetaDist[frame_id].updateObjectMetaPrimary(objectInfos)

# class VideoAnalysisEngine(object):
#     def __init__(self):
#         self.sources=[]
#         self.StreamMux=StreamMux()
#         self.BatchMetaDict=dict()
#         self.BatchMeta_count=0
#         self.Object_Detector=None
#         self.LPR_Module=None
#         self.mainJob=threading.Thread(target = self.run)
#         self.PrimaryJob=threading.Thread(target = self.objectDection)
#         self.SecondaryJob=threading.Thread(target = self.alpr)
#         self.isRunning=False
        
#     def addSource(self,source):
#         self.sources.append(source)
#         self.StreamMux.add(self.BatchMeta_count,source)
#         self.BatchMetaDict[self.BatchMeta_count]=BatchMeta(self.BatchMeta_count,source)
#         self.BatchMeta_count+=1
    
#     def run(self):        
#         while self.isRunning:
#             while not self.StreamMux.resultQueue.empty():
#                 index,frame=self.StreamMux.resultQueue.get()
#                 if self.Object_Detector is not None:
#                     self.Object_Detector.input(index,frame)
#                 self.BatchMetaDict[index].updateFrameMeta(frame,index)
#             time.sleep(0.001)
            
#     def display(self):
#         try:
#             cv2.namedWindow("0", cv2.WINDOW_NORMAL)
#             cv2.resizeWindow("0", 500, 500)
#             while self.isRunning:
#                 for index,BatchMeta in self.BatchMetaDict.items():                    
#                     frameMeta=BatchMeta.FramMetaDist.get(index)
#                     if (frameMeta):                        
#                         cv2.imshow(str(index),frameMeta.DisplayMeta.frame)
#                         cv2.waitKey(1)
#         except Exception as e:
#             print(e)

#     def objectDection(self):
#         if self.Object_Detector is not None:
#             while self.isRunning:
#                 batchResult=self.Object_Detector.output()
#                 for index,objectInfos in batchResult:
#                     if objectInfos is not None:
#                         self.BatchMetaDict[index].updateObjectMeta(objectInfos,index)
#                 time.sleep(0.001)
                
#     def alpr(self):
#         if self.LPR_Module is not None:
#             while self.isRunning:
#                 batchResults = self.LPR_Module.output()
#                 for indexs,result in batchResults:
#                     frameMetaID,ObjectMetaID= indexs
#                     if result is not None and frameMetaID in self.BatchMetaDict:                         
#                         self.BatchMetaDict[frameMetaID].updateObjectMetaSecondary(ObjectMetaID,result)
#                 time.sleep(0.001)
            
#     def start(self):
#         self.isRunning=True
#         self.mainJob.start()
#         self.PrimaryJob.start()
#         self.SecondaryJob.start()
#         self.StreamMux.start()
        
#     def __del__(self):
#         self.isRunning=False
#         del (BatchMetaDict)
#         del (StreamMux)
#         cv2.destroyAllWindows()
        
    
#     def main(self):
# #         self.addSource("rtsp://192.168.5.218/txg/01")        
#         self.start()
#         self.display()
        
        
class DisplayMeta:
    def __init__(self,parent_id,frame):
        self.parent_id=parent_id
        self.frame=frame
        self.rect_param=[] # list []
        self.text_param=[] # list []
        self.line_param=[] # list []
        self.color= (0, 255, 255)
        
    def draw(self):
        self.draw_rect()
        self.put_text()
        self.draw_line()
        return self.frame
    
    def draw_rect(self):
        if (self.rect_param !=[] and not self.is_frame_empty()):
            for rectP in self.rect_param:
                x2,y2=int(rectP[0]+rectP[2]),int(rectP[1]+rectP[3])
                self.frame= cv2.rectangle(self.frame, tuple([int (v) for v in rectP[:2]]), (x2, y2), self.color, 2)
            return self.frame
    def put_text(self):
        if (self.rect_param !=[] and self.text_param !=[] and not self.is_frame_empty()):
            for rectP,textP in zip(self.rect_param,self.text_param):
                x2,y2=rectP[0]+rectP[2],rectP[1]
                self.frame= cv2.rectangle(self.frame, tuple([int(rectP[0]),int(rectP[1])-40]), (x2, y2), (0, 0, 0), -1)
                self.frame=cv2.putText(self.frame, str(textP), tuple([int (v) for v in rectP[:2]]), cv2.FONT_HERSHEY_DUPLEX, 1, (255, 255, 255), 2, cv2.LINE_AA)
            return self.frame
    def draw_line(self):
        if (self.line_param !=[] and not self.is_frame_empty()):
            for lineP in self.line_param:
                lineP=np.array(lineP,np.int32)
                self.frame=cv2.polylines(self.frame, pts=[lineP], isClosed=False, color=self.color, thickness=5)
            return self.frame
        
    def clear(self):
        self.rect_param.clear()
        self.text_param.clear()
        self.line_param.clear()
        
    def is_frame_empty(self):
        return not (isinstance(self.frame,np.ndarray) and self.frame.size>0)
    
    
    
class TrafficFlowMeta(object):
    def __init__(self,height,width,polyPoints):
        '''
        基礎參數
        '''
        self.height = height
        self.width = width
        self.polyPoints = polyPoints
        '''
        車流計算 相關
        '''
        self.mask_map_TFC = None   # 在圖像坐標系中 的 遮罩 map ，用於給予經過的物件儲存經過何種遮罩值
        self.draw_map_TFC = None   # 對應 mask_map_TFC 的實體顯現於畫面
        self.mask_endPoint1 = None # 遮罩 map 的四邊形端點(x1,y1) [可應用於要標上車流統計於畫面上時]，
        self.mask_endPoint2 = None # 遮罩 map 的四邊形端點(x2,y2) [可應用於要標上車流統計於畫面上時]
        self.Traffic_flow_Logic = {"12":"南向" , "21":"北向"} # (ex. {"12":"南向" } => 1 到 2 等於 南向
        self.Traffic_flow_count_N = {"car" : 0, "motorbike" : 0, "bus":0 ,"truck":0,"person":0} # 物件流統計 北向
        self.Traffic_flow_count_S = {"car" : 0, "motorbike" : 0, "bus":0 ,"truck":0,"person":0} # 物件流統計 南向
        
        self.draw_mask()
    
    def Traffic_flow_count(self,map_indexs,obj_name):
        '''
        當物件已經跨越兩個遮罩邏輯區域 則呼叫此方法，以判斷行車方向性
        self.Traffic_flow_Logic = {"12":"南向" , "21":"北向"}  # 方向性邏輯
        '''       
        tour_path = str(map_indexs[0])+str(map_indexs[1])
        direction = self.Traffic_flow_Logic.get(tour_path)
        
        if (direction == "北向"):
            # 北向
            if (obj_name in self.Traffic_flow_count_N):
                self.Traffic_flow_count_N[obj_name]+=1
        elif (direction == "南向"):
            # 南向
            if (obj_name in self.Traffic_flow_count_S):
                self.Traffic_flow_count_S[obj_name]+=1
        return direction
                
    def draw_mask(self):
        '''
        此方法建立 車流計算 遮照

        polyPoints = [[p1x,p1y],[p2x,p2y],[p3x,p3y],[p4x,p4y]]  # 左上 右上 右下 左下 順時鐘點位
        ''' 
        height = self.height
        width =  self.width
        polyPoints = self.polyPoints        
        
        polyPoints = np.array(polyPoints)

        # 根据视频尺寸，填充一个polygon，供撞线计算使用
        mask_image_temp = np.zeros((height, width), dtype=np.uint8)
        # 初始化2个撞线polygon  蓝色
        list_pts_blue = polyPoints          # 蓝色多边形坐标，可根据自己的场景修改
        ndarray_pts_blue = np.array(list_pts_blue, np.int32)
        ndarray_pts_blue[3][0] = (ndarray_pts_blue[0][0]+ndarray_pts_blue[3][0])//2
        ndarray_pts_blue[2][0] = (ndarray_pts_blue[1][0]+ndarray_pts_blue[2][0])//2    
        ndarray_pts_blue[2][1] = (ndarray_pts_blue[1][1]+ndarray_pts_blue[2][1])//2
        ndarray_pts_blue[3][1] = (ndarray_pts_blue[0][1]+ndarray_pts_blue[3][1])//2
        polygon_blue_value_1 = cv2.fillPoly(mask_image_temp, [ndarray_pts_blue], color=1)      #  构建多边形
        polygon_blue_value_1 = polygon_blue_value_1[:, :, np.newaxis]

        # 填充第二个polygon    黄色
        mask_image_temp = np.zeros((height, width), dtype=np.uint8)    
        list_pts_yellow = polyPoints       # 黄色多边形坐标，可根据自己的场景修改
        ndarray_pts_yellow = np.array(list_pts_yellow, np.int32)
        ndarray_pts_yellow[0][1] = ndarray_pts_blue[3][1]
        ndarray_pts_yellow[0][0] = ndarray_pts_blue[3][0]
        ndarray_pts_yellow[1][1] = ndarray_pts_blue[2][1]
        ndarray_pts_yellow[1][0] = ndarray_pts_blue[2][0]

        polygon_yellow_value_2 = cv2.fillPoly(mask_image_temp, [ndarray_pts_yellow], color=2)   # 构建多边形
        polygon_yellow_value_2 = polygon_yellow_value_2[:, :, np.newaxis]
        # 撞线检测用mask，包含2个polygon，（值范围 0、1、2），供撞线计算使用

        polygon_mask_blue_and_yellow = polygon_blue_value_1 + polygon_yellow_value_2
        polygon_mask_blue_and_yellow = np.where(polygon_mask_blue_and_yellow == 3 , 1 , polygon_mask_blue_and_yellow)


        # 蓝 色盘 b,g,r
        blue_color_plate = np.array([255, 0, 0],np.uint8)
        # 蓝 polygon图片
        blue_image = np.array(polygon_blue_value_1 * blue_color_plate /1,np.uint8)

        # 黄 色盘
        yellow_color_plate = np.array([0, 100, 30],np.uint8)
        # 黄 polygon图片
        yellow_image = np.array(polygon_yellow_value_2 * yellow_color_plate /2,np.uint8)

        # 彩色图片（值范围 0-255）
        color_polygons_image = blue_image + yellow_image

        # 各向端點
        endPnt1 = np.min(list_pts_blue,axis=0)
        endPnt2 = np.max(list_pts_yellow,axis=0) 
        
        self.mask_map_TFC = polygon_mask_blue_and_yellow
        self.draw_map_TFC = color_polygons_image
        self.mask_endPoint1 = endPnt1
        self.mask_endPoint2 = endPnt2
#         return polygon_mask_blue_and_yellow,color_polygons_image,endPnt1,endPnt2

    def UpdateTrafficFlow(self,CT_Objects):
        '''
        CT_Objects 是來自 Centrol Tracker update 之後ouput出的 被追蹤物件
        # Do Traffic flow counter
        '''
        if (self.mask_map_TFC is not None):
            for (objectID, object_proper) in CT_Objects.items():
                if (not object_proper.counted):
                    x,y = object_proper.centroid
                    object_proper.update_map_index(self.mask_map_TFC[y][x])

                    if (object_proper.crossed):
                        # 已跨越熱區
                        object_proper.set_counted() # 立 flag 代表已被計次
                        # 判斷方向與累計車流
                        direction = self.Traffic_flow_count([object_proper.map_index1,object_proper.map_index2]\
                                                ,object_proper.object_name)
                        object_proper.set_behavior(direction)
    def osd(self,frame):
        h,w,c = frame.shape
        assert h == self.height and w == self.width,f"Error!! Input shape is not the same: Input:({h},{w}), Setting:({self.height},{self.width})"
        
        frame = cv2.add(frame ,self.draw_map_TFC)

        x1y1=self.mask_endPoint1
        x2y2=self.mask_endPoint2
        offset_y = -120
        for k,v in self.Traffic_flow_count_N.items():
            frame = cv2.putText(frame, f"{k}:{v}",\
                                             (x2y2[0], x2y2[1]+offset_y),\
                                             cv2.FONT_HERSHEY_SIMPLEX, 1, \
                                            (0, 255, 255), 2, cv2.LINE_AA)
            offset_y+=40

        offset_y = -120
        for k,v in self.Traffic_flow_count_S.items():                
            frame = cv2.putText(frame, f"{k}:{v}",\
                                (x1y1[0], x1y1[1]+offset_y),\
                                cv2.FONT_HERSHEY_SIMPLEX, 1, \
                                (255, 255, 0), 2, cv2.LINE_AA)
            offset_y+=40
        return frame

class InfluxdbRecordThread(threading.Thread):
    """InfluxdbRecordThread
    NOTE:
        A Queue based Influxdb Record Writer in background threading.
        Being as a client for used in writing Traffic Record into Influxdb
    """
    
    def __init__(self,host,user,password,DB_Name,port=8086):
        """__init__
        Args:
            host : Influxdb server ip
            user : The username for login into Influxdb server
            password : The password for login into Influxdb server
            DB_Name : Database name
            port : Influxdb server defalut : 8086
        """
        threading.Thread.__init__(self)
        #self.condition = condition
        #self.client = InfluxDBClient(host, port, user, password, DB_Name)
        self.isRunning = False # Flag represent Thread is running
        self.ObjectMetaUploadQueue = queue.Queue()
        self.DB_Schema={'measurement':'trafficflow',
                       'tags':["camera_id", "object_name"],
                       'fields':["create_time","dispose_time",
                                 "object_id", "trajectory", "behavior", "plate_num"]}
        
    def run (self):
        """ run
        Run the Influxdb Record Writer Process in background threading
          until self.isRunning == False
        """
        print("InfluxdbRecordThread stared .... ")
        self.isRunning = True
        while self.isRunning:
            try:                
                while not self.ObjectMetaUploadQueue.empty():
                    objectMeta=self.ObjectMetaUploadQueue.get()
                    '''
                    preprocess some data
                    '''
                    trajectory=""
                    for v in np.array(objectMeta.trajectory).flatten():
                        trajectory+=f"{v},"
                    trajectory=trajectory[:-1]
                    plate_num=objectMeta.lpr_plate_num if objectMeta.lock_plate_num else objectMeta.get_plate_num()
                    
                    '''
                    write the data
                    '''
                    data=[
                        {
                         "measurement":  self.DB_Schema["measurement"] ,
                            "tags": {
                                "camera_id": objectMeta.camera_id,
                                "object_name": objectMeta.object_name
                            },
                            "fields": {
                                "create_time": objectMeta.create_time.timestamp(),
                                "dispose_time": objectMeta.dispose_time.timestamp(),
                                "object_id": objectMeta.ID,
                                "trajectory": trajectory,
                                "behavior": objectMeta.behavior,  
                                "plate_num": plate_num
                            }
                        }                        
                    ]
                    print(data)
                    #self.client.write_points(data)
                time.sleep(0.01)
            except Exception as e:
                raise(e)                
            
    def put(self,objectMeta):
        """put
        Put objectMeta into self.ObjectMetaUploadQueue
        """
        if isinstance(objectMeta,ObjectMeta) and self.isRunning:
            self.ObjectMetaUploadQueue.put(objectMeta)               
        
    def stop(self):
        self.isRunning = False
        self.join()
    
    def __del__(self):
        self.stop()
        #self.client.close()
        
