import numpy as np
import cv2
def align(image,landmarks,padding):
    # 取得車牌頂點座標
    # 左上左下 右上右下
    try:                        
        #oring_landmarks=list(map(float, landmarks))
        oring_landmarks = landmarks
        left_top_landmark=oring_landmarks[:2]
        left_bottom_landmark=oring_landmarks[2:4]
        right_top_landmark=oring_landmarks[4:6]
        right_bottom_landmark=oring_landmarks[6:8]
        src_points = np.array([left_top_landmark, left_bottom_landmark,right_top_landmark, right_bottom_landmark], dtype = "float32")
        transform_plate=four_point_transform(image,src_points,padding)
        return transform_plate
    except Exception as e:
        return None
    
def order_points(pts):
    # initialzie a list of coordinates that will be ordered
    # such that the first entry in the list is the top-left,
    # the second entry is the top-right, the third is the
    # bottom-right, and the fourth is the bottom-left
    
    '''
    rect = np.zeros((4, 2), dtype = "float32")
 
    # the top-left point will have the smallest sum, whereas
    # the bottom-right point will have the largest sum
    s = pts.sum(axis = 1)
    rect[0] = pts[np.argmin(s)]
    rect[2] = pts[np.argmax(s)]
 
    # now, compute the difference between the points, the
    # top-right point will have the smallest difference,
    # whereas the bottom-left will have the largest difference
    diff = np.diff(pts, axis = 1)
    rect[1] = pts[np.argmin(diff)]
    rect[3] = pts[np.argmax(diff)]
 
    # return the ordered coordinates
    '''
    rect = np.zeros((4, 2), dtype = "float32")
    
    rect[0]=pts[0]
    rect[1]=pts[2]
    rect[2]=pts[3]
    rect[3]=pts[1]
    
    return rect

def four_point_transform(image, pts,padding):
    # obtain a consistent order of the points and unpack them
    # individually
    rect = order_points(pts)
    (tl, tr, br, bl) = rect
 
    # compute the width of the new image, which will be the
    # maximum distance between bottom-right and bottom-left
    # x-coordiates or the top-right and top-left x-coordinates
    widthA = np.sqrt(((br[0] - bl[0]) ** 2) + ((br[1] - bl[1]) ** 2))
    widthB = np.sqrt(((tr[0] - tl[0]) ** 2) + ((tr[1] - tl[1]) ** 2))
    maxWidth = max(int(widthA), int(widthB))
 
    # compute the height of the new image, which will be the
    # maximum distance between the top-right and bottom-right
    # y-coordinates or the top-left and bottom-left y-coordinates
    heightA = np.sqrt(((tr[0] - br[0]) ** 2) + ((tr[1] - br[1]) ** 2))
    heightB = np.sqrt(((tl[0] - bl[0]) ** 2) + ((tl[1] - bl[1]) ** 2))
    maxHeight = max(int(heightA), int(heightB))
 
    # now that we have the dimensions of the new image, construct
    # the set of destination points to obtain a "birds eye view",
    # (i.e. top-down view) of the image, again specifying points
    # in the top-left, top-right, bottom-right, and bottom-left
    # order    

    dst = np.array([
        [0, 0],
        [maxWidth - 1, 0],
        [maxWidth - 1, maxHeight - 1],
        [0, maxHeight - 1]], dtype = "float32")
    # compute the perspective transform matrix and then apply it
    M = cv2.getPerspectiveTransform(rect, dst)
    warped = cv2.warpPerspective(image, M, (maxWidth+padding, maxHeight))    
 
    # return the warped image
    return warped

def align_with_template(image,landmarks,padding):
    # 取得車牌頂點座標
    # 左上左下 右上右下
    try:                        
        oring_landmarks=list(map(int, landmarks))
        left_top_landmark=oring_landmarks[:2]
        left_bottom_landmark=oring_landmarks[2:4]
        right_top_landmark=oring_landmarks[4:6]
        right_bottom_landmark=oring_landmarks[6:8]
        src_points = np.array([left_top_landmark, left_bottom_landmark,right_top_landmark, right_bottom_landmark], dtype = "float32")
        transform_plate=map_to_template(image,src_points,padding)
        return transform_plate
    except Exception as e:
        print(e)
        return False

def map_to_template(image,pts,padding):
    rect = order_points(pts)
    template_4ps=[[79,866],[79,1589],[1126,866],[1126,1589]]
    #  左上    左下    右上      右下
    # [79,866,79,1589,1126,866,1126,1589]
    dst = np.array([
    template_4ps[0],  # 左上
    template_4ps[2], # 右上
    template_4ps[3],# 右下
    template_4ps[1]] # 左下
    , dtype = "float32")

    M = cv2.getPerspectiveTransform(rect, dst)
    warped = cv2.warpPerspective(image, M, (1191, 1685))
    x1,y1,x2,y2= template_4ps[0][0],template_4ps[0][1],template_4ps[3][0],template_4ps[3][1]
    return warped[y1-padding:y2+padding,x1-padding:x2+padding]