import cv2
import os
import threading, queue
import datetime
import time

class AnnoFormater(object):
    def __init__(self):
        self.crop_img = None
        self.x1 = None
        self.y1 = None
        self.x2 = None
        self.y2 = None
        self.obj_ID = None
        self.obj_Name = None
        
    def __call__(self,crop_img=None,x1=None,y1=None,x2=None,y2=None,obj_ID=None,obj_Name=None):
        self.crop_img = crop_img if crop_img is not None else self.crop_img
        self.x1 = x1 if x1 else self.x1
        self.y1 = y1 if y1 else self.y1
        self.x2 = x2 if x2 else self.x2
        self.y2 = y2 if y2 else self.y2
        self.obj_ID = obj_ID if obj_ID else self.obj_ID
        self.obj_Name = obj_Name if obj_Name else self.obj_Name
        return self
    def formate(self):
        return f"{self.x1} {self.y1} {self.x2} {self.y2},{self.obj_ID},{self.obj_Name}"
    
    
class AnnoWriter(threading.Thread):
    def __init__(self,SleepPutTime=1000):
        threading.Thread.__init__(self)
        self.isRunning = False
        self.SaveDataQueue = queue.Queue()  # [ a frame , [many annotations]]
        self.SleepPutTime = SleepPutTime # milliseconds  每隔 幾微秒秒 可 input data 到佇列
        self.putFrequency = datetime.timedelta(milliseconds=self.SleepPutTime)
        self.lastPutTime = None
        self.whitelist = ['car','person','motorbike','bus','truck']
        
        self.SaveRoot=os.path.join(os.path.expanduser("~"),"RealWordDataSet",datetime.datetime.now().strftime("%Y%m%d"))
        if not os.path.exists(self.SaveRoot):
            os.makedirs(self.SaveRoot)
        
        self.AnnoRoot = os.path.join(self.SaveRoot,"Annotation")
        self.FrameRoot = os.path.join(self.SaveRoot,"Image")
        self.CropRoot = os.path.join(self.SaveRoot,"CropImage")
        for folder in [self.AnnoRoot,self.FrameRoot,self.CropRoot]:
            if not os.path.exists(folder):
                os.makedirs(folder)
        
        self.DataAmount = len([name for name in os.listdir(self.AnnoRoot) if os.path.isfile(name)])+1
        self.CropAmount = len([name for name in os.listdir(self.CropRoot) if os.path.isfile(name)])+1
                  
    def run(self):
        self.isRunning = True
        while self.isRunning:            
            while not self.SaveDataQueue.empty():
                frame,annotations = self.SaveDataQueue.get()
                if (cv2.imwrite(os.path.join(self.FrameRoot,f'{self.DataAmount}.jpeg'),frame)):
                    self.WriteTxt(annotations)
                    self.SaveCropImg(annotations)
            time.sleep(self.SleepPutTime//1000)
               
    def WriteTxt(self,annotations):        
        path = os.path.join(self.AnnoRoot,f'{self.DataAmount}.txt')
        with open(path, 'a') as f:
            for anno in annotations:            
                f.write(f'{anno.formate()}\n')
        self.DataAmount+=1
        
    def SaveCropImg(self,annotations):
        for anno in annotations:
            img = anno.crop_img
            file_name = f'{self.CropAmount}_{anno.obj_Name}.jpeg'
            file_name = os.path.join(self.CropRoot,file_name)
            if (cv2.imwrite(file_name,img)):
                self.CropAmount+=1
      
    def put(self, frame , rects , obj_IDs , obj_Names , crop_imgs):
        if self.lastPutTime is None:
            self.lastPutTime = datetime.datetime.now()-datetime.timedelta(milliseconds=self.SleepPutTime)
        if datetime.datetime.now()-self.lastPutTime >= datetime.timedelta(milliseconds=self.SleepPutTime):
            self.lastPutTime = datetime.datetime.now()
            datapaload=[frame]
            annotations=[]
            for rect,obj_ID,obj_Name,crop_img in zip(rects,obj_IDs,obj_Names,crop_imgs):
                if obj_Name in self.whitelist:
                    x1,y1,x2,y2 = rect
                    anno = AnnoFormater()
                    annotations.append(anno(crop_img,x1,y1,x2,y2,obj_ID,obj_Name))
            if annotations != []:
                datapaload.append(annotations)
                self.SaveDataQueue.put(datapaload)
            
    def __del__(self):
        self.isRunning = False
        self.join()               
        
