import sys
sys.path.append('./AlprTritonClient')
import cv2
import time

from AlprTritonClient.yolo import TrtYOLO
from AlprTritonClient.EZLPR import EZLPR

yolo=TrtYOLO()
easyLPR=EZLPR()

def time_span(stime):
    span=time.time()-stime
    stime=time.time()
    return span,stime

from VideoAnalysis.Camera_Jetson import Camera
#source="../../Kevin_Car.MOV"
#source="rtsp://192.168.5.218/txg/01"
source="rtsp://140.120.65.31/live.sdp"
cam=Camera(1,source,encoder = "h264",width=1920,height=1080)



from VideoAnalysis.SystemModule import DisplayMeta
from VideoAnalysis.SystemModule import TrafficFlowMeta
from VideoAnalysis.CenroidTrack import CentroidTracker
import cv2
import time
import numpy as np



break_flag=False


displayMeta=DisplayMeta(1,None)
objectMetaDict=dict()
Object_count=0
 
CT=CentroidTracker( maxDisappeared = 10, max_dist = 150)   # 左上 右上 右下 左下 順時鐘點位
TFMeta=TrafficFlowMeta(width=1920,height=1080,polyPoints = [[422,961],[230,667],[492,608],[826,802]] )

cam.start()
clsName={'2.0':'car','0.0':'person','3.0':'motorbike','5.0':'bus','7.0':'truck'}
LPR_target=['2.0','3.0','5.0','7.0']
FPS=list()
try:
    cv2.namedWindow("1",cv2.WINDOW_NORMAL)
    cv2.resizeWindow("1",1280,720)
    while True:
        if break_flag:
            break
        while not cam.resultQueue.empty():
            displayMeta.clear()
            ret,frame=cam.resultQueue.get()
            if (ret):                
                stime=time.time()
                staic_stime=stime
                displayMeta.frame=frame
                stime=time.time()
                results=yolo.detect(frame)
                yolo_span,stime=time_span(stime) # !
                obj_bbox_xyxys =[]
                obj_crop_imgs = []
                obj_ids=[]
                obj_names=[]
                for cls,box in results:
                    x1,y1,x2,y2=box
                    w,h=x2-x1,y2-y1
                    rect=(x1,y1,w,h)                    
                    obj_bbox_xyxys.append([x1,y1,x2,y2])
                    #obj_crop_imgs.append(frame[y1:y2,x1:x2,:].copy())
                    obj_crop_imgs.append(None)
                    obj_names.append(clsName[str(cls)] if str(cls) in clsName else str(cls))
                    obj_ids.append(str(cls))
                processResult_span,stime=time_span(stime) # !
                objects = CT.update(obj_bbox_xyxys,obj_crop_imgs,obj_ids,obj_names)
                tracker_span,stime=time_span(stime) # !
                
          
                TFMeta.UpdateTrafficFlow(objects)
                TF_span,stime=time_span(stime) # !
                
                #displayMeta.frame = TFMeta.osd(frame)
                for index,obj in objects.items():                
                    # draw trajectory
                    if obj.rect is not None:
                        displayMeta.line_param.append(obj.trajectory)
                        x1,y1,x2,y2=obj.rect
                        x,y,w,h=obj.rect[0],obj.rect[1],obj.rect[2]-obj.rect[0],obj.rect[3]-obj.rect[1]
                        displayMeta.rect_param.append([x,y,w,h])
                        objname=f"{obj.ID}_{obj.object_name}"
                        displayMeta.text_param.append(objname+"_"+ obj.lpr_plate_num if obj.lpr_plate_num else objname)
                        # Process EZLPR
                        if obj.object_id in LPR_target and not obj.lock_plate_num:
                            obj.update_lpr_time()
                            easyLPR.put(obj.ID,frame[y1:y2,x1:x2,:].copy())
#                         cv2.imshow("q",frame[y1:y2,x1:x2,:])
#                         cv2.waitKey(-1)
                InputLPR_span,stime=time_span(stime) # !
                
                for index,platNum in easyLPR.out():
                    if index in CT.objects:                        
                        CT.objects[index].update_lpr_candis(platNum)
                OutputLPR_span,stime=time_span(stime) # !
    
                displayMeta.rect_param.append((50,50,400,1))
                FPS.append(1/(time.time()-staic_stime))
                displayMeta.text_param.append(f"Object Count:{CT.nextObjectID}, Fps:{int(FPS[-1])}")
                displayMeta.draw()
                draw_span,stime=time_span(stime) # !
                total_span=time.time()-staic_stime
                cv2.imshow("1",displayMeta.frame)
#                 sys.stdout.write(f"\rObject Count:{CT.nextObjectID}, Fps:{int(np.mean(FPS))}")

                sys.stdout.write(f"\rObject Count:{CT.nextObjectID}, Fps:{int(1/(total_span))}"
                      f",yolo_span:{int((yolo_span/total_span)*100)}%"
                      f",draw_span:{int((draw_span/total_span)*100)}%"
                     f",tracker_span:{int((tracker_span/total_span)*100)}%"
                     f",TF_span:{int((TF_span/total_span)*100)}%"
                     f",InputLPR_span:{int((InputLPR_span/total_span)*100)}%"
                     f",OutputLPR_span:{int((OutputLPR_span/total_span)*100)}%")
                
                
                key=cv2.waitKey(1)
                if key==ord('q'):
                    break_flag=True
                    break
except Exception as e:
    raise(e)
    cam.stop()
    del (cam)
    cv2.destroyAllWindows()
            
finally:
    cam.stop()
    del (cam)
    cv2.destroyAllWindows()
            

    
