from datetime import datetime as dt

class ObjectMeta(object):
    def __init__(self,camera_id,centroid,_id):
        self.camera_id = camera_id
        self.ID=_id
        # object property
        self.object_name = None  # car , moto , person ....
        self.object_id = None # 2, 3 , 1 ... COCO 80 cls dataset
        
        self.lpr_candis = dict() # {"ABC-1234":30,"BMW-0857":1,....}
        self.lpr_plate_num = None  # 最終確定的答案  "ABC-1234" ,亦可能為 空 ""
        self.lock_plate_num = False
        self.give_up_lpr_count=0
        self.lock_plate_max = 1 # 辨識幾次後確立答案 不再辨識
        
        self.create_time = dt.now() # 開始被追蹤到的時間
        self.dispose_time= None   # 消失時間
        self.centroid = centroid
        self.rect=None
        self.trajectory = [centroid] # a list of centroid point
        self.being_tracked = 0
        self.disappeared = 0   # 消失幾禎
        self.crop_img = None  # 物件截圖        
        self.counted = False # 是否被計次過
        self.crossed = False # 是否已跨越熱區
        self.map_Journey = [None] # 跨越區域途徑 for 車流計算
        self.map_index1 = None
        self.map_index2 = None
        
        self.map_Journey2 = [None] # 跨越區域途徑 for 跨區域行為判斷 ex. 左轉 右轉 迴轉 變換車道
        self.map_index3 = None
        self.map_index4 = None
        self.behavior = None # 行為紀錄 ex. 左轉 右轉 迴轉 變換車道
        
    def lock_plate_answer(self): # 鎖定車牌答案
        self.lock_plate_num = True
        self.lpr_plate_num = self.get_plate_num()
        
    def update_lpr_time(self):   # Try to 車辨次數 若大於xx次 則放棄車牌辨識
        self.give_up_lpr_count+=1
        if self.give_up_lpr_count > 5:
            self.lock_plate_answer()
        
    def update_lpr_candis(self,plate_num):  # 更新車牌候選答案陣列
        if plate_num == "":
            self.give_up_lpr_count+=1
            if self.give_up_lpr_count >= 99:
                self.lock_plate_answer()
        else:
            if self.lpr_candis.get(plate_num) is None:
                self.lpr_candis[plate_num]=1
            else:
                self.lpr_candis[plate_num]+=1
                if self.lpr_candis[plate_num] >= self.lock_plate_max:
                    self.lock_plate_answer()
    def get_plate_num(self):
        max_count=-1
        _plate=""
        for plate_num in self.lpr_candis:
            if (self.lpr_candis[plate_num]>max_count):
                _plate=plate_num
                max_count=self.lpr_candis[plate_num]
        return _plate
    
    def update_map_index(self,index):
        '''
         用於 車流計算 之行經區域紀錄
        '''
        if (index != 0 and self.map_Journey[-1] != index):
            self.map_Journey.append(index)
            if len(self.map_Journey)==3:
                self.map_index2 = int(self.map_Journey.pop(-1))
                self.map_index1 = int(self.map_Journey.pop(-1))
                self.crossed = True
                
    def update_map_index2(self,index):
        '''
         用於 跨區域行為判斷 之行經區域紀錄
        '''
        if (index != 0 and self.map_Journey2[-1] != index):
            self.map_Journey2.append(index)
            if len(self.map_Journey2)>=3:
                self.map_index4 = int(self.map_Journey2[-1])
                self.map_index3 = int(self.map_Journey2[1])

    def set_counted(self):
        self.counted=True
        

    def set_behavior(self,behavior):
        self.behavior = behavior
