import numpy as np
from abc import ABC,abstractmethod

class AnalysisUnit(ABC):
    @abstractmethod
    def __init__(self):
        self.BatchFrame=[]
        self.BatchRefId=[]
        self.BatchResult=[]
        
    @abstractmethod
    def input(self,index,frame):
        if isinstance(frame,np.ndarray) and frame.size>0:
            self.BatchFrame.append(frame)
            self.BatchRefId.append(index)
            self.BatchResult.append([])
        raise NotImplementedError
        
    @abstractmethod
    def output(self):        
        try:            
            raise NotImplementedError
            return zip(self.BatchRefId,self.BatchResult)
        finally:
            self.clear()
    
    def clear(self):
        self.BatchFrame.clear()
        self.BatchResult.clear()
        self.BatchRefId.clear()