import datetime
import os
import numpy as np
import sys
import time
import threading

class VideoSplitWriter(threading.Thread):
    """VideoSplitWriter
    Saving Video Stream as mp4 per hours. With random 5 minute range.
    
    """
    def __init__(self):
        threading.Thread.__init__(self)
        self.lastRunTime = None
        self.lastWritingTime = None
        self.is_Saving = False
        self.is_Running = False
        self.fourcc= cv2.VideoWriter_fourcc('m','p','4','v')
        self.writer = None # cv2.VideoWriter('datetime',fourcc,30.0,(1920,1080))
        self.video_path = None
        self.SaveRoot= os.path.join(os.path.expanduser("~"),"Videos","save")
        self.Frame = None
        self.symbo=['/','-','\\','-']
        
    def run(self):
        self.is_Running = True
        self.lastRunTime = datetime.datetime.now() - datetime.timedelta(hours = 1)
        while self.is_alive() and self.is_Running:
            if datetime.datetime.now() - self.lastRunTime >= datetime.timedelta(hours = 1):
                self.SetlastRunTime()
                if not self.is_Saving:
                    dd = datetime.datetime.now()
                    Write_minute = np.random.randint(dd.minute,60)
                    Write_second = np.random.randint(dd.second,60)
                    wait_flag = True
                    count = 0
                    while wait_flag:
                        dd = datetime.datetime.now()
                        if dd.minute >= Write_minute and dd.second >=  Write_second:
                            wait_flag = False
                        sys.stdout.write(f"\rWait for writing at {str(self.lastRunTime.hour).zfill(2)}:{str(Write_minute).zfill(2)}:{str(Write_second).zfill(2)}...{self.symbo[count%len(self.symbo)]}")
                        count+=1
                        time.sleep(1)
                        
                    self.StarWriting()
                    print (f"StartWriting at {self.lastWritingTime}")

                    while datetime.datetime.now() - self.lastWritingTime < datetime.timedelta(minutes = 5):
                        sys.stdout.write(f"\r Writing frame...{self.symbo[count%len(self.symbo)]}")
                        #self.writer.write(self.Frame)
                        time.sleep(1)

                    self.StopWriting()
                    print (f"StopWriting at {datetime.datetime.now()}")
            else:
                print (f"Wait for next hour at {datetime.datetime.now()+datetime.timedelta(hours = 1)}")
                time.sleep(1000*60*60)
                    
                       
    def SetlastRunTime(self):
        self.lastRunTime = datetime.datetime.now()        
        
        
    def StarWriting(self):
        self.is_Saving = True
        self.lastWritingTime = datetime.datetime.now()
        dd = self.lastWritingTime
        video_folder = os.path.join(self.SaveRoot,f"{str(dd.month).zfill(2)}/{str(dd.day).zfill(2)}/{str(dd.hour).zfill(2)}")
        if not os.path.exists(video_folder):
            os.makedirs(video_folder)
        self.video_path = os.path.join(video_folder,f"{str(dd.minute).zfill(2)}-{str(dd.second).zfill(2)}.mp4")
        #self.writer = cv2.VideoWriter(self.video_path,self.fourcc,30.0,(1920,1080))
        
    def StopWriting(self):
        self.is_Saving = False
        if self.writer:
            self.writer.release()
            print("Saved before Released")
        self.writer = None
        self.video_path = None
        
    
    def __del__(self):
        if self.writer:
            self.writer.release()
        self.is_Running = False
        self.join()
        
        
        
        
        
        

if __name__ == '__main__':        
    # video writer per hour
    import cv2
    import datetime
    from Camera_Jetson import Camera
    source="rtsp://192.168.5.218/txg/01"

    cam=Camera(1,source,encoder = "h265",width=1920,height=1080,use_gstr=False)
    
    cam.start()
    is_display = False	

    VioWri = VideoSplitWriter()
    VioWri.start()
    
    fourcc= cv2.VideoWriter_fourcc('m','p','4','v')
    writer = None
    
    break_flag=False
    try:
        if is_display:
            cv2.namedWindow("1",cv2.WINDOW_NORMAL)
            cv2.resizeWindow("1",1280,720)
        while True:
            if break_flag:
                break
            ret,frame = cam.resultQueue.get()
            if ret:
                #VioWri.Frame = frame
                if VioWri.is_Saving:
                    if writer is None:
                        writer = cv2.VideoWriter(VioWri.video_path,fourcc,30.0,(1920,1080))
                    writer.write(frame)
                else:
                    if writer is not None:
                        writer.release()
                        writer = None
                    
                if is_display:
                    cv2.imshow("1",frame)
                    key=cv2.waitKey(1)
                    if key==ord('q'):
                        break_flag=True
                        break
                else:
                    cv2.waitKey(1)
    except Exception as e:
        raise(e)
        cam.stop()
        del (cam)
        del(VioWri)
        if writer is not None:
            writer.release()
        cv2.destroyAllWindows()

    finally:
        cam.stop()
        del (cam)
        del(VioWri)
        if writer is not None:
            writer.release()
        cv2.destroyAllWindows()
