@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>

{{--    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">--}}
    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
{{--    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>--}}
    <script src="/js/bootstrap-toggle.min.js"></script>

@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 col-md-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                <a href="{{ Route("device") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">設備管理</h2></a>
                <div style="height: 5vh"></div>
                {{--空白分隔列--}}
                <div style="overflow: hidden">
                    <nav class="nav flex-column">
                        <a id="title_person" class="nav-link" data-toggle="collapse" href="#collapsePerson" role="button" aria-expanded="false" aria-controls="collapsePerson" href="#" style="color: #ffffff;display: none">人員管理</a>
                        <div class="collapse" id="collapsePerson">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="1" class="nav-link" href="{{ Route("person") }}" style="color: #ffffff;display: none">人臉庫管理</a>
                                <a id="4" class="nav-link" href="{{ Route("comparison") }}" style="color: #ffffff;display: none">打卡紀錄</a>
                                <a id="5" class="nav-link" href="{{ Route("Group_index") }}" style="color: #ffffff;display: none">人員群組管理</a>
                                <a id="6" class="nav-link" href="{{ Route("insert_user") }}" style="color: #ffffff;display: none">使用者管理</a>
                            </div>
                        </div>
                        <a id="title_attendance" class="nav-link" data-toggle="collapse" href="#collapseLeave" role="button" aria-expanded="false" aria-controls="collapseLeave" href="#" style="color: #ffffff;display: none">差勤管理</a>
                        <div class="collapse" id="collapseLeave">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="7" class="nav-link" href="{{ Route("leave_index") }}" style="color: #ffffff;display: none">員工請假</a>
                                <a id="8" class="nav-link" href="{{ Route("businesstrip_index") }}" style="color: #ffffff;display: none">員工出差</a>
                                <a id="17" class="nav-link" href="{{ Route("overtime_index") }}" style="color: #ffffff;display: none">加班申請</a>
                                <a id="9" class="nav-link" href="{{ Route("checkleave_index") }}" style="color: #ffffff;display: none">請假審核</a>
                                <a id="23" class="nav-link" href="{{ Route("check_overtime") }}" style="color: #ffffff;display: none">加班審核</a>
                                <a id="22" class="nav-link" href="{{ Route("statistics_index") }}" style="color: #ffffff;display: none">請假統計</a>
                                <a id="10" class="nav-link" href="{{ Route("attendance") }}" style="color: #ffffff;display: none">出勤管理</a>
                                <a id="11" class="nav-link" href="{{ Route("graph_attendance") }}" style="color: #ffffff;display: none">差勤圖表</a>
                            </div>
                        </div>
                        <a id="title_device"class="nav-link" data-toggle="collapse" href="#collapseDevice" role="button" aria-expanded="false" aria-controls="collapseDevice" href="#" style="color: #ffffff;display: none">設備管理</a>
                        <div class="collapse  show" id="collapseDevice">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="12" class="nav-link" href="{{ Route("device") }}" style="color: #ffffff;background: rgba(255,255,255,0.2);display: none">設備管理</a>
                                <a id="13" class="nav-link" href="{{ Route("type") }}" style="color: #ffffff;display: none">類型管理</a>
                                <a id="14" class="nav-link" href="{{ Route("group") }}" style="color: #ffffff;display: none">群組管理</a>
                                <a id="15" class="nav-link" href="{{ Route("relation") }}" style="color: #ffffff;display: none">設備群組關係</a>
                            </div>
                        </div>
                    </nav>
                    @foreach($authority as $auth)
                        <script>
                            var a_this=document.getElementById({{$auth["features_id"]}});
                            // device.style.visibility="visible";
                            a_this.style.display="";

                            if({{$auth["features_id"]}}=='1' || {{$auth["features_id"]}}=='4' || {{$auth["features_id"]}}=='5' || {{$auth["features_id"]}}=='6' )
                            {
                                var person=document.getElementById("title_person");
                                person.style.display="";
                            }
                            if({{$auth["features_id"]}}=='7' || {{$auth["features_id"]}}=='8' || {{$auth["features_id"]}}=='17' || {{$auth["features_id"]}}=='9' || {{$auth["features_id"]}}=='10' || {{$auth["features_id"]}}=='11'|| {{$auth["features_id"]}}=='22'|| {{$auth["features_id"]}}=='23' )
                            {
                                var attendance=document.getElementById("title_attendance");
                                attendance.style.display="";
                            }
                            if({{$auth["features_id"]}}=='12' || {{$auth["features_id"]}}=='13' || {{$auth["features_id"]}}=='14' || {{$auth["features_id"]}}=='15' )
                            {
                                var device=document.getElementById("title_device");
                                device.style.display="";
                            }
                        </script>
                    @endforeach

                </div>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12" style="text-align: center">
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--頁面選單--}}
                {{ csrf_field() }}
{{--                <div id="menu" class="row align-items-center font-weight-bold " style="background: white;height: 40px; font-size: 16pt;">--}}
{{--                    <div class="col-3 text-center"><a href="{{ Route("device") }}" style="text-decoration:none;color: #1b1e21;">設備管理</a></div>--}}
{{--                    <div class="col-3 text-center"><a href="{{ Route("type") }}" style="text-decoration:none;color: #1b1e21;">類型管理</a></div>--}}
{{--                    <div class="col-3 text-center"><a href="{{ Route("group") }}" style="text-decoration:none;color: #1b1e21;">群組管理</a></div>--}}
{{--                    <div class="col-3 text-center"><a href="{{ Route("relation") }}" style="text-decoration:none;color: #1b1e21;">設備群組關係</a></div>--}}
{{--                </div>--}}
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">

                    <div class="row align-items-center" style="height: 70px;">
                        {{--搜尋設備--}}
                        <div class="col-8">
                            <form action="{{ route("select_device") }}">
                                <div class="input-group">
                                    <Select name=set required data-validation-required-message="選擇搜尋的欄位" class="custom-select" id="set">
                                        <Option value="">選擇搜尋的欄位</Option>
                                        <Option value="ID">設備ID</Option>
                                        <Option value="Location">設備位置</Option>
                                    </Select>
                                    <input  type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="value" placeholder="輸入搜尋的值">
                                    <button type="submit" class="btn btn-primary ">搜尋設備</button>
                                </div>
                            </form>
                        </div>
                        <div class="col-2"></div>
                        <div class="col-2">
                            <p class="text-right ">共{{$count}}個設備</p>
                        </div>
                    </div>



                    {{--呈現設備--}}
                    <table border="3" class="table table-hover" style="text-align:center;">
                        <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>location</th>
                            <th>host</th>
                            <th>port</th>
                            <th>type</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($devices as $device)
                            <tr>
                                <th>{{ $device["id"] }}</th>
                                <th>{{ $device["location"] }}</th>
                                <th>{{$device["host"]}}</th>
                                <th>{{$device["port"]}}</th>
                                @foreach($types as $type)
                                    @if($type["id"]==$device["type"])
                                        <th>{{$type["name"]}}</th>
                                    @endif
                                @endforeach
                                <th>
                                    <button style="width: 70px;" class="btn btn-success"  data-toggle="modal" data-target="#updateModalCenter" onclick="data('{{ $device["id"] }}','{{ $device["location"] }}','{{$device["host"]}}','{{$device["port"]}}','{{$device["type"]}}')"><strong>修改</strong></button>&nbsp&nbsp&nbsp
                                    <button style="width: 70px;" class="btn btn-danger" onclick="javascript:location.href='{{ Route("delete_device",["id"=>$device["id"]]) }}'"><strong>刪除</strong></button>
                                </th>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <script>
                        function data($id,$location,$host,$post,$type) {
                            document.getElementById("update_id").value=$id;
                            document.getElementById("update_location").value=$location;
                            document.getElementById("update_host").value=$host;
                            document.getElementById("update_post").value=$post;
                            document.getElementById("update_type").value=$type;
                        }
                    </script>


                    {{--修改設備類型彈跳視窗--}}
                    <div class="modal fade" id="updateModalCenter" tabindex="-1" role="dialog" aria-labelledby="updateModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">修改設備</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{ route("update_device") }}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroup-sizing-default">設備ID</span>
                                                </div>
                                                <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="id" placeholder="ID" id="update_id">
                                            </div>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroup-sizing-default">設備location</span>
                                                </div>
                                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="location" placeholder="Location" id="update_location">
                                            </div>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroup-sizing-default">設備host</span>
                                                </div>
                                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="host" placeholder="Host" id="update_host">
                                            </div>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroup-sizing-default">設備port</span>
                                                </div>
                                                <input type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="port" placeholder="Port" id="update_post">
                                            </div>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="inputGroup-sizing-default">設備type</span>
                                                </div>
                                                <input readonly type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="type" placeholder="Type" id="update_type">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                                        <button type="submit" class="btn btn-primary" >修改</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>

        {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
        @endif

        {{--force on the camera by you choose--}}
        @if(isset($camera_info))
            <script>
                document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
                document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
                document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
            </script>
    @endif



@endsection
