@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
<link rel="stylesheet" href="/css/selectize.min.css" />
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--已經有在default引入了--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
<script src="/js/selectize.min.js"></script>


{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }

        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
        .seeline{
            border: #ffffff 1px solid;
        }


</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 col-md-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                <a href="{{ Route("leave_index") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">差勤管理</h2></a>
                <div style="height: 5vh"><p style="color: #ffffff">使用者：{{$person_name}}</p></div>
                {{--空白分隔列--}}
                <div style="overflow: hidden">
                    <nav class="nav flex-column">
                        <a id="title_person" class="nav-link" data-toggle="collapse" href="#collapsePerson" role="button" aria-expanded="false" aria-controls="collapsePerson" href="#" style="color: #ffffff;display: none">人員管理</a>
                        <div class="collapse" id="collapsePerson">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="1" class="nav-link" href="{{ Route("person") }}" style="color: #ffffff;display: none">人臉庫管理</a>
                                <a id="4" class="nav-link" href="{{ Route("comparison") }}" style="color: #ffffff;display: none">打卡紀錄</a>
                                <a id="5" class="nav-link" href="{{ Route("Group_index") }}" style="color: #ffffff;display: none">人員群組管理</a>
                                <a id="6" class="nav-link" href="{{ Route("insert_user") }}" style="color: #ffffff;display: none">使用者管理</a>
                            </div>
                        </div>
                        <a id="title_attendance" class="nav-link" data-toggle="collapse" href="#collapseLeave" role="button" aria-expanded="false" aria-controls="collapseLeave" href="#" style="color: #ffffff;display: none">差勤管理</a>
                        <div class="collapse show" id="collapseLeave">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="7" class="nav-link" href="{{ Route("leave_index") }}" style="color: #ffffff;display: none">員工請假</a>
                                <a id="8" class="nav-link" href="{{ Route("businesstrip_index") }}" style="color: #ffffff;background: rgba(255,255,255,0.2);display: none">員工出差</a>
                                <a id="17" class="nav-link" href="{{ Route("overtime_index") }}" style="color: #ffffff;display: none">加班申請</a>
                                <a id="9" class="nav-link" href="{{ Route("checkleave_index") }}" style="color: #ffffff;display: none">請假審核</a>
                                <a id="23" class="nav-link" href="{{ Route("check_overtime") }}" style="color: #ffffff;display: none">加班審核</a>
                                <a id="22" class="nav-link" href="{{ Route("statistics_index") }}" style="color: #ffffff;display: none">請假統計</a>
                                <a id="10" class="nav-link" href="{{ Route("attendance") }}" style="color: #ffffff;display: none">出勤管理</a>
                                <a id="11" class="nav-link" href="{{ Route("graph_attendance") }}" style="color: #ffffff;display: none">差勤圖表</a>
                            </div>
                        </div>
                        <a id="title_device"class="nav-link" data-toggle="collapse" href="#collapseDevice" role="button" aria-expanded="false" aria-controls="collapseDevice" href="#" style="color: #ffffff;display: none">設備管理</a>
                        <div class="collapse " id="collapseDevice">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="12" class="nav-link" href="{{ Route("device") }}" style="color: #ffffff;display: none">設備管理</a>
                                <a id="13" class="nav-link" href="{{ Route("type") }}" style="color: #ffffff;display: none">類型管理</a>
                                <a id="14" class="nav-link" href="{{ Route("group") }}" style="color: #ffffff;display: none">群組管理</a>
                                <a id="15" class="nav-link" href="{{ Route("relation") }}" style="color: #ffffff;display: none">設備群組關係</a>
                            </div>
                        </div>
                    </nav>
                    @foreach($authority as $auth)
                        <script>
                            var a_this=document.getElementById({{$auth["features_id"]}});
                            // device.style.visibility="visible";
                            a_this.style.display="";

                            if({{$auth["features_id"]}}=='1' || {{$auth["features_id"]}}=='4' || {{$auth["features_id"]}}=='5' || {{$auth["features_id"]}}=='6' )
                            {
                                var person=document.getElementById("title_person");
                                person.style.display="";
                            }
                            if({{$auth["features_id"]}}=='7' || {{$auth["features_id"]}}=='8' || {{$auth["features_id"]}}=='17' || {{$auth["features_id"]}}=='9' || {{$auth["features_id"]}}=='10' || {{$auth["features_id"]}}=='11'|| {{$auth["features_id"]}}=='22'|| {{$auth["features_id"]}}=='23' )
                            {
                                var attendance=document.getElementById("title_attendance");
                                attendance.style.display="";
                            }
                            if({{$auth["features_id"]}}=='12' || {{$auth["features_id"]}}=='13' || {{$auth["features_id"]}}=='14' || {{$auth["features_id"]}}=='15' )
                            {
                                var device=document.getElementById("title_device");
                                device.style.display="";
                            }
                        </script>
                    @endforeach


                </div>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12" style="text-align: center">
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--頁面選單--}}
{{--                <div id="menu" class="row" style="background: white">--}}
{{--                    <div class="col-6 text-center"><a href="{{ Route("leave_index") }}" style="text-decoration:none;color: #28a745;">員工請假管理</a></div>--}}
{{--                    <div class="col-6 text-center"><a href="{{ Route("checkleave_index") }}" style="text-decoration:none;color: #1b1e21;">主管審核</a></div>--}}
{{--                </div>--}}

                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 7vh;align-items: center">
                        {{--datetime 起始時間選擇--}}
                        <div class="col-md-3">
                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">起始時間</div>
                                </div>
                                <input id="leave_start" style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        {{--datetime 結束時間選擇--}}
                        <div class="col-md-3">
                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">結束時間</div>
                                </div>
                                <input id="leave_end" style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_leave()">查詢</button>
                        </div>
                        <div class="col-md-3"></div>

                    </div>
                    <div class="row" style="height: 7vh;align-items: center">
                        <div class="col-md-3"></div>
                        <div class="col-md-3">
                            @if($level!="1")
                                <select style="text-align: center"  id="person_choose" placeholder="請選擇姓名" name="person">
                                    <option value=""></option>
                                    @foreach($persons as $person)
                                        @if(isset($person_id))
                                            @if($person["id"]==old('person'))
                                                <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                            @else
                                                <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                            @endif
                                        @else
                                            <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                        @endif
                                    @endforeach
                                </select>
                            @endif
                        </div>
                        <div class="col-md-3">
                            @if($level!="1")
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_leave_personal()">查詢個人</button>
                            @endif
                        </div>
                        <div class="col-md-3 float-right">
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertEmplyoeeLeave">新增出差</button>
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="javascript:location.href='{{ Route("businesstrip_all") }}'">查看所有出差紀錄</button>
                            {{--                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;"  data-toggle="modal" onclick="location.href='{{ route("excel_example") }}'">批量匯入範例</button>--}}
                            {{--                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="post_delete_face()">批量刪除</button>--}}
                        </div>
                    </div>
                        {{-- 新增出差彈出視窗 --}}
                    <div class="modal fade" id="InsertEmplyoeeLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">新增出差</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{ route("post_businesstrip") }}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                <div class="modal-body row">
                                    <div class="col-sm-12">
                                        <div class="form-group row">
                                            <label for="selectPerson" style="text-align: right" class="col-sm-3 col-form-label">出差人員姓名</label>
                                            <div class="col-sm-9">
                                                @if($level=="1")
                                                    <input readonly id='person' name="person" style="text-align: center"  type="hidden" class="form-control" value="{{$person_id}}" >
                                                    <input readonly style="text-align: center"  type="text" class="form-control" value="{{$person_name}}" >
                                                @else
                                                    <select class="custom-select form-control" id="selectPerson" name="person">
                                                        <option disabled selected>請選擇姓名</option>
                                                        @foreach($persons as $person)
                                                            @if($person["id"]==$person_id)
                                                                <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                                            @else
                                                                <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label style="text-align: right;" class="col-sm-3 col-form-label" for="department" >部門</label>
                                            <div class="col-sm-9">
                                                @if($level=="1")
                                                    <input readonly id='department' name="department" style="text-align: center"  type="hidden" class="form-control" value="{{$user_department}}" >
                                                    <input readonly  style="text-align: center"  type="text" class="form-control" value="{{$department_name}}" >
                                                @else
                                                    <select class="custom-select form-control" id="inputDepartment" name="department" required>
                                                        <option selected disabled >請選擇部門</option>
                                                        @foreach($departments as $department)
                                                            @if($department["no"]==$user_department)
                                                                <Option value="{{ $department["no"] }}" selected>{{ $department["department"] }}</Option>
                                                            @else
                                                                <Option value="{{ $department["no"] }}">{{ $department["department"] }}</Option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label style="text-align: right;" class="col-sm-3 col-form-label" for="reason" >地點、原因</label>
                                            <div class="col-sm-9">
                                                <input readonly id='category' name="category" style="text-align: center"  type="hidden" class="form-control" value="出差" >
                                                <input id='reason' name="reason" style="text-align: center"  type="text" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                                <label for="start_time" style="text-align: right" class="col-sm-3 col-form-label">出差時間</label>
                                            <div class="col-9">
                                                <div style="background: white"  class="input-group date" id="datetimepicker3" data-target-input="nearest">
                                                    <input id='start_time' style="text-align: center" name="start_time" type="text" class="col-sm-4 form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                                    <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                                    </div>
                                                    <label class="input-group-text">~</label>
                                                </div>
                                                <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker4" data-target-input="nearest">
                                                    <input id='end_time' style="text-align: center" name="end_time"  type="text" class="col-sm-4 form-control datetimepicker-input" data-target="#datetimepicker4" onblur="date()" required/>
                                                    <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
                                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label style="text-align: right;" class="col-sm-3 col-form-label" for="leave_day" >出差天數</label>
                                            <div class="col-sm-3">
                                                <input id='leave_day' name="leave_day" style="text-align: center"  type="number" class="form-control" onkeyup="value=value.replace(/[^\d]/g,'')" maxlength="2">
                                            </div>
                                            <label style="text-align: right;" class="col-sm-2 col-form-label" for="leave_time" >出差時長</label>
                                            <div class="col-sm-4">
                                                <input id='leave_time' name="leave_time" style="text-align: center"  type="number" class="form-control" step="0.5">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label style="text-align: right;" class="col-sm-3 col-form-label" for="substitute" >代理人</label>
                                            <div class="col-sm-3">
                                                <input id='substitute' name="substitute" style="text-align: center"  type="text" class="form-control">
                                            </div>
                                        </div>
{{--                                        <div class="form-group row">--}}
{{--                                            <label style="text-align: right;" class="col-sm-3 col-form-label" for="selectGroup">上傳證明檔案</label>--}}
{{--                                            <div class="col-sm-9">--}}
{{--                                                <input type="file" id="upload_file" name="upload_file" >--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
                                    </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                                    <button type="submit" class="btn btn-primary" id="insert_btn">提交</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <script>
                        function date()
                        {
                            var start = document.getElementById("start_time");
                            var end = document.getElementById("end_time");
                            if(start.value!=null && end.value!=null)
                            {
                                var day = document.getElementById("leave_day");
                                var hour = document.getElementById("leave_time");
                                var d1 = new Date(start.value);
                                var d1_week=d1.getDay();
                                var d2 = new Date(end.value);
                                var d2_week=d2.getDay();
                                var time=d2-d1;
                                var time_hour=time/1000/60/60;
                                var time_day=time/1000/60/60/24;
                                var day_first=time/1000/60/60/24;
                                if(time_day<=7)
                                {
                                    if(d1_week>d2_week)
                                    {
                                        time_day=time_day-2;
                                        time_hour=time_hour-48;
                                    }
                                }
                                else {
                                    //先去掉頭尾兩週
                                    time_day -= ((7 - d1_week) + (d2_week + 1));
                                    //去掉中間的每週兩天
                                    var weekcount= time_day / 7+1;
                                    time_day = time_day / 7 * 5;
                                    //加回頭尾兩週的工作天
                                    if (d1_week == 0) time_day += 5;
                                    if (d1_week > 0 && d1_week < 6) time_day += (6 - d1_week);
                                    if (d2_week == 6) time_day += 5;
                                    if (d2_week < 6) time_day += d2_week;
                                    time_hour=time_hour-(parseInt(day_first)-parseInt(time_day))*24;
                                }

                                for(i=1;i<time_day;i++){
                                    time_hour=time_hour-15;
                                }
                                if(time_hour>8)
                                {
                                    time_day++;
                                    if(time_hour%9!=0)
                                    {
                                        time_day--;
                                        if(d1.getHours()<=12 && d2.getHours()>=13)
                                            time_hour--;
                                    }
                                }
                                else
                                {
                                    if(d1.getHours()<=12 && d2.getHours()>=13)
                                        time_hour--;
                                }
                                day.value=parseInt(time_day);
                                hour.value=time_hour-(parseInt(time_day));
                                if(time_hour<0)
                                {
                                    alert("時間有錯，結束時間要大於開始時間");
                                    document.getElementById("insert_btn").disabled=true;
                                }
                                else
                                    document.getElementById("insert_btn").disabled=false;

                            }
                        }
                    </script>
                    {{-- 修改出差彈出視窗 --}}
                    <div class="modal fade" id="ModifyLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">修改出差資料</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{ route("update_businesstrip") }}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="modal-body row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <input id='no' name="no" style="text-align: center"  type="hidden">
                                                <label for="selectPerson" style="text-align: right" class="col-sm-3 col-form-label">出差人員姓名</label>
                                                <div class="col-sm-9">
                                                    <input readonly id='midify_person' name="person" style="text-align: center"  type="hidden" class="form-control" >
                                                    <input readonly id='modify_personname'  style="text-align: center"  type="text" class="form-control" >
{{--                                                    <select class="custom-select form-control" id="modify_selectPerson" name="person">--}}
{{--                                                        <option disabled selected>請選擇姓名</option>--}}
{{--                                                        @foreach($persons as $person)--}}
{{--                                                            <option value="{{ $person["id"] }}">{{$person["name"]}}</option>--}}
{{--                                                        @endforeach--}}
{{--                                                    </select>--}}
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="department" >部門</label>
                                                <div class="col-sm-9">
                                                    <input readonly id='modify_department' name="department" style="text-align: center"  type="hidden" class="form-control">
                                                    <input readonly id='modify_department_name' style="text-align: center"  type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="reason" >原因</label>
                                                <div class="col-sm-9">
                                                    <input readonly id='category' name="category" style="text-align: center"  type="hidden" class="form-control" value="出差" >
                                                    <input id='modify_reason' name="reason" style="text-align: center"  type="text" class="form-control" >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                    <label for="start_time" style="text-align: right" class="col-sm-3 col-form-label"> 出差時間</label>
                                                <div class="col-9">
                                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker5" data-target-input="nearest">
                                                        <input id='modify_start_time' style="text-align: center" name="start_time" type="text" class="col-sm-4 form-control datetimepicker-input" data-target="#datetimepicker5" onblur="update_date()" required/>
                                                        <div class="input-group-append" data-target="#datetimepicker5" data-toggle="datetimepicker">
                                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                                        </div>
                                                        <label class="input-group-text">~</label>
                                                    </div>
                                                    <div style="background: white;text-align: right"  class="input-group date" id="datetimepicker6" data-target-input="nearest">
                                                        <input id='modify_end_time' style="text-align: center" name="end_time" type="text" class="col-sm-4 form-control datetimepicker-input" data-target="#datetimepicker6" onblur="update_date()" required/>
                                                        <div class="input-group-append" data-target="#datetimepicker6" data-toggle="datetimepicker">
                                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="leave_day" >出差天數</label>
                                                <div class="col-sm-3">
                                                    <input id='modify_leave_day' name="leave_day" style="text-align: center"  type="number" class="form-control" onkeyup="value=value.replace(/[^\d]/g,'')" maxlength="2">
                                                </div>
                                                <label style="text-align: right;" class="col-sm-2 col-form-label" for="leave_time" >出差時長</label>
                                                <div class="col-sm-4">
                                                    <input id='modify_leave_time' name="leave_time" style="text-align: center"  type="number" class="form-control" step="0.5">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="substitute" >代理人</label>
                                                <div class="col-sm-3">
                                                    <input id='modify_substitute' name="substitute" style="text-align: center"  type="text" class="form-control">
                                                </div>
                                            </div>
{{--                                            <div class="form-group row">--}}
{{--                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="selectGroup">上傳證明檔案</label>--}}
{{--                                                <div class="col-sm-6">--}}
{{--                                                    <input type="file" id="upload_file" name="upload_file" >--}}
{{--                                                </div>--}}
{{--                                                <div id="btn_uf" class="col-sm-3">--}}
{{--                                                    <button id="btn_upload_file" type="button" class="btn btn-secondary" data-container="body" data-toggle="popover" data-trigger="focus" data-placement="right" data-html="true">證明文件</button>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                                        <button type="submit" class="btn btn-primary" id="update_btn">提交</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <script>
                        function update_date()
                        {
                            var start = document.getElementById("modify_start_time");
                            var end = document.getElementById("modify_end_time");
                            if(start.value!=null && end.value!=null)
                            {
                                var day = document.getElementById("modify_leave_day");
                                var hour = document.getElementById("modify_leave_time");
                                var d1 = new Date(start.value);
                                var d1_week=d1.getDay();
                                var d2 = new Date(end.value);
                                var d2_week=d2.getDay();
                                var time=d2-d1;
                                var time_hour=time/1000/60/60;
                                var time_day=time/1000/60/60/24;
                                var day_first=time/1000/60/60/24;
                                if(time_day<=7)
                                {
                                    if(d1_week>d2_week)
                                    {
                                        time_day=time_day-2;
                                        time_hour=time_hour-48;
                                    }
                                }
                                else {
                                    //先去掉頭尾兩週
                                    time_day -= ((7 - d1_week) + (d2_week + 1));
                                    //去掉中間的每週兩天
                                    var weekcount= time_day / 7+1;
                                    time_day = time_day / 7 * 5;
                                    //加回頭尾兩週的工作天
                                    if (d1_week == 0) time_day += 5;
                                    if (d1_week > 0 && d1_week < 6) time_day += (6 - d1_week);
                                    if (d2_week == 6) time_day += 5;
                                    if (d2_week < 6) time_day += d2_week;
                                    time_hour=time_hour-(parseInt(day_first)-parseInt(time_day))*24;
                                }

                                for(i=1;i<time_day;i++){
                                    time_hour=time_hour-15;
                                }
                                if(time_hour>8)
                                {
                                    time_day++;
                                    if(time_hour%9!=0)
                                    {
                                        time_day--;
                                        if(d1.getHours()<=12 && d2.getHours()>=13)
                                            time_hour--;
                                    }
                                }
                                else
                                {
                                    if(d1.getHours()<=12 && d2.getHours()>=13)
                                        time_hour--;
                                }
                                day.value=parseInt(time_day);
                                hour.value=time_hour-(parseInt(time_day));
                                if(time_hour<0)
                                {
                                    alert("時間有錯，結束時間要大於開始時間");
                                    document.getElementById("update_btn").disabled=true;
                                }
                                else
                                    document.getElementById("update_btn").disabled=false;
                            }
                        }
                    </script>
{{--                    <input type="text" id="leave_no" name="leave_no">--}}
                    {{--現有人員資訊區--}}
                    <table class="table table-striped table-bordered table-hover fixed-height" id="tableL01"></table>
                </div>
            </div>
        </div>
    </div>

    <script>
        // $('[data-toggle="popover"]').popover({
        //     title: '證明文件',
        //     content: "test"
        // });
        // $('.popover-dismiss').popover({
        //     trigger: 'focus'
        // })
    </script>
    {{--selectize--}}
    <script>
        $(document).ready(function () {
            $('#person_choose').selectize({
                create:false,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
    {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
    @endif

{{--    boostrap tabel js--}}
    <script>
        // 載入人員資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp

        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷毀表格
        var tableColumns = [
            {field: 'state', checkbox: true,},
            {field: 'name',title: '人員名稱', sortable: false,footerFormatter:"總計"},
            {field: 'start', title: '出差開始時間', sortable: true,
                footerFormatter:function (rows){
                    return "共"+rows.length+"筆";
                }},
            {field: 'end', title: '出差結束時間', sortable: true,
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].leave_time)
                        sum += counts;
                    }
                    return "共"+sum+"小時";
                }},
            {field: 'reason', title: '出差原因', sortable: true},
            {field: 'modify', title: '修改', sortable: false},
            {field: 'delete', title: '刪除', sortable: false},
        ];
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: {{$check}},
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            multipleSelectRow: true,
            sortName:'start', // 預設排序
            sortOrder:'desc',
        });
        // 修改人員資料處理
        function person_modify(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("no").value=jdata[jdata_index].no;
            document.getElementById("midify_person").value=jdata[jdata_index].id;
            document.getElementById("modify_personname").value=jdata[jdata_index].name;
            document.getElementById("modify_department").value=jdata[jdata_index].depart_leave_unit_department;
            document.getElementById("modify_reason").value=jdata[jdata_index].reason;
            document.getElementById("modify_start_time").value=jdata[jdata_index].start;
            document.getElementById("modify_end_time").value=jdata[jdata_index].end;
            document.getElementById("modify_leave_day").value=jdata[jdata_index].leave_day;
            document.getElementById("modify_leave_time").value=jdata[jdata_index].leave_time;
            document.getElementById("modify_substitute").value=jdata[jdata_index].substitute;
            document.getElementById("modify_department_name").value=jdata[jdata_index].department_name;
        }
        function htmlToElement(html) {
            var template = document.createElement('template');
            html = html.trim(); // Never return a text node of whitespace as the result
            template.innerHTML = html;
            return template.content.firstChild;
        }
    </script>
    <script>
        function leave_word(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var leave_no=jdata[jdata_index].no;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("export_leave") }}");
            var id = document.createElement("input");
            id.setAttribute("type", "hidden");
            id.setAttribute("name", "leave_id");
            id.setAttribute("value",leave_no);
            form.appendChild(id);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <script>
        function select_leave() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("select_businesstrip") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        function select_leave_personal() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var person=document.getElementById("person_choose").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("select_businesstrip_personal") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var select_person = document.createElement("input");
            select_person.setAttribute("type", "hidden");
            select_person.setAttribute("name", "person");
            select_person.setAttribute("value",person);
            form.appendChild(select_person);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
    <script>
        {{--    取得已選取目標--}}
        function getIdSelections() {
            // let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            // document.getElementById("leave_no").value=jdata[jdata_index].no;
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.no
            })
        }
        {{--    刪除人臉--}}
        function post_delete_leave(obj) {
            // let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            // document.getElementById("leave_no").value=jdata[jdata_index].no;
            // let idselections=document.getElementById("leave_no").value;
            let idselections=getIdSelections();
            if(confirm("是否刪除"+idselections)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("delete_businesstrip") }}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value",idselections);
                form.appendChild(idselectionsField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
        {{--    人臉圖片預覽--}}
        var inputface=document.getElementById("face-img-input");
        var previewface=document.getElementById("face-img-preview");
        inputface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    previewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        var modifyface=document.getElementById("modify-face-img-input");
        var modifypreviewface=document.getElementById("modify-face-img-preview");
        modifyface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    modifypreviewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
        // 有效期間選擇響應
        function selectExpiryDateonchange(x) {
            let elemet_selted=document.getElementById(x).value;
            // console.log(elemet_selted);
            switch (elemet_selted) {
                case '1':
                    $("#start_time").removeAttr("required");
                    $("#end_time").removeAttr("required");
                    $("#modify-start-time").removeAttr("required");
                    $("#modify-end-time").removeAttr("required");
                    break;
                case '2':
                    $("#start_time").attr("required","true");
                    $("#end_time").attr("required","true");
                    $("#modify-start-time").attr("required","true");
                    $("#modify-end-time").attr("required","true");
                    break;
                default:
                    break;
            }
        }
    </script>
@endsection
