@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
<link rel="stylesheet" href="/css/selectize.min.css" />
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--已經有在default引入了--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
<script src="/js/selectize.min.js"></script>


{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }

        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
        .seeline{
            border: #ffffff 1px solid;
        }


</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 col-md-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                <a href="{{ Route("leave_index") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">差勤管理</h2></a>
                <div style="height: 5vh"></div>
                {{--空白分隔列--}}
                <div style="overflow: hidden">
                    <nav class="nav flex-column">
                        <a id="title_person" class="nav-link" data-toggle="collapse" href="#collapsePerson" role="button" aria-expanded="false" aria-controls="collapsePerson" href="#" style="color: #ffffff;display: none">人員管理</a>
                        <div class="collapse" id="collapsePerson">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="1" class="nav-link" href="{{ Route("person") }}" style="color: #ffffff;display: none">人臉庫管理</a>
                                <a id="4" class="nav-link" href="{{ Route("comparison") }}" style="color: #ffffff;display: none">打卡紀錄</a>
                                <a id="5" class="nav-link" href="{{ Route("Group_index") }}" style="color: #ffffff;display: none">人員群組管理</a>
                                <a id="6" class="nav-link" href="{{ Route("insert_user") }}" style="color: #ffffff;display: none">使用者管理</a>
                            </div>
                        </div>
                        <a id="title_attendance" class="nav-link" data-toggle="collapse" href="#collapseLeave" role="button" aria-expanded="false" aria-controls="collapseLeave" href="#" style="color: #ffffff;display: none">差勤管理</a>
                        <div class="collapse show" id="collapseLeave">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="7" class="nav-link" href="{{ Route("leave_index") }}" style="color: #ffffff;display: none">員工請假</a>
                                <a id="8" class="nav-link" href="{{ Route("businesstrip_index") }}" style="color: #ffffff;display: none">員工出差</a>
                                <a id="17" class="nav-link" href="{{ Route("overtime_index") }}" style="color: #ffffff;display: none">加班申請</a>
                                <a id="9" class="nav-link" href="{{ Route("checkleave_index") }}" style="color: #ffffff;display: none">請假審核</a>
                                <a id="23" class="nav-link" href="{{ Route("check_overtime") }}" style="color: #ffffff;display: none">加班審核</a>
                                <a id="22" class="nav-link" href="{{ Route("statistics_index") }}" style="color: #ffffff;background: rgba(255,255,255,0.2);display: none">請假統計</a>
                                <a id="10" class="nav-link" href="{{ Route("attendance") }}" style="color: #ffffff;display: none">出勤管理</a>
                                <a id="11" class="nav-link" href="{{ Route("graph_attendance") }}" style="color: #ffffff;display: none">差勤圖表</a>
                            </div>
                        </div>
                        <a id="title_device"class="nav-link" data-toggle="collapse" href="#collapseDevice" role="button" aria-expanded="false" aria-controls="collapseDevice" href="#" style="color: #ffffff;display: none">設備管理</a>
                        <div class="collapse " id="collapseDevice">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="12" class="nav-link" href="{{ Route("device") }}" style="color: #ffffff;display: none">設備管理</a>
                                <a id="13" class="nav-link" href="{{ Route("type") }}" style="color: #ffffff;display: none">類型管理</a>
                                <a id="14" class="nav-link" href="{{ Route("group") }}" style="color: #ffffff;display: none">群組管理</a>
                                <a id="15" class="nav-link" href="{{ Route("relation") }}" style="color: #ffffff;display: none">設備群組關係</a>
                            </div>
                        </div>
                    </nav>
                    @foreach($authority as $auth)
                        <script>
                            var a_this=document.getElementById({{$auth["features_id"]}});
                            // device.style.visibility="visible";
                            a_this.style.display="";

                            if({{$auth["features_id"]}}=='1' || {{$auth["features_id"]}}=='4' || {{$auth["features_id"]}}=='5' || {{$auth["features_id"]}}=='6' )
                            {
                                var person=document.getElementById("title_person");
                                person.style.display="";
                            }
                            if({{$auth["features_id"]}}=='7' || {{$auth["features_id"]}}=='8' || {{$auth["features_id"]}}=='17' || {{$auth["features_id"]}}=='9' || {{$auth["features_id"]}}=='10' || {{$auth["features_id"]}}=='11'|| {{$auth["features_id"]}}=='22'|| {{$auth["features_id"]}}=='23' )
                            {
                                var attendance=document.getElementById("title_attendance");
                                attendance.style.display="";
                            }
                            if({{$auth["features_id"]}}=='12' || {{$auth["features_id"]}}=='13' || {{$auth["features_id"]}}=='14' || {{$auth["features_id"]}}=='15' )
                            {
                                var device=document.getElementById("title_device");
                                device.style.display="";
                            }
                        </script>
                    @endforeach
{{--                    @if(isset($level))--}}
{{--                        @if($level!="1")--}}
{{--                            <script>--}}
{{--                                var device=document.getElementById("title_device");--}}
{{--                                // device.style.visibility="visible";--}}
{{--                                device.style.display=""--}}
{{--                            </script>--}}
{{--                        @endif--}}
{{--                    @endif--}}

                </div>

                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12" style="text-align: center">
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>

            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--頁面選單--}}
{{--                <div id="menu" class="row" style="background: white">--}}
{{--                    <div class="col-6 text-center"><a href="{{ Route("leave_index") }}" style="text-decoration:none;color: #28a745;">員工請假管理</a></div>--}}
{{--                    <div class="col-6 text-center"><a href="{{ Route("checkleave_index") }}" style="text-decoration:none;color: #1b1e21;">主管審核</a></div>--}}
{{--                </div>--}}
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>

                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                        {{ csrf_field() }}
                        <div class="row" style="height: 10vh;align-items: center">
                            {{--datetime 起始時間選擇--}}
                            <div class="col-md-3">
                                <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">起始時間</div>
                                    </div>
                                    <input id="leave_start" style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                    <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            {{--datetime 結束時間選擇--}}
                            <div class="col-md-3">
                                <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">結束時間</div>
                                    </div>
                                    <input id="leave_end" style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                    <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <select style="text-align: center"  id="selectPerson" placeholder="請選擇姓名" name="person">
                                    <option value=""></option>
                                    @foreach($persons as $person)
                                        @if(isset($person_id))
                                            @if($person["id"]==$person_id)
                                                <option value="{{ $person["id"] }}" selected>{{$person["name"]}}</option>
                                            @else
                                                <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                            @endif
                                        @else
                                            <option value="{{ $person["id"] }}">{{$person["name"]}}</option>
                                        @endif

                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="select_leave()">查詢</button>
                                @if($level=="3"or$level=="4")
                                    <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="export_leave()">匯出</button>
                                    <button class="btn btn-outline-dark float-left" style="margin-right: 10px;" onclick="export_leave_all()">匯出所有人員</button>
                                @endif
                            </div>
                    </div>
                    {{--現有人員資訊區--}}
                    <table class="table table-striped table-bordered table-hover fixed-height" id="tableL01"></table>
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                        {{--datetime 起始時間選擇--}}
                        <div class="col-3">
                        </div>
                        <div class="col-3">
                        </div>
                        <div class="col-3">
                        </div>
                        <div class="col-3">
                            @if($level=="3"or$level=="4")
                                <form class="row" id="form_attendance_download" method="POST" action="{{ Route("export_annual_statistics") }}">
                                    {{ csrf_field() }}
                                    <div class="input-group date" id="datetimepicker3" data-target-input="nearest" >
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">年份</div>
                                        </div>
                                        <input id='year' style="text-align: center" name="year" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                        <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                        <div class="input-group-append">
                                            <button class="btn btn-dark" type="submit">匯出</button>
                                        </div>
                                    </div>
                                </form>
                            @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

{{--    @if(isset($rowdata))--}}
{{--        <script>--}}
{{--            $('#tableL01').bootstrapTable('hideColumn','補假');--}}
{{--        </script>--}}
{{--    @endif--}}

    <script>
        // $('[data-toggle="popover"]').popover({
        //     title: '證明文件',
        //     content: "test"
        // });
        // $('.popover-dismiss').popover({
        //     trigger: 'focus'
        // })
    </script>
    {{--selectize--}}
    <script>
        $(document).ready(function () {
            $('#selectPerson').selectize({
                create:false,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
    <script>
        // 載入人員資料
        @php
            if (isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).';';
            }else{
                echo "var jdata=[];";
            }
        @endphp
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
    @endif

    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
        <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif

{{--    boostrap tabel js--}}
    <script>
        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷毀表格
        var tableColumns = [
            {field: 'date', title: '日期', sortable: true,footerFormatter:"總計(小時)",align:'center',valign:'middle'},
            {field: '特休', title: '特休', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].特休)
                        sum += counts;
                    }
                    return sum;
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.特休!="0")
                        t=row.特休;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '公假', title: '公假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].公假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.公假!="0")
                        t=row.公假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '事假', title: '事假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].事假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.事假!="0")
                        t=row.事假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '病假', title: '病假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].病假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.病假!="0")
                        t=row.病假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '公傷病假', title: '公傷<br>病假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].公傷病假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.公傷病假!="0")
                        t=row.公傷病假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '婚假', title: '婚假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].婚假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.婚假!="0")
                        t=row.婚假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '產假', title: '產假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].產假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.產假!="0")
                        t=row.產假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '陪產假', title: '陪產<br>假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].陪產假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.陪產假!="0")
                        t=row.陪產假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '喪假', title: '喪假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].喪假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.喪假!="0")
                        t=row.喪假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '生理假', title: '生理<br>假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].生理假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.生理假!="0")
                        t=row.生理假;
                    else
                        t="-";
                    return t;
                }
            },
            {field: '補假', title: '補假', sortable: false,align:'center',valign:'middle',
                footerFormatter:function (rows){
                    var sum=0;
                    for (var i=0;i<rows.length;i++)
                    {
                        var counts=parseFloat(rows[i].補假)
                        sum += counts;
                    }
                    return sum
                },
                formatter:function(value,row,index)
                {
                    var t="";
                    if(row.補假!="0")
                        t=row.補假;
                    else
                        t="-";
                    return t;
                }
            },
        ];
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: true,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'date', // 預設排序
        });


        function htmlToElement(html) {
            var template = document.createElement('template');
            html = html.trim(); // Never return a text node of whitespace as the result
            template.innerHTML = html;
            return template.content.firstChild;
        }
    </script>
{{--    @if(isset($test))--}}
{{--        @foreach($test as $t)--}}
{{--            <script>--}}
{{--                $('#tableL01').bootstrapTable('hideColumn','{{$t}}');--}}
{{--            </script>--}}
{{--        @endforeach--}}
{{--    @endif--}}

    <script>
        function select_leave() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var person=document.getElementById("selectPerson").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("search_statistics") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var select_person = document.createElement("input");
            select_person.setAttribute("type", "hidden");
            select_person.setAttribute("name", "person");
            select_person.setAttribute("value",person);
            form.appendChild(select_person);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <script>
        function export_leave() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var person=document.getElementById("selectPerson").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("export_statistics") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var select_person = document.createElement("input");
            select_person.setAttribute("type", "hidden");
            select_person.setAttribute("name", "person");
            select_person.setAttribute("value",person);
            form.appendChild(select_person);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <script>
        function export_leave_all() {
            var start=document.getElementById("leave_start").value;
            var end=document.getElementById("leave_end").value;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("export_all_statistics") }}");
            var start_time = document.createElement("input");
            start_time.setAttribute("type", "hidden");
            start_time.setAttribute("name", "start");
            start_time.setAttribute("value",start);
            form.appendChild(start_time);
            var end_time = document.createElement("input");
            end_time.setAttribute("type", "hidden");
            end_time.setAttribute("name", "end");
            end_time.setAttribute("value",end);
            form.appendChild(end_time);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY/MM/DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
        <!-- datetimepicker3 物件  -->
        <script type="text/javascript">
            $(function () {
                $('#datetimepicker3').datetimepicker({
                    locale:'zh-tw',
                    // format: 'YYYY-MM-DD a hh:mm:ss ',
                    format: 'YYYY',
                    weekStart: 1,
                    autoclose: 1,
                    todayHighlight: 1,
                    inline:false,
                    allowInputToggle:true,
                    sideBySide:false,
                    stepping:0,
                    minView:0,
                    maxView:0,
                    maxDate:new Date(),
                    startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                    date: new Date("{{ old('end',date("Y")) }}") // 初始化日期
                });
            });
        </script>
    <script>
        {{--    取得已選取目標--}}
        function getIdSelections() {
            // let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            // document.getElementById("leave_no").value=jdata[jdata_index].no;
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.no
            })
        }
        {{--    刪除人臉--}}
        function post_delete_leave(obj) {
            // let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            // document.getElementById("leave_no").value=jdata[jdata_index].no;
            // let idselections=document.getElementById("leave_no").value;
            let idselections=getIdSelections();
            if(confirm("是否刪除"+idselections)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("delete_employeeleave") }}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value",idselections);
                form.appendChild(idselectionsField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
        {{--    人臉圖片預覽--}}
        var inputface=document.getElementById("face-img-input");
        var previewface=document.getElementById("face-img-preview");
        inputface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    previewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        var modifyface=document.getElementById("modify-face-img-input");
        var modifypreviewface=document.getElementById("modify-face-img-preview");
        modifyface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    modifypreviewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
        // 有效期間選擇響應
        function selectExpiryDateonchange(x) {
            let elemet_selted=document.getElementById(x).value;
            // console.log(elemet_selted);
            switch (elemet_selted) {
                case '1':
                    $("#start_time").removeAttr("required");
                    $("#end_time").removeAttr("required");
                    $("#modify-start-time").removeAttr("required");
                    $("#modify-end-time").removeAttr("required");
                    break;
                case '2':
                    $("#start_time").attr("required","true");
                    $("#end_time").attr("required","true");
                    $("#modify-start-time").attr("required","true");
                    $("#modify-end-time").attr("required","true");
                    break;
                default:
                    break;
            }
        }
    </script>
@endsection
