<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//主頁
Route::get('/AI',"AIViewController@index")->name("AI")->middleware('AI_auth');

//設備管理-新
Route::group(['prefix'=>'/Device','middleware'=>'auth'],function (){
    Route::get('/',"DeviceController@index")->name('device');
    Route::get('/device/select',"DeviceController@device_select")->name('select_device');
    Route::post('/device/update',"DeviceController@device_update")->name('update_device');
    Route::get('/device/delete',"DeviceController@device_delete")->name('delete_device');
    Route::get('/type',"DeviceController@type")->name('type');
    Route::get('/type/select',"DeviceController@type_select")->name('select_type');
    Route::post('/type/insert',"DeviceController@type_insert")->name('insert_type');
    Route::post('/type/update',"DeviceController@type_update")->name('update_type');
    Route::get('/type/delete',"DeviceController@type_delete")->name('delete_type');
    Route::get('/group',"DeviceController@group")->name('group');
    Route::get('/group/select',"DeviceController@group_select")->name('select_group');
    Route::post('/group/insert',"DeviceController@group_insert")->name('insert_group');
    Route::post('/group/update',"DeviceController@group_update")->name('update_group');
    Route::get('/group/delete',"DeviceController@group_delete")->name('delete_group');
    Route::get('/relation',"DeviceController@relation")->name('relation');
    Route::get('/relation/select',"DeviceController@relation_select")->name('select_relation');
    Route::post('/relation/insert',"DeviceController@relation_insert")->name('insert_relation');
    Route::get('/relation/delete',"DeviceController@relation_delete")->name('delete_relation');
});
// 設備管理
Route::group(['prefix'=>'/Camera','middleware'=>'auth'],function (){
    Route::get('/',"CameraController@index")->name('camera');
    Route::get('/show/{id}',"CameraController@index_show")->name('show_camera');
    Route::get('/insert',"CameraController@insert_index")->name('insert_camera');
    Route::post('/insert',"CameraController@insert")->name('post_insert_camera');
    Route::get('/modify/{id}',"CameraController@modify_index")->name('modify_camera');
    Route::post('/modify',"CameraController@modify")->name('post_modify_camera');
    Route::post('/drop',"CameraController@drop")->name('drop_camera');
});

// 人員管理
Route::group(['prefix'=>'/Person','middleware'=>'auth'],function (){
    Route::get('/',"PersonController@index")->name('person');
    Route::post('/',"PersonController@person_search_type")->name('person_search_type');
    Route::get('/insert',"PersonController@insert_index")->name('insert_person');
    Route::post('/insert',"PersonController@insert")->name('post_insert_person');
    Route::post('/insert/face',"PersonController@insert_face")->name('post_insert_face');
    Route::post('/insert/face/no/image',"PersonController@insert_face_no_image")->name('post_insert_face_no_image');
    Route::post('/delete/face',"PersonController@delete_face")->name('post_delete_face');
    Route::post('/attendance',"PersonController@post_attendance")->name('attendance');
    Route::post('/attendance/download',"PersonController@post_attendance_download")->name('attendance_download');
    Route::post('/attendance/download/day',"PersonController@post_attendance_download_day")->name('attendance_download_day');
    Route::get('/attendance',"PersonController@attendance_index")->name('attendance');
    Route::get('/comparison',"PersonController@comparison_index")->name('index_comparison');
    Route::post('/comparison',"PersonController@post_comparison")->name('comparison');
    Route::post('/modify',"PersonController@post_modify")->name('modify_person');
    Route::post('/file',"PersonController@files")->name('files');

});

//使用者的登入頁面
Route::group(['prefix'=>'/'],function(){
    Route::get('/',"UserController@index")->name('user');
    Route::post('/',"UserController@user_login")->name('user_login');//使用者驗證
});

//使用者的新增、修改、刪除
Route::group(['prefix'=>'/User','middleware'=>'auth'],function(){
    Route::get('/logout',"UserController@user_logout")->name('user_logout');//使用者登出
    Route::get('/',"UserController@index_insert")->name('insert_user');
    Route::post('/insert/user',"UserController@insert_user")->name('post_insert_user');
    Route::post('/delete',"UserController@delete_user")->name('post_delete_user');
    Route::post('/modify',"UserController@post_modifyuser")->name('modify_user');
    Route::post('/searchuser',"UserController@search_user")->name('search_user');

});
//人員群組的頁面
Route::group(['prefix'=>'/PersonG','middleware'=>'auth'],function(){
    Route::get('/',"PersonGroupController@Group_index")->name('Group_index');
    Route::post('/',"PersonGroupController@personG_search")->name('personG_search');
    Route::post('/searchGroup',"PersonGroupController@search_Group")->name('search_Group');
    Route::post('/searchpersonGroup',"PersonGroupController@search_personGroup")->name('search_personGroup');
    Route::post('/insertGroup',"PersonGroupController@insert_Group")->name('insert_Group');
    Route::post('/modifyGroup',"PersonGroupController@modify_Group")->name('modify_Group');
    Route::post('/deleteGroup',"PersonGroupController@delete_Group")->name('delete_Group');
    Route::post('/insertpersonG',"PersonGroupController@insert_personG")->name('insert_personG');
    Route::post('/deletepersonG',"PersonGroupController@delete_personG")->name('delete_personG');

});


// 人員查詢
Route::group(['prefix'=>'/Search','middleware'=>'auth'],function (){
    Route::get('/',"SearchController@index")->name('search');
    Route::post('/p',"SearchController@search")->name('searchp');
});

//play_v2
Route::group(['prefix'=>'/play_v2','middleware'=>'auth'],function(){
    Route::get('/',function (){return view('play_v2',['title'=>'攝影機調閱']);})->name('play_v2');
    Route::get('/index','CamdbController@show_in_playv2');
});

// 廣播事件
Route::get('broadcast', function(){
    broadcast(new \App\Events\FaceEvent);
});
// 觸發偵測到新人臉
Route::get('/new/face',"AIViewController@new_face_index");
Route::post('/new/face',"AIViewController@new_face_broadcast");

// 測試
Route::get('/test',function (){
    return view("test");
});


Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
