@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>

    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="/js/bootstrap-toggle.min.js"></script>

@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <a href="{{ Route("person") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">人員管理</h2></a>
                {{--@include('layout.menubtn')--}}
                <div style="height: 5vh"></div>
                <h2 class="text-white"style="font-size: 20pt;text-align: center">現有設備</h2>
                {{--新增刪除修改按鈕--}}
                {{--                <div class="row" style="height: 10vh">--}}
                {{--                    <div class="col-4"><button class="btn-light" title="新增攝影機" ><img style="height: 100%;width: 100%" src="{{ asset("icon/create_pen.svg") }}"></button></div>--}}
                {{--                    <div class="col-4"><button class="btn-light" title="移除攝影機" ><img style="height: 100%;width: 100%" src="{{ asset("icon/remove_rubbish-bin.svg") }}"></button></div>--}}
                {{--                    <div class="col-4"><button class="btn-light" title="修改攝影機" ><img style="height: 100%;width: 100%" src="{{ asset("icon/update_file.svg") }}"></button></div>--}}
                {{--                </div>--}}
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 60vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                                        {{ $camera["name"] }}
                                                    </button>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>

            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row align-items-center font-weight-bold " style="background: white;height: 40px; font-size: 16pt;">
                    <div class="col-3 text-center"><a href="{{ Route("device") }}" style="text-decoration:none;color: #1b1e21;">設備管理</a></div>
                    <div class="col-3 text-center"><a href="{{ Route("type") }}" style="text-decoration:none;color: #1b1e21;">類型管理</a></div>
                    <div class="col-3 text-center"><a href="{{ Route("group") }}" style="text-decoration:none;color: #1b1e21;">群組管理</a></div>
                    <div class="col-3 text-center"><a href="{{ Route("relation") }}" style="text-decoration:none;color: #1b1e21;">設備群組關係</a></div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">

                    <div class="row align-items-center" style="height: 70px;">
                        {{--搜尋設備類型--}}
                        <div class="col-8">
                            <form action="{{ route("select_relation") }}">
                                <div class="input-group">
                                    <Select name=set required data-validation-required-message="選擇搜尋的欄位" class="custom-select " id="group_id">
                                        <Option value="">選擇搜尋的欄位</Option>
                                        <Option value="DeviceID">設備ID</Option>
                                        <Option value="DeviceGroupID">群組名稱</Option>
                                    </Select>
                                    <input  type="text" class="form-control" aria-label="Default" aria-describedby="inputGroup-sizing-default" name="value" placeholder="輸入搜尋的值">
                                    <button type="submit" class="btn btn-primary ">搜尋設備與群組關係</button>
                                </div>
                            </form>
                        </div>
                        <div class="col-2"></div>
                        {{--新增設備類型--}}
                        <div class="col-2">
                            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#exampleModalCenter">
                                新增設備與群組關係
                            </button>
                        </div>
                    </div>



                    {{--呈現設備群組關係--}}
                    <table border="3" class="table table-hover" style="text-align:center;">
                        <thead class="thead-dark">
                        <tr>
                            <th>群組名稱</th>
                            <th>設備</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($relations as $relation)
                            <tr>
                                @foreach($device_groups as $device_group)
                                    @if($relation["device_group_id"]==$device_group["id"])
                                        <th>{{ $device_group["name"] }}</th>
                                    @endif
                                @endforeach
                                <th>{{ $relation["device_id"] }}</th>
                                <th><button style="width: 70px;" class="btn btn-danger" onclick="javascript:location.href='{{ Route("delete_relation",["device_id"=>$relation["device_id"],"device_group_id"=>$relation["device_group_id"]]) }}'" ><strong>刪除</strong></button></th>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                    @if(isset($count))
                        <p class="text-right ">共{{$count}}個設備</p>
                    @endif

                </div>

            </div>

        </div>

        {{--新增群組彈跳視窗--}}
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">新增設備與群組關係</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route("insert_relation") }}" method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <div class="modal-body">
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <label class="input-group-text" for="inputGroupSelect01">選擇設備ID</label>
                                    </div>
                                    <Select name=device_id style="width: 200px;" required data-validation-required-message="設備ID" class="custom-select" id="device_id">
                                        @foreach($groups as $group)
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <Option value="{{ $camera["id"] }}">{{ $camera["id"] }}</Option>
                                            @endforeach
                                        @endforeach
                                    </Select>
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <label class="input-group-text" for="inputGroupSelect01">選擇群組</label>
                                    </div>
                                    <Select name=group_id style="width: 200px;" required data-validation-required-message="群組ID" class="custom-select" id="group_id">
                                        @foreach($device_groups as $device_group)
                                            <Option value="{{ $device_group["id"] }}">{{ $device_group["name"] }}</Option>
                                        @endforeach
                                    </Select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                            <button type="submit" class="btn btn-primary">新增</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
        @endif

        {{--force on the camera by you choose--}}
        @if(isset($camera_info))
            <script>
                document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
                document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
                document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
            </script>
    @endif


@endsection
