@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/video.js/6.0.0-RC.5/video.js"></script>--}}
    <!-- PC 端浏览器不支持播放 hls 文件(m3u8), 需要 videojs-contrib-hls 来给我们解码 -->
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/videojs-contrib-hls/5.3.3/videojs-contrib-hls.js"></script>--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/videojs-hotkeys/0.2.25/videojs.hotkeys.min.js"></script>--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/videojs-flash/2.2.1/videojs-flash.min.js"></script>--}}
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
    {{--include flv js libary--}}
    <script src="/js/flv.min.js"></script>
    {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 30%;
            align-self:center ;
            margin-left: 2%;
        }

        /*2*2攝影機版面配置*/
        div.max-4{
            width: 50%;
            height: 36vh;
            padding-left: 0px;
            padding-right: 0px;
            background-color: black;
        }

        /*3*3攝影機版面配置*/
        div.max-9{
            width: 33%;
            height: 24vh;
            padding-left: 0px;
            padding-right: 0px;
            background-color: black;
        }
        /*4*4攝影機版面配置*/
        div.max-16{
            width: 25%;
            height: 18vh;
            padding-left: 0px;
            padding-right: 0px;
            background-color: black;
        }

        /*video palyer配置*/
        video.max-grid{
             height: 72vh;
             width: 100%;
             border-style: ridge;
             border-color: wheat;
         }
        video.max-grid-4{
            height: 36vh;
            width: 100%;
            border-style: ridge;
            border-color: wheat;
        }
        video.max-grid-9{
            height: 24vh;
            width: 100%;
            border-style: ridge;
            border-color: wheat;
        }
        video.max-grid-16{
            height: 18vh;
            width: 100%;
            border-style: ridge;
            border-color: wheat;
        }

        /*IOT信號燈*/
        span.iot-sign{
            width: 100%;
            color: white;
        }
        label.iot-msg{
            width: 100%;
            text-align: center;
        }

        /*圓形button*/
        button.btn-circle.btn-xl {
            width: 70px;
            height: 70px;
            padding: 10px 16px;
            border-radius: 35px;
            font-size: 24px;
            line-height: 1.33;
        }

        button.btn-circle {
            width: 30px;
            height: 30px;
            padding: 6px 0px;
            border-radius: 15px;
            text-align: center;
            font-size: 12px;
            line-height: 1.42857;
        }

    </style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        {{--提示音效--}}
        <audio autoplay="autoplay" id="auto" src=""></audio>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <h2 class="text-white"style="font-size: 20pt;text-align: center;">選擇</h2>
                <h2 class="text-white"style="font-size: 20pt;text-align: center;">直播/回播</h2>
                <div style="padding: 1%;text-align: left;">
                    <input id="toggle-event" type="checkbox" data-toggle="toggle" data-on="直播" data-off="回播" data-onstyle="danger" data-offstyle="info" data-width="100%" size="large">
                </div>
                @include('layout.menubtn')
                {{--測試按鈕--}}
                {{--<button ondblclick="play_stream()">test</button>--}}
                <h2 class="text-white"style="font-size: 20pt">攝影機選項</h2>
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 52vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;" ondblclick="add_stream('{{ $group['group'] }}','{{ $camera["name"]}}','{{ $camera["rtmp_stream"] }}')">
                                                        {{ $camera["name"] }}
                                                    </button>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12">
                        <label style="text-align:left;font-size:16px;color: #ffffff">使用者：{{$msg}}&nbsp; </label>
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-8" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row" style="background: white">
                    <div class="col-4 text-center"><a href="{{ Route("device") }}" style="text-decoration:none;color: #1b1e21;">設備管理</a></div>
                    <div class="col-4 text-center"><a href="{{ Route("person") }}" style="text-decoration:none;color: #1b1e21;">人員管理</a></div>
                    <div class="col-4 text-center"><a href="{{ Route("insert_user") }}" style="text-decoration:none;color: #1b1e21;">使用者管理</a></div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" class="row container" style="height: 72vh;width: 100%;margin-right: 0px;margin-left: 0px;">
                    {{--時間輸入區域--}}
{{--                    <div class="row" style="visibility: hidden;" id="time_aria">--}}
{{--                        <div class="col-auto">--}}
{{--                            <h2>開始時間：</h2>--}}
{{--                            <input id='st_time' style="text-align: center;width: 100%" name="st_time" type="text" required/>--}}
{{--                        </div>--}}
{{--                        <div class="col-auto">--}}
{{--                            <h2>結束時間：</h2>--}}
{{--                            <input id='en_time' style="text-align: center;width: 100%" name="en_time" type="text" required/>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                    <div class="col-1"></div>
                    {{-- 攝影機畫面 --}}
                    <div id="player-grid" class="col-10" style="padding-right: 0px;padding-left: 0px">
                    {{-- print row --}}
                    @for($i=1;$i<4;$i++)
                        <div class="row" style="height: 24vh">
                            {{-- print col --}}
                            @for($j=1;$j<4;$j++)
                                <div class="col-sm-4 max-9">
                                    <video id="{{ "videoElement".$i.$j }}" class="max-grid-9" muted></video>
                                </div>
                            @endfor
                        </div>
                    @endfor
                    </div>
                    <div class="col-1" style="align-self: flex-end;padding-left: 3%;">
                        <button class="btn btn-primary btn-circle" onclick="">re</button>
                        <button class="btn btn-primary btn-circle" onclick="create_player1()">1</button>
                        <button class="btn btn-primary btn-circle" onclick="create_player4()">4</button>
                        <button class="btn btn-primary btn-circle" onclick="create_player9()">9</button>
                        <button class="btn btn-primary btn-circle" onclick="create_player16()">16</button>
                    </div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh"></div>
{{--                IOT 顯示與訊號燈--}}
                <div class="row" style="height: 10vh;width: 100%;margin-left: 0px;margin-right: 0px;align-content: center">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div class="row">
                            <div class="col-3">
                                <label class="iot-msg">門</label>
                                <span id="door" class="badge badge-pill badge-success iot-sign">...</span>
                            </div>
                            <div class="col-3">
                                <label class="iot-msg">溫度</label>
                                <span id="temperature" class="badge badge-pill badge-danger iot-sign">...</span>
                            </div>
                            <div class="col-3">
                                <label class="iot-msg">濕度</label>
                                <span id="humidity" class="badge badge-pill badge-warning iot-sign">...</span>
                            </div>
                            <div class="col-3">
                                <label class="iot-msg">PM2.5</label>
                                <span id="pm2.5" class="badge badge-pill badge-info iot-sign">...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{--攝影機 辨識結果區--}}
            <div id="face-aria" class="col-md-2" style="height: 100vh;overflow-y: scroll;background-color: black;">
            <ul id="face-box" class="list-unstyled" style="padding-top: 10%">
                {{--<li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">--}}
                {{--<img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg" id="face1">--}}
                {{--<div class="media-body">--}}
                    {{--<p class="information">2019-12-20</p>--}}
                    {{--<p class="information">18:03:15</p>--}}
                    {{--<p class="information">姓名：Allen</p>--}}
                    {{--<p class="information">相似度：87%</p>--}}
                {{--</div>--}}
                {{--</li>--}}
                {{--<li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">--}}
                    {{--<img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg" id="face1">--}}
                    {{--<div class="media-body">--}}
                        {{--<p class="information">2019-12-20</p>--}}
                        {{--<p class="information">18:03:15</p>--}}
                        {{--<p class="information">姓名：Allen</p>--}}
                        {{--<p class="information">相似度：87%</p>--}}
                    {{--</div>--}}
                {{--</li>--}}

                {{--初始化10張最近結果--}}
                @foreach($data as $d)
                    <li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">
                        <img class="faceimg" src="{{ $imgserver.$d[$snapshot] }}">
                        <div class="media-body">
                            <p class="information">{{ explode(" ", $d[$time])[0] }}</p>
                            <p class="information">{{ explode(" ", $d[$time])[1] }}</p>
                            <p class="information">姓名：{{ $d[$id] }}</p>
                            <p class="information">相似度：{{ $d[$score] }}</p>
                        </div>
                    </li>
                @endforeach
            </ul>
            </div>
        </div>

    </div>




    {{-------------Bruce video js直播回撥-----------------}}

    {{--直播/回播 toggle 修正--}}
    <script>
        var Rp=true;
        $(function() {
            // 直播
            $('#toggle-event').bootstrapToggle('on');
            document.getElementById("menu").style.visibility="hidden";
            //修正toggle偏移
            document.getElementsByClassName("toggle-on")[0].style.paddingLeft="24px";
            document.getElementsByClassName("toggle-on")[0].style.paddingRight="24px";
            $('#toggle-event').change(function() {
                if ($(this).prop('checked'))
                {
                    //直播
                    Rp=true;
                    document.getElementById("menu").style.visibility="hidden";
                    document.getElementById("time_aria").style.visibility="hidden";
                    document.getElementById("start_time").value="";
                    document.getElementById("end_time").value="";
                    document.getElementById("st_time").value="";
                    document.getElementById("en_time").value="";
                    //修正toggle偏移
                    document.getElementsByClassName("toggle-on")[0].style.paddingLeft="24px";
                    document.getElementsByClassName("toggle-on")[0].style.paddingRight="24px";
                }
                else
                {
                    //回播
                    Rp=false;
                    document.getElementById("menu").style.visibility="visible";
                    document.getElementById("time_aria").style.visibility="visible";
                    //修正toggle偏移
                    document.getElementsByClassName("toggle-off")[0].style.paddingRight="24px";
                    document.getElementsByClassName("toggle-off")[0].style.paddingLeft="24px";
                }

                now_play_urls.length=0;
                disposeAllScreens();
                for (var i in now_group_list){
                    unsetGroup_color(now_group_list[i])
                }
                now_group_list.length=0;
                for (var i in now_play_list){
                    unsetCamid_color(now_play_list[i])
                }
                now_play_list.length=0;

            })
        })
    </script>

    {{--    選中的攝影機變為綠色  否則白色--}}
    <script>
        function setCamid_color($cam_id) {
            document.getElementById($cam_id+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById($cam_id).setAttribute("style","color: #2fa360;font-weight: bolder;");
        }
        function unsetCamid_color($cam_id) {
            document.getElementById($cam_id+"_btn").setAttribute("style","background-color:transparent;color: white;border: none;");
            document.getElementById($cam_id).setAttribute("style","color: white;");
        }

        function setGroup_color($group) {
            document.getElementById($group+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById($group+"_tag").setAttribute("style","color: #2fa360;font-weight: bolder;");
        }
        function unsetGroup_color($group) {
            document.getElementById($group+"_btn").setAttribute("style","background-color:transparent;color: white;border: none;");
            document.getElementById($group+"_tag").setAttribute("style","color: white;");
        }
    </script>

    {{--sock io listener 人臉辨識結果推送--}}
    {{--<script src="//{{ Request::getHost() }}:6001/socket.io/socket.io.js"></script>--}}
    <script src="//192.168.5.17:6001/socket.io/socket.io.js"></script>
    <script src="{{ sprintf("//%s:%s/socket.io/socket.io.js",env("ECHO_SERVER_SOCKET_HOST"),env("ECHO_SERVER_SOCKET_PORT")) }}"></script>
    <script src="{{ url("/js/laravel-echo-setup.js") }}" type="text/javascript"></script>
    <script>
        var vip_id=["RD10801","RD10501","RD10001","RD00001"];
        window.Echo.channel('laravel_database_face')
            .listen('FaceEvent',(e)=>{
                $("#face-box").prepend("<li class=\"media bg-dark\" style=\"border: 1px solid #004085;margin-bottom: 5%\">\n" +
                    "                        <img class=\"faceimg\" src=\""+e["imgserver"]+e["snapshot"]+"\">\n" +
                    "                        <div class=\"media-body\">\n" +
                    "                            <p class=\"information\">"+e["time"].split(" ")[0]+"</p>\n" +
                    "                            <p class=\"information\">"+e["time"].split(" ")[1]+"</p>\n" +
                    "                            <p class=\"information\">姓名："+e["id"]+"</p>\n" +
                    "                            <p class=\"information\">相似度："+e["score"]+"</p>\n" +
                    "                        </div>\n" +
                    "                    </li>");
                // alert(e["time"].split(" ")[0]);

                // 播報提示音
                var auto = $("#auto");
                if(vip_id.indexOf(e["id"])>-1){
                    auto.attr("src","{{ asset('sound/vip_alert.mp3') }}");
                }else if(e["id"]==="Unknow"){
                    auto.attr("src","{{ asset('sound/unknow_alert.mp3') }}");
                }else{
                    auto.attr("src","{{ asset('sound/success_alert.mp3') }}");
                }

        })
    </script>
{{--    人臉門口機溫度廣播--}}
    <script>
        var vip_id=["RD10801","RD10501","RD10001","RD00001"];
        window.Echo.channel('FaceTemperature')
            .listen('FaceTemperatureEvent',(e)=>{
                let face_media=document.createElement("li");
                face_media.setAttribute("class","media bg-dark");
                face_media.setAttribute("style","border: 1px solid #004085;margin-bottom: 5%");

                let face_img=document.createElement("img");
                face_img.setAttribute("class","faceimg");
                face_img.setAttribute("src","{{ $newimgserver }}"+e["snapshot"]);

                let face_media_body=document.createElement("div");
                face_media_body.setAttribute("class","media-body");

                let face_day=document.createElement("p");
                face_day.setAttribute("class","information");
                face_day.innerText=e["time"].split(" ")[0];

                let face_time=document.createElement("p");
                face_time.setAttribute("class","information");
                face_time.innerText=e["time"].split(" ")[1];

                let face_name=document.createElement("p");
                face_name.setAttribute("class","information");
                face_name.innerText="姓名："+e["name"];

                let face_temp=document.createElement("p");
                face_temp.setAttribute("class","information");
                face_temp.innerText="溫度："+e["temperature"];

                let face_location=document.createElement("p");
                face_location.setAttribute("class","information");
                face_location.innerText="地點："+e["location"];

                face_media_body.appendChild(face_day);
                face_media_body.appendChild(face_time);
                face_media_body.appendChild(face_name);
                face_media_body.appendChild(face_temp);
                face_media_body.appendChild(face_location);
                face_media.appendChild(face_img);
                face_media.appendChild(face_media_body);
                $("#face-box").prepend(face_media);
            })
    </script>
{{--    sock io listener IOT 回傳數值--}}
    <script>
        window.Echo.channel("IOT")
            .listen("UpdateIOT",(e)=>{
                // 更新數值
                document.getElementById("door").innerText=e['Door'];
                document.getElementById("temperature").innerText=e['Temperature'];
                document.getElementById("humidity").innerText=e['Humidity'];
                document.getElementById("pm2.5").innerText=e['PM2.5'];
                // 更新顏色
                // 演示PM2.5分三級
                if(0<=e['PM2.5'] && e['PM2.5']<=35){
                    document.getElementById("pm2.5").setAttribute("class","badge badge-pill badge-success iot-sign");
                }else if(36<=e['PM2.5'] && e['PM2.5']<=53){
                    document.getElementById("pm2.5").setAttribute("class","badge badge-pill badge-warning iot-sign");
                }else{
                    document.getElementById("pm2.5").setAttribute("class","badge badge-pill badge-danger iot-sign");
                }
            })
    </script>
    {{--    sock io listener ZigbeeGateway IOT 回傳數值--}}
    <script>
        window.Echo.channel("IOT/ZigbeeGateway")
            .listen("UpdateIOT",(e)=>{
                // 更新數值
                document.getElementById("temperature").innerText=e['溫度'];
                document.getElementById("humidity").innerText=e['濕度'];
                // document.getElementById("pm2.5").innerText=e['PM2.5'];
                // 門窗更新顏色
                if(e['門窗傳感器']){
                    document.getElementById("door").innerText="門關上了";
                    document.getElementById("door").setAttribute("class","badge badge-pill badge-success iot-sign");
                }else{
                    document.getElementById("door").innerText="門打開了";
                    document.getElementById("door").setAttribute("class","badge badge-pill badge-danger iot-sign");
                }
            })
    </script>
    {{--Allen flvjs直播功能--}}
    {{--新增video物件->綁定flvjs->設定flvjs播放參數->播放--}}
    <script>
        onplay_stream=[]; // 紀錄正在撥放之串流
        onplay_player=[]; // 紀錄正在撥放之撥放器
        flv_playlist=[]; // 紀錄正在撥放之flv player
        groups=[]; //
        cams=[]; //
        // 取得所有video標籤(撥放器)的id
        video_players=[];
        Array.from(document.getElementsByTagName('video'))
            .forEach(function (item) {
                video_players.push(item.getAttribute('id'));
            });
        // console.log(video_players.filter(n =>!onplay_player.includes(n)));
        // 新增撥放串流事件
        function add_stream(group,cam,stream) {
            // 確認是否已經撥放
            let index=onplay_stream.indexOf(stream);
            if (index >-1) {
                // 存在
                // 取消播放
                flv_playlist[index].destroy();
                // 從array移除
                flv_playlist.splice(index,1);
                onplay_stream.splice(index,1);
                onplay_player.splice(index,1);
                groups.splice(index,1);
                cams.splice(index,1);
                // 修改button為未啟動(白色)
                unsetCamid_color(group+cam);
                // setGroup_color(group);
            } else {
                // 不存在
                // 播放此串流
                // 搜尋可用撥放器(所有撥放器減去正在播放的)
                let offplay_player = video_players.filter(n => !onplay_player.includes(n));
                // 判斷是否還有空的撥放器
                if(offplay_player.length!==0){
                    // 建立flv player物件並設定參數
                    let flvPlayer = flvjs.createPlayer({
                        type: 'flv',
                        hasAudio:false,
                        hasVideo:true,
                        isLive:true,
                        url: stream,
                        autoplay:false,
                        enableWorker:true,
                        enableDurationMonitor: true,
                        enableVideoFrozenMonitor:true,
                        autoCleanupSourceBuffer:true,
                        enableStashBuffer: false,
                        autoCleanupMaxBackwardDuration: 60,
                        autoCleanupMinBackwardDuration: 30,
                        statisticsInfoReportInterval: 2000,
                        stashInitialSize: 128 * 1024,
                        // enableStashBuffer: false,
                        // stashInitialSize: 128
                    });
                    // 綁定拋出錯誤事件
                    flvPlayer.on(flvjs.Events.ERROR,(errorType, errorDetail, errorInfo) => {
                        console.log('errorType:', errorType);
                        console.log('errorDetail:', errorDetail);
                        console.log('errorInfo:', errorInfo);
                        console.log('重啟串流');
                        add_stream(group,cam,stream);
                        add_stream(group,cam,stream);
                        console.log('啟動完成');
                    });
                    // 綁定 VIDEO_FROZEN 事件當串流卡住重載
                    flvPlayer.on(flvjs.Events.VIDEO_FROZEN,()=>{
                        console.log('--== video frozen ==--');
                        flvPlayer.load();
                        flvPlayer.play();
                    });
                    // 綁定 LOADING_COMPLETE 事件
                    flvPlayer.on("LOADING_COMPLETE",()=>{
                        console.log("loading done");
                    });
                    // 取得尚未撥放之video物件
                    let videoElement=document.getElementById(offplay_player[0]);
                    // 綁定flv player至video player
                    flvPlayer.attachMediaElement(videoElement);
                    flvPlayer.load();
                    flvPlayer.play();

                    // 綁定雙擊全螢幕事件
                    videoElement.ondblclick=function () {
                        videoElement.requestFullscreen();
                    };

                    // 綁定監聽fullscreenchange事件
                    videoElement.addEventListener("fullscreenchange",function () {
                        if(document.fullscreenElement){
                            console.log("full screen");
                            // add_stream(group,cam,stream);
                            // add_stream(group,cam,"http://192.168.5.17/480P/RD/01.flv");
                        }else{
                            console.log("exit full screen");
                            // add_stream(group,cam,"http://192.168.5.17/480P/RD/01.flv");
                            // add_stream(group,cam,stream);
                        }
                    });

                    // 紀錄至array中
                    flv_playlist.push(flvPlayer);
                    onplay_player.push(offplay_player[0]);
                    onplay_stream.push(stream);
                    groups.push(group);
                    cams.push(cam);

                    // 修改button為啟動(綠色)
                    setCamid_color(group+cam);
                    // setGroup_color(group);
                }
            }
        }
    </script>

{{--    定時確認buffer追趕--}}
    <script type="text/javascript">
        let time=5;
        let CurrentTime2Buffered=currentTime2bufferedInterval();
        function currentTime2bufferedInterval() {
            return setInterval(function () {
                flv_playlist.forEach(function (item,index) {
                    // console.log(item.buffered.end(0)-item.currentTime);
                    if(item.buffered.end(0)-item.currentTime>=time){
                        console.log("---buffer is large---");
                        item.currentTime=item.buffered.end(0)-0.5;
                    }
                });
            },1000);
        }
    </script>

{{--    video player視窗布局事件--}}
    <script>
        // 分割畫面無縫切換
        function rebuid_layout() {
            // 清除buffer追趕計數器
            clearInterval(CurrentTime2Buffered);
            // 重新建立現有player清單
            video_players=[];
            Array.from(document.getElementsByTagName('video'))
                .forEach(function (item) {
                    video_players.push(item.getAttribute('id'));
                });
            // 取得現有撥放清單
            let old_player_list = [];
            onplay_stream.forEach(
                function (item,index) {
                    old_player_list.push([groups[index], cams[index],onplay_stream[index]]);
                }
            );
            // 重新建立撥放器
            old_player_list.forEach(
                function (item) {
                    console.log(item);
                    add_stream(item[0],item[1],item[2]);
                    add_stream(item[0],item[1],item[2]);
                }
            );
            // 重新啟動監聽追趕計數器
            CurrentTime2Buffered=currentTime2bufferedInterval();

        }
        // 1*1 撥放版面
        function create_player1() {
            let grid=document.getElementById("player-grid");
            grid.innerHTML="";
            let div=document.createElement("div");
            div.setAttribute("style","background-color:black;width:100%;height:initial;padding-left:0px;padding-right:0px");
            let player=document.createElement("video");
            player.setAttribute("id","videoElement");
            player.setAttribute("class","max-grid");
            player.setAttribute("muted","true");
            player.setAttribute("style","border-style:none");
            div.appendChild(player);
            grid.appendChild(div);

            // 重建撥放器
            rebuid_layout();
        }
        // 2*2 撥放版面
        function create_player4() {
            let grid = document.getElementById("player-grid");
            grid.innerHTML = "";
            for($r=0;$r<2;$r++){
                let row=document.createElement("div");
                row.setAttribute("class","row");
                row.setAttribute("style","height:36vh");
                for($c=0;$c<2;$c++){
                    let col=document.createElement("div");
                    col.setAttribute("class","col-sm-6 max-4");
                    let player=document.createElement("video");
                    player.setAttribute("id","videoElement"+$r+$c);
                    player.setAttribute("class","max-grid-4");
                    player.setAttribute("muted","true");
                    col.appendChild(player);
                    row.appendChild(col);
                }
                grid.appendChild(row);
            }
            // 重建撥放器
            rebuid_layout();
        }
        // 3*3 撥放版面
        function create_player9() {
            let grid = document.getElementById("player-grid");
            grid.innerHTML = "";
            for($r=0;$r<3;$r++){
                let row=document.createElement("div");
                row.setAttribute("class","row");
                row.setAttribute("style","height:33%");
                for($c=0;$c<3;$c++){
                    let col=document.createElement("div");
                    col.setAttribute("class","col-sm-4 max-9");
                    let player=document.createElement("video");
                    player.setAttribute("id","videoElement"+$r+$c);
                    player.setAttribute("class","max-grid-9");
                    player.setAttribute("muted","true");
                    col.appendChild(player);
                    row.appendChild(col);
                }
                grid.appendChild(row);
            }
            // 重建撥放器
            rebuid_layout();
        }
        // 4*4 撥放版面
        function create_player16() {
            let grid = document.getElementById("player-grid");
            grid.innerHTML = "";
            for($r=0;$r<4;$r++){
                let row=document.createElement("div");
                row.setAttribute("class","row");
                row.setAttribute("style","height:25%");
                for($c=0;$c<4;$c++){
                    let col=document.createElement("div");
                    col.setAttribute("class","col-sm-3 max-16");
                    let player=document.createElement("video");
                    player.setAttribute("id","videoElement"+$r+$c);
                    player.setAttribute("class","max-grid-16");
                    player.setAttribute("muted","true");
                    col.appendChild(player);
                    row.appendChild(col);
                }
                grid.appendChild(row);
            }
            // 重建撥放器
            rebuid_layout();
        }

    </script>
@endsection
