@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--selectize--}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />
    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>

{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .table-condensed{
            font-size: 15px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <a href="{{ Route("device") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">設備管理</h2></a>
                {{--@include('layout.menubtn')--}}
                <div style="height: 5vh"></div>
                <h2 class="text-white"style="font-size: 20pt;text-align: center">現有設備</h2>
                {{--空白分隔列--}}
                <div class="row" style="height: 5vh">
                </div>
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 60vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <!-- <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;" onclick="javascript:location.href='{{ route('show_camera',["id"=>$camera['id']]) }}'">
                                                        {{ $camera["name"] }}
                                                    </button> -->
                                                    {{ $camera["name"] }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <p></p>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12">
                        <label style="text-align:left;font-size:16px;color: #ffffff">使用者：{{$msg}}&nbsp; </label>
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row" style="background: white">
                    <div class="col-3 text-center"><a href="{{ Route("person") }}" style="text-decoration:none;color: #1b1e21;">人臉庫管理</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("attendance") }}" style="text-decoration:none;color: #1b1e21;">出勤管理</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("comparison") }}" style="text-decoration:none;color: #28a745;">比對紀錄</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("insert_user") }}" style="text-decoration:none;color: #1b1e21;">使用者管理</a></div>
                    <div class="col-3 text-center"><a href="{{ Route("Group_index") }}" style="text-decoration:none;color: #1b1e21;">人員群組管理</a></div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    {{--datetime 時間選擇--}}
                    <form class="row" method="post" action="{{ Route('comparison') }}">
                        {{ csrf_field() }}
                        {{--隱藏欄位 cam id--}}
                        <input type="hidden" name="id" id="input_camid">
                        <div class="col-sm-3">
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04" onchange="select()">
                                    <option value="default">請選擇類別</option>
                                    <option value="all">全部</option>
                                    <option value="black">黑名單</option>
                                    <option value="unknow">訪客</option>
                                    <option value="overtemp">溫度異常</option>
                                </select>
                                <input id="search_text" name="search_text" type="text" class="form-control" placeholder="" min="0" step="0.1"value="{{ old("search_text") }}">
                                <input id="search_number" style="display: none" name="search_number" type="number" class="form-control" placeholder="" min="0" step="0.1"value="{{ old("search_text") }}">
                            </div>
                        </div>
                        <script>
                            function select()
                            {
                                var select =document.getElementById("inputGroupSelect04").value;
                                var n =document.getElementById("search_number");
                                var t =document.getElementById("search_text");
                                if(select=="overtemp")
                                {
                                    n.style.display="block";
                                    t.style.display="none"
                                    document.getElementById("search_number").value = 37.5;
                                }
                                else
                                {
                                    t.style.display="block";
                                    n.style.display="none";
                                    document.getElementById("search_text").value = "";
                                    document.getElementById("search_number").value = "";
                                }
                            }
                        </script>

                        {{--datetime 起始時間選擇--}}
                        <div class="col-sm-4">
                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">起始時間</div>
                                </div>
                                <input style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        {{--datetime 結束時間選擇--}}
                        <div class="col-sm-4">
                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">結束時間</div>
                                </div>
                                <input style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-1">
                            <button type="submit" class="btn btn-dark mb-2">查詢</button>
                        </div>
                    </form>
                    <div style="height: 2vh"></div>
                    {{--現有人員資訊區--}}
                    <table class="table table-striped table-bordered table-hover fixed-height table-condensed" id="tableL01"></table>
                    {{--                    <div style="height: 70vh">--}}
{{--                        <div class="table-responsive">--}}
{{--                            <table class="table table-bordered" style="table-layout: fixed" id="table" data-toggle="table" data-height="javascript:echo Math.max(document.documentElement.clientHeight, window.innerHeight || 0)">--}}
{{--                                <thead>--}}
{{--                                <tr>--}}
{{--                                    <th scope="col"><div><input type="checkbox" class="checkbox"></div></th>--}}
{{--                                    <th scope="col">日期</th>--}}
{{--                                    <th scope="col">姓名</th>--}}
{{--                                    <th scope="col">上班</th>--}}
{{--                                    <th scope="col">下班</th>--}}
{{--                                </tr>--}}
{{--                                </thead>--}}
{{--                                <tbody>--}}
{{--                                @for($i=0;$i<0;$i++)--}}
{{--                                    <tr>--}}
{{--                                        <th scope="row"><input type="checkbox" class="checkbox"></th>--}}
{{--                                        <td>1</td>--}}
{{--                                        <td>Allen</td>--}}
{{--                                        <td><img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg"></td>--}}
{{--                                        <td>VIP</td>--}}
{{--                                    </tr>--}}
{{--                                @endfor--}}
{{--                                @if(isset($attendance))--}}
{{--                                    @foreach(array_keys($attendance) as $id)--}}
{{--                                        @foreach(array_keys($attendance[$id]) as $day)--}}
{{--                                            <tr>--}}
{{--                                                <td>{{ $day }}</td>--}}
{{--                                                <td>{{ $id }}</td>--}}
{{--                                                <td>{{ $attendance[$id][$day]["stime"] }}</td>--}}
{{--                                                <td>{{ $attendance[$id][$day]["etime"] }}</td>--}}
{{--                                            </tr>--}}
{{--                                        @endforeach--}}
{{--                                    @endforeach--}}
{{--                                @endif--}}
{{--                                </tbody>--}}
{{--                            </table>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                </div>
            </div>
        </div>

    </div>

    {{-- 新增人臉彈出視窗 --}}
    <div class="modal fade" id="InsertMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增人員</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("post_insert_face_no_image") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                <div class="modal-body row">
                    <div class="col-sm-8">
                        <div class="form-group row">
                            <label for="inputName" class="col-sm-3 col-form-label">姓名</label>
                            <div class="col-sm-9">
                                @if(count($person_noimage)!=0)
                                    <div>
                                        <select name="face_name" placeholder="請選擇姓名" id="example" onchange="select_person()">
                                            <option value=""></option>
                                        @foreach($person_noimage as $person)
                                                <option value="{{$person["id"]}}/{{$person["sex"]}}/{{$person["name"]}}">{{$person["name"]}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <input type="hidden" name="personname" id="personname" >
                                    {{--<input type="text" name="personname" id="personname" value="{{$person["sex"]}}">--}}

                                @else
                                    <input type="text" class="form-control" id="inputName" name="face_name" placeholder="請輸入姓名">
                                @endif
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="inputID" class="col-sm-3 col-form-label">ID</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="inputID" name="face_id" placeholder="請輸入使用者編號">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label" for="selectSex" >性別</label>
                            <div class="col-sm-9">
                                <select class="custom-select form-control" id="selectSex" name="face_sex">
                                    <option disabled selected>請選擇性別</option>
                                    <option value="1">男</option>
                                    <option value="2">女</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="inputLineToken" class="col-sm-3 col-form-label">LineToken</label>
                            <div class="col-sm-9">
                                <input type="password" class="form-control" id="inputLineToken" name="face_line_token" placeholder="請輸入綁定LineToken">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4 form-group">
                        <img id="face-img-preview" class="img-fluid" src="{{ asset("/boss.jpg") }}" >
                        <input id="face-img-input" class="form-control" name="face_img" readonly />
                    </div>
                    <div class="col-sm-2 form-group">
                        有效期間
                    </div>
                    <div class="form-group input-group col-sm-10">
                        <select class="custom-select" id="selectExpiryDate" name="face_expiry_date" onchange="selectExpiryDateonchange(this.id)" required>
                            <option selected disabled>請選擇有效期間</option>
                            <option value="1">永久有效</option>
                            <option value="2">期間有效</option>
                        </select>
                        <div class="input-group-append">
                    {{--開始時間--}}
                            <div style="background: white"  class="input-group date" id="datetimepicker3" data-target-input="nearest">
                                <input id='start_time' style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                            <label class="input-group-text">~</label>
                    {{--結束時間--}}
                            <div style="background: white"  class="input-group date" id="datetimepicker4" data-target-input="nearest">
                                <input id='end_time' style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" required/>
                                <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary">提交</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <script language="JavaScript">
        function select_person() {
            var select =document.getElementById("example").value;
            var a=select.split("/");
        if(a.length > 1){
            document.getElementById("inputID").value=a[0];
            document.getElementById("selectSex").value=a[1];
            document.getElementById("personname").value=$("#example").text();
            //document.getElementById("example").value=a[2];
        } else {
            document.getElementById("inputID").value="";
            document.getElementById("selectSex").value="";
            document.getElementById("personname").value=$("#example").text();
            }
        }
    </script>
    {{--selectize--}}
    <script>
        $(document).ready(function () {
            $('#example').selectize({
                create:true,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
        <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif

    {{--刪除按鈕事件處理--}}
    <script>
        function drop_camera() {
            var id=document.getElementById("cameraid").value;
            if(confirm("是否刪除"+id)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("drop_camera") }}");
                var idField = document.createElement("input");
                idField.setAttribute("type", "hidden");
                idField.setAttribute("name", "id");
                idField.setAttribute("value",id);
                form.appendChild(idField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
    </script>
    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start_time',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end_time',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
{{--    boostrap tabel js--}}
       <script>
           @php
                if (isset($rowdata)){
                    echo "var jdata=".json_encode($rowdata).';';
                }else{
                    echo "var jdata=[];";
                }
           @endphp
       </script>
    <script>
        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷燬表格
        var tableColumns = [
            {field: 'day', title: '日期', sortable: true},
            {field: 'time', title: '時間', sortable: true},
            {field: 'db_img', title: '在庫圖片', sortable: false},
            {field: 'target_img', title: '抓拍圖片', sortable: false},
            {field: 'name', title: '姓名', sortable: true},
            {field: 'group', title: '名單類別', sortable: true},
            {field: 'temp', title: '溫度', sortable: true},
            {field: 'location', title: '地點', sortable: true},
            {field: 'remarks', title: '備註', sortable: false},
            {field: 'unknown', title: 'Create', sortable: false},
        ];
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            pageSize: 5, //每頁3條
            pageNumber: 1,  //第1頁
            pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
        $table = $('#tableL01');
        function insert_user(id) {
            var image = document.getElementById("face-img-preview");
            image.src = "{{ $imgserver }}"+"/punch/card/image/%s".replace(/%s/g, () => id);
            var label = document.getElementById("face-img-input");
            label.value = id;
        }
    </script>

    <script>
        function select_cam() {
            document.getElementById("input_camid");
        }
    </script>

    <script>
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
        // 有效期間選擇響應
        function selectExpiryDateonchange(x) {
            let elemet_selted=document.getElementById(x).value;
            // console.log(elemet_selted);
            switch (elemet_selted) {
                case '1':
                    $("#start_time").removeAttr("required");
                    $("#end_time").removeAttr("required");
                    break;
                case '2':
                    $("#start_time").attr("required","true");
                    $("#end_time").attr("required","true");
                    break;
                default:
                    break;
            }
        }
    </script>
    {{--    人臉圖片預覽--}}
    <!-- <script>
        var inputface=document.getElementById("face-img-input");
        var previewface=document.getElementById("face-img-preview");
        inputface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    previewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
    </script> -->
@endsection
