@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        .seeline{
            border: #000000 1px solid;
        }
        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')
{{--<title>人員群組</title>--}}
    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <a href="{{ Route("device") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">設備管理</h2></a>
                {{--@include('layout.menubtn')--}}
                <div style="height: 5vh"></div>
                <h2 class="text-white"style="font-size: 20pt;text-align: center">現有設備</h2>
{{--                <button><a href="{{ Route("index_attendance") }}" >出勤考核</a></button>--}}
                {{--空白分隔列--}}
                <div class="row" style="height: 5vh">
                </div>
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 60vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <!-- <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;" onclick="javascript:location.href='{{ route('show_camera',["id"=>$camera['id']]) }}'">
                                                    </button> -->
                                                    {{ $camera["name"] }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <p></p>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12">
                        <label style="text-align:left;font-size:16px;color: #ffffff">使用者：{{$msg}}&nbsp; </label>
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row" style="background: white">
                    <div class="col-3 text-center"><a href="{{ Route("person") }}" style="text-decoration:none;color: #1b1e21;">人臉庫管理</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("attendance") }}" style="text-decoration:none;color: #1b1e21;">出勤管理</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("comparison") }}" style="text-decoration:none;color: #1b1e21;">比對紀錄</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("insert_user") }}" style="text-decoration:none;color: #1b1e21;">使用者管理</a></div>
                    <div class="col-3 text-center"><a href="{{ Route("Group_index") }}" style="text-decoration:none;color: #28a745;">人員群組管理</a></div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列/查詢人員群組--}}
                    <div class="row " style="height: 10vh;align-items: center">
                        <div class="col-5" style="padding-right: 0px;">
                            <form method="POST" action="{{ route('search_Group') }}">
                            {{ csrf_field() }}
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04">
                                    <option value="default" selected>請選擇類別</option>
                                    <option value="2">群組名稱</option>
                                </select>
                                <input name="search_text" type="text" class="form-control" placeholder="預搜尋內容" >
                                <div class="input-group-append">
                                    <button class="btn btn-dark" type="submit">搜尋</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        <p></p>
                        <div class="col-3" style="padding-right: 0px;">
                            <form method="POST" action="{{ route('insert_Group') }}">
                                {{ csrf_field() }}
                                <div class="input-group">
                                    <input name="group_text" type="text" class="form-control"  style="width: 70%" placeholder="自訂群組名稱" >
                                    <div class="input-group-append">
                                        <button class="btn btn-dark" type="submit">新增</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-4" style="text-align: right">
                            <button class="btn btn-dark" type="button" onclick="search_group()">查詢群組人員</button>
                            <button class="btn btn-dark" type="button" onclick="delete_Group()">刪除群組</button>
                        </div>
                    </div>
                        {{--
                        <div class="col-2" style="text-align: right">
                                <button class="btn btn-dark" type="button" onclick="search_group()">查詢群組人員</button>
                        </div>
                        <div class="col-2" style="text-align: right">
                                <button class="btn btn-dark" type="button" onclick="delete_Group()">刪除群組</button>
                        </div>--}}

                        {{--<div class="col-6 float-right">
                          {{--<button class="btn btn-outline-dark float-right" onclick="delete_face()">刪除全部</button>

                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertMemberModalCenter">新增群組</button>
                        </div>--}}
                         {{--操作列/新增人員群組
                         <form method="post" action="{{ route('decive_search') }}">
                         <div class="input-group">
                             <input name="search_text" type="text" class="form-control" placeholder="輸入新增群組名稱內容" >
                             <div class="input-group-append">
                                 <button class="btn btn-dark" type="submit">新增群組</button>
                             </div>
                         </div>
                     </form>--}}
                    {{-- 修改彈出視窗 --}}
                    <div class="modal fade" id="ModifyMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">修改群組資料</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{ route("modify_Group") }}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="modal-body row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="inputID" class="col-sm-3 col-form-label" style="text-align: right">人員群組編號</label>
                                                <div class="col-sm-9" style="text-align: left">
                                                    <input type="text" class="form-control" id="modifyID" name="modify_id" readonly>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="inputName" class="col-sm-3 col-form-label" style="text-align: right">群組名稱</label>
                                                <div class="col-sm-9"  style="text-align: left">
                                                    <input type="text" class="form-control" id="modifyName" name="modify_name" placeholder="請輸入群組名稱">
                                                </div>
                                            </div>
                                    </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                                        <button type="submit" class="btn btn-primary">提交</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                 <div class="col-12 row">
                 </div>
                    {{--現有人員資訊區--}}
                    <table class="table table-striped table-bordered table-hover fixed-height" id="tableL01"></table>
                </div>
            </div>
        </div>
    </div>

    {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
    @endif

    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
        <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif
<script>
    // 載入人員資料
    @php
        if(isset($rowdata)){
            echo "var jdata=".json_encode($rowdata).";";
        }else{
            echo "var jadata=[];";
        }
    @endphp
    $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷毀表格
    var tableColumns = [
        {field: 'state', checkbox: true,},
        {field: 'name', title: '群組名稱', sortable: true},
        {field: 'detail', title: '群組修改', sortable: false},
    ];
    $('#tableL01').bootstrapTable({//表格初始化
        locale:"zh-TW",// 地區語系轉換
        columns: tableColumns,  //表頭
        data:jdata, //通過ajax返回的資料
        width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
        height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
        method: 'get',
        // pageSize: 5, //每頁3條
        // pageNumber: 1,  //第1頁
        // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
        cache: false,   //不快取
        striped: true,
        pagination: false,
        sidePagination: 'client',
        search: false,
        showRefresh: false,
        showExport: false,
        showFooter: false,
        exportTypes: ['csv', 'txt', 'xml','excel'],
        clickToSelect: true,
        sortName:'day', // 預設排序
    });
    // 修改人員資料處理
    function person_modify(obj) {
        let jdata_index = parseInt(obj.closest('tr').getAttribute("data-index"));
        document.getElementById("modifyID").value = jdata[jdata_index].id;
        document.getElementById("modifyName").value = jdata[jdata_index].name;
    }
    // html string to element
    function htmlToElement(html) {
        var template = document.createElement('template');
        html = html.trim(); // Never return a text node of whitespace as the result
        template.innerHTML = html;
        return template.content.firstChild;
    }
</script>

    <script>
        {{--    取得已選取目標--}}
        function insertIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.id
            })
        }
        function insertNameSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.name
            })
        }
        {{--刪除群組--}}
        function delete_Group() {
            let idselections=insertIdSelections();
            let nameselections=insertNameSelections();
            if(confirm("是否刪除"+nameselections)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("delete_Group") }}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value",idselections);
                form.appendChild(idselectionsField);
                var nameselectionsField = document.createElement("input");
                nameselectionsField.setAttribute("type", "hidden");
                nameselectionsField.setAttribute("name", "selectedName");
                nameselectionsField.setAttribute("value",nameselections);
                form.appendChild(nameselectionsField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
        {{--搜尋群組--}}
        function search_group() {
            let idselections = insertIdSelections();
            let nameselections=insertNameSelections();
            if (confirm("是否查看" + nameselections)) {
                var form = document.createElement("form");
                form.setAttribute("method", "post");
                form.setAttribute("action", "{{ Route("search_personGroup") }}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value", idselections);
                form.appendChild(idselectionsField);
                var csrfField = document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
        {{--新增群組--}}
        function post_insert_personG() {
            let gidselectoins=document.getElementById("selectpersonGid").value;
            let idselections=insertIdSelections();
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("insert_personG") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "selectedgId");
            idselectionsField.setAttribute("value",gidselectoins);
            form.appendChild(idselectionsField);
            var gidselectionsField = document.createElement("input");
            gidselectionsField.setAttribute("type", "hidden");
            gidselectionsField.setAttribute("name", "selectedpId");
            gidselectionsField.setAttribute("value",idselections);
            form.appendChild(gidselectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }

    </script>
@endsection
