@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 60vh !important;
        }
        .table-condensed{
            font-size: 15px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <a href="{{ Route("device") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">設備管理</h2></a>
                {{--@include('layout.menubtn')--}}
                <div style="height: 5vh"></div>
                <h2 class="text-white"style="font-size: 20pt;text-align: center">現有設備</h2>
                {{--空白分隔列--}}
                <div class="row" style="height: 5vh">
                </div>
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 60vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <!-- <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;" onclick="javascript:location.href='{{ route('show_camera',["id"=>$camera['id']]) }}'">
                                                        {{ $camera["name"] }}
                                                    </button> -->
                                                    {{ $camera["name"] }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12">
                        <label style="text-align:left;font-size:16px;color: #ffffff">使用者：{{$msg}}&nbsp; </label>
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row" style="background: white">
                    <div class="col-3 text-center"><a href="{{ Route("person") }}" style="text-decoration:none;color: #1b1e21;">人臉庫管理</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("attendance") }}" style="text-decoration:none;color: #28a745;">出勤管理</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("comparison") }}" style="text-decoration:none;color: #1b1e21;">比對紀錄</a></div>
                    <div class="col-2 text-center"><a href="{{ Route("insert_user") }}" style="text-decoration:none;color: #1b1e21;">使用者管理</a></div>
                    <div class="col-3 text-center"><a href="{{ Route("Group_index") }}" style="text-decoration:none;color: #1b1e21;">人員群組管理</a></div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <form class="row" method="post" action="{{ Route('attendance') }}" style="height: 20vh">
                        {{ csrf_field() }}
                        {{--隱藏欄位 cam id--}}
                        <input type="hidden" name="id" id="input_camid">
                        <div class="col-sm-4">
                            <div class="input-group date" id="datetimepicker4" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">上班時間</div>
                                </div>
                                <input id='time_in' style="text-align: center" name="time_in" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" required value="{{ $export_arg['In'] }}"/>
                                <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="input-group date" id="datetimepicker5" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">下班時間</div>
                                </div>
                                <input id='time_out' style="text-align: center" name="time_out" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker5" required value="{{ $export_arg['Out'] }}" />
                                <div class="input-group-append" data-target="#datetimepicker5" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">午休分鐘</div>
                                </div>
                                <input id='time_break' style="text-align: center" name="time_break" type="number" min="0" class="form-control datetimepicker-input" data-target="#datetimepicker6" required value="{{ $export_arg['LunchBreak'] }}" onchange="input_value_binding('time_break','export_time_break')"/>
                            </div>
                        </div>
                        <div class="col-sm-1">
                            <button name="export" type="button" class="btn btn-dark mb-2" onclick="export_day()">匯出</button>
                        </div>
                        {{--datetime 起始時間選擇--}}
                        <div class="col-sm-4">
                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">起始時間</div>
                                </div>
                                <input id='start_time' style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        {{--datetime 結束時間選擇--}}
                        <div class="col-sm-4">
                            <div  class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">結束時間</div>
                                </div>
                                <input id='end_time' style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04">
                                    <option value="default" selected>請選擇類別</option>
                                    <option value="all">全部</option>
                                    <option value="late">遲到</option>
                                    <option value="early">早退</option>
                                    <option value="over">加班</option>
                                    <option value="noarrived">未出席</option>
                                </select>
                                <input name="search_text" type="text" class="form-control" placeholder="" value="{{ old("search_text") }}">
                            </div>
                        </div>
                        <div class="col-sm-1">
                            <button name="select" type="submit" class="btn btn-dark mb-2">查詢</button>
                        </div>
                    </form>
                    <script>
                        function export_day()
                        {
                            document.forms[0].action="{{ Route('attendance_download_day') }}";
                            document.forms[0].submit();
                            document.forms[0].action="{{ Route('attendance') }}";
                        }
                    </script>
                    {{--現有人員資訊區--}}
                    <table class="table table-striped table-bordered table-hover fixed-height table-condensed" id="tableL01"></table>
                    {{-- 匯出按鈕 --}}
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                        <div class="col-sm-4"></div>
                        <div class="col-sm-4"></div>
                        <div class="col-sm-4">
                            <form class="row" id="form_attendance_download" method="POST" action="{{ Route("attendance_download") }}">
                                {{ csrf_field() }}
                                {{-- 隱藏欄位 --}}
                                <input type="hidden" name="export_time_in" id="export_time_in" value="{{ $export_arg['In'] }}">
                                <input type="hidden" name="export_time_out" id="export_time_out" value="{{ $export_arg['Out'] }}">
                                <input type="hidden" name="export_time_break" id="export_time_break" value="{{ $export_arg['LunchBreak'] }}">
                                <div class="input-group date" id="datetimepicker3" data-target-input="nearest">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">匯出月份</div>
                                    </div>
                                    <input id='export_date' style="text-align: center" name="export_date" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                    <div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                    <div class="input-group-append">
                                        <button class="btn btn-dark" type="submit">匯出</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
        <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif

    {{--刪除按鈕事件處理--}}
    <script>
        function drop_camera() {
            var id=document.getElementById("cameraid").value;
            if(confirm("是否刪除"+id)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("drop_camera") }}");
                var idField = document.createElement("input");
                idField.setAttribute("type", "hidden");
                idField.setAttribute("name", "id");
                idField.setAttribute("value",id);
                form.appendChild(idField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not enRD
            }
        }
    </script>
    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start_time',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('end_time',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- datetimepicker3 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker3').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- datetimepicker4 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker4').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'HH:mm',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- datetimepicker5 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker5').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'HH:mm',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                // maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    <!-- datetimepicker6 物件  -->
    <!-- <script type="text/javascript">
        $(function () {
            $('#datetimepicker3').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script> -->
{{--    boostrap tabel js--}}
       <script>
           @php
                if (isset($rowdata)){
                    echo "var jdata=".json_encode($rowdata).';';
                }else{
                    echo "var jdata=[];";
                }
           @endphp
       </script>
    <script>
        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷燬表格
        var tableColumns = [
            {field: 'day', title: '日期', sortable: true},
            {field: 'img', title: '人臉庫圖片', sortable: false},
            {field: 'name', title: '姓名', sortable: true},
            {field: 'id', title: '編號', sortable: true},
            {field: 'stime', title: '上班', sortable: true},
            {field: 'etime', title: '下班', sortable: true},
            {field: 'late', title: '遲到', sortable: true},
            {field: 'early', title: '早退', sortable: true},
            {field: 'over', title: '加班', sortable: true},
            {field: 'remarks', title: '備註', sortable: false},
        ];
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            pageSize: 5, //每頁3條
            pageNumber: 1,  //第1頁
            pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
    </script>
<!--
    <script>
        var export_button = document.getElementById("export_button")
        var date1 = document.getElementById("start_time")
        var date2 = document.getElementById("end_time")
        export_button.onclick = function() {
            // var form = document.createElement("form")
            // form.setAttribute('method', "POST")
            // form.setAttribute('action', "http://192.168.5.185:8001/punch/card/record")
            // var body = document.createElement("input");
            // body.setAttribute('start', date1.value + " 00:00:00")
            // body.setAttribute('end', date2.value + " 23:59:59")
            // form.appendChild(body)
            // form.submit()
            alert("OK")
            fetch("http://192.168.5.185:8001/punch/card/record", {
                method: 'POST',
                body: encodeURI(JSON.stringify({
                    start: date1.value + " 00:00:00",
                    end: date2.value + " 23:59:59"
                })),
                headers: {
                    'Content-Type': "applicatipn/json"
                }
            })
            .then(function (res) {
                alert("OK")
            })
        }
    </script> -->

    <script>
        function select_cam() {
            document.getElementById("input_camid");
        }
    </script>

{{--    匯出按鈕--}}
    <script>
        function attendance_download(){
            let form = document.getElementById("form_attendance_download");
            document.getElementById("export_time_break").value=document.getElementById("time_break").value;
            document.getElementById("export_time_in").value=document.getElementById("time_in").value;
            document.getElementById("export_time_out").value=document.getElementById("time_out").value;
            let formData = new FormData(form);
            $.ajax({
                url:"{{ Route("attendance_download") }}",
                type : "POST",
                data : formData,
                contentType: false,
                cache: false,
                processData: false,
                success : function(data)
                {
                    console.log(data);
                },error: function(data)
                {
                    console.log('無法送出');
                }
            })
        }
        // input雙向綁定
        function input_value_binding(a,b) {
            document.getElementById(b).value=document.getElementById(a).value;
        }
        // datetimpicker value and hidden input 雙向綁定
        $("#datetimepicker4").on("change.datetimepicker", function (e) {
            if (e.oldDate !== e.date) {
                document.getElementById("export_time_in").value=document.getElementById("time_in").value;
            }
        })
        $("#datetimepicker5").on("change.datetimepicker", function (e) {
            if (e.oldDate !== e.date) {
                document.getElementById("export_time_out").value=document.getElementById("time_out").value;
            }
        })
    </script>
    <script>
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
    </script>
@endsection
