<h2>Filterable Table for Docker API</h2>
<p>Type something in the input field to search the table for first names, last names or emails:</p>  
<input class="form-control" id="myInput" type="text" placeholder="Search..">
<br>
<!-- <form method="post" action="{{route('api')}}"> -->
<table class="table table-bordered" style="color:#fff">
    <thead>
        <tr>
            <th>Container</th>
            <th>State</th>
            <th>Published Ports</th>
            <th>Status</th>
            <th>Created</th>
            <th>P.S</th>
        </tr>
    </thead>
    <tbody id="myTable">
        @foreach($contents as $content)
            <tr>
                  <form method="post" action="{{route('api')}}">
                      <input type = "hidden" name = "_token" value = "<?php echo csrf_token(); ?>">  
                      <td>{{$content['Names'][0]}}</td>
                      <td>{{$content['State']}}</td>
                      @if(empty($content['Ports'][0]['PrivatePort']))
                          <td></td>
                      @else
                          <td>{{$content['Ports'][0]['PrivatePort']}}:{{$content['Ports'][0]['PublicPort']}}</td>
                      @endif
                          <td>{{$content['Status']}}</td>
                      <td>{{date('Y-m-d H:i:s',$content['Created'])}}</td><!--timestamp to date-->
                      <td>
                          <input type = "hidden" name = "id" value = "{{$content['Id']}}">
                          <button type="submit" class="btn btn-Success" name="btn" value="start">啟動</button>
                          <button type="submit" class="btn btn-Danger" name="btn" value="stop">停止</button>
                          <button type="submit" class="btn btn-Primary" name="btn" value="restart">重啟</button>
                      </td>
                </form>
            </tr>
        @endforeach
    </tbody>
</table>
<!-- </form>-->
<ul class="pagination justify-content-center" style="margin:20px 0">
    <li class="page-item"><a class="page-link" href="#">Previous</a></li>
    <li class="page-item"><a class="page-link" href="#">1</a></li>
    <li class="page-item"><a class="page-link" href="#">2</a></li>
    <li class="page-item"><a class="page-link" href="#">3</a></li>
    <li class="page-item"><a class="page-link" href="#">Next</a></li>
</ul>
<p>Note that we start the search in tbody, to prevent filtering the table headers.</p>

<script>
//search bar
$(document).ready(function(){
  $("#myInput").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#myTable tr").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });
});
</script>