@extends('layouts.template')

@section('title', 'Service manage')

@section('navbar_content')
    @include('docker.layouts.navbar_li')
@stop

@section('content')

<h2>Manage all service</h2>
<p>Type something in the input field to search the table for first names, last names or emails:</p>  
<input class="form-control" id="myInput" type="text" placeholder="Search..">
<br>
<!-- <form method="post" action="{{route('api')}}"> -->
<table class="table table-bordered" id= "table-id" style="color:#fff">
    <thead>
        <tr>
            <th>Container</th>
            <th>State</th>
            <th>Published Ports</th>
            <th>Status</th>
            <th>Created</th>
            <th>P.S</th>
        </tr>
    </thead>
    <tbody id="myTable">
        @foreach($contents as $content)
            <tr>
                  <form method="post" action="{{route('api')}}">
                      <input type = "hidden" name = "_token" value = "<?php echo csrf_token(); ?>">  
                      <td>{{$content['Names'][0]}}</td>
                      <td>{{$content['State']}}</td>
                      @if(empty($content['Ports'][0]['PrivatePort']))
                          <td></td>
                      @else
                          <td>{{$content['Ports'][0]['PrivatePort']}}:
                          @if(empty($content['Ports'][0]['PublicPort']))
                          @else
                          {{$content['Ports'][0]['PublicPort']}}
                          @endif
                          </td>
                      @endif
                          <td>{{$content['Status']}}</td>
                      <td>{{date('Y-m-d H:i:s',$content['Created'])}}</td><!--timestamp to date-->
                      <td>
                          <input type = "hidden" name = "id" value = "{{$content['Id']}}">
                          <button type="submit" class="btn btn-Success" name="btn" value="start">啟動</button>
                          <button type="submit" class="btn btn-Danger" name="btn" value="stop">停止</button>
                          <button type="submit" class="btn btn-Primary" name="btn" value="restart">重啟</button>
                      </td>
                </form>
            </tr>
        @endforeach
    </tbody>
</table>
<!-- </form>-->
<div class="container" >
  <div class="form-group">
   	<!--		Show Numbers Of Rows 		-->
  <div class="col-sm-2"><h3>每頁</h3>
    <select class="form-control" name="state" id="maxRows">
        <option value="5000">All</option>
        <option value="5">5</option>
        <option value="10">10</option>
        <option value="15">15</option>
        <option value="20">20</option>
        <option value="50">50</option>
      </select>
      <h3>筆</h3>
      </div>
    
			  	
      <!--		Start Pagination -->
      <div class='pagination-container' style="text-align:right">
      <nav>
      <ul class="pagination page-item" >
      <li data-page="prev">
      <span style="border-top-left-radius: 5px;border-bottom-left-radius: 5px;"> < <span class="sr-only">(current)</span></span>
      </li>

      <li data-page="next" id="prev">
      <span style="border-top-right-radius: 5px;border-bottom-right-radius: 5px;"> > <span class="sr-only">(current)</span></span>
      </li>
      </ul>
      </nav>
      </div> <!--		end Pagination -->
        

    </div>
  </div> <!-- 		End of Container -->
<p>Note that we start the search in tbody, to prevent filtering the table headers.</p>

<script>
//search bar
$(document).ready(function(){
  $("#myInput").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#myTable tr").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });
});
</script>

<script src="{{asset('js/pagination.js')}}"></script>

@stop