from xml.dom import minidom 
import traceback
import cv2
import os
import numpy as np
import argparse

def readXml(xml_path,save_dir,imgs_folder,count):
    try:
        x1=None
        y1=None
        x2=None
        y2=None    
        doc=minidom.parse(xml_path)
        objs=doc.getElementsByTagName("object")
        for obj in objs:
            x1=obj.getElementsByTagName("xmin")[0].firstChild.data
            y1=obj.getElementsByTagName("ymin")[0].firstChild.data
            x2=obj.getElementsByTagName("xmax")[0].firstChild.data
            y2=obj.getElementsByTagName("ymax")[0].firstChild.data        
    #         print(x1,y1,x2,y2)
        p1=None
        p2=None
        p3=None
        p4=None        
        lands=doc.getElementsByTagName("landmark")
        for land in lands:
            p1=land.getElementsByTagName("p1")[0].firstChild.data.split(",")
            p2=land.getElementsByTagName("p2")[0].firstChild.data.split(",")
            p3=land.getElementsByTagName("p3")[0].firstChild.data.split(",")
            p4=land.getElementsByTagName("p4")[0].firstChild.data.split(",")
    except:
#         print("---Annotation data not completed---")
#         print("---Fail_path:",xml_path)        
        return False
        
#     img_path=doc.getElementsByTagName("path")[0].firstChild.data
    img_name=doc.getElementsByTagName("filename")[0].firstChild.data
#     img_name=str(count)
    if (x1==None or y1==None or x2==None or y2==None):
        return False
    if (p1==None or p2==None or p3==None or p4==None):
        return False
    if (len(p1)<2 or len(p2)<2 or len(p3)<2 or len(p4)<2):
        return False
    img_path=os.path.join(imgs_folder,img_name)
    
    img=cv2.imread(img_path)
    
    fielname="{0}-pos_sam-{1}&{2}_{3}&{4}-{5}&{6}_{7}&{8}_{9}&{10}_{11}&{12}.jpg".format(str(count),x1,y1,x2,y2,p1[0],p1[1],p2[0],p2[1],p3[0],p3[1],p4[0],p4[1])
    print(img_path)
    
    if(not os.path.isdir(save_dir)):
        os.mkdir(save_dir)
        print("create new image folder for MTCNN:",save_dir)
    shape=np.shape(img)
    try:
        if shape[0]>0 and shape[1]>0 and shape[2]>0:
            cv2.imwrite(os.path.join(save_dir,fielname),img)
    except Exception as e:
        print(e)
        return False
    return True

        
        
def process():
    d = {}
    count=0
    with open("MTCNN_train_config.txt") as f:
        for line in f:
            (key, val) = line.split(',')[0].split('=')
            print(line.split(',')[0].split('='))
            d[key] = val            
        f.close()
    for root,dirnames,filenames in os.walk(d['xml_path']):
        for filename  in  filenames:
            if filename.endswith(".xml") :
                if (readXml(os.path.join(d['xml_path'],filename),d['save_dir'],d['imgs_folder'],count)):
                    count+=1

    print(d['xml_path'])
    print(d['save_dir'])
    print(d['imgs_folder'])
    return count
            
