import os
import sys


def assemble_imglist(root_path):
    if (not root_path.startswith('/notebooks')):
        path='/notebooks'
    else:    
        path='/'
    for i in root_path.split('/'):
        path=os.path.join(path,i)
        if i == 'data_preprocessing':
            break
    root_path=path    
    sys.path.append(root_path)
    import assemble
    
    for data_set in ["tra","val"]:
        onet_postive_file = root_path+'/anno_store/pos_Onet_%s.txt' %(data_set)
        onet_part_file = root_path+'/anno_store/part_Onet_%s.txt' %(data_set)
        onet_neg_file = root_path+'/anno_store/neg_Onet_%s.txt' %(data_set)
        onet_landmark_file = root_path+'/anno_store/land_Pnet_%s.txt' %(data_set)
        imglist_filename = root_path+'/anno_store/imglist_anno_24.txt'
        imglist_filename_val = root_path+'/anno_store/imglist_anno_24_%s.txt' %(data_set)

        try:
            anno_list = []
            anno_list.append(onet_postive_file)
            anno_list.append(onet_part_file)
            anno_list.append(onet_neg_file)
            anno_list.append(onet_landmark_file)

            if data_set=="tra":
                chose_count = assemble.assemble_data(imglist_filename ,anno_list)
                print("ONet train annotation result file path:%s in total:%d" % (imglist_filename,chose_count)) 
            if data_set=="val":
                chose_count = assemble.assemble_data(imglist_filename_val ,anno_list)
                print("ONet val annotation result file path:%s in total:%d" % (imglist_filename_val,chose_count))
        except Exception as e:
            print(e)
            return False
    return True
    