import cv2
from PIL import Image
import random
import numpy as np

def distort(image):
    def _convert(image, alpha=1, beta=0):
        tmp = image.astype(float) * alpha + beta
        tmp[tmp < 0] = 0
        tmp[tmp > 255] = 255
        image[:] = tmp

    image = image.copy()

    if random.randrange(2):

        #brightness distortion
        if random.randrange(2):
            _convert(image, beta=random.uniform(-32, 32))

        #contrast distortion
        if random.randrange(2):
            _convert(image, alpha=random.uniform(0.5, 1.5))

        image = cv2.cvtColor(image, cv2.COLOR_BGR2HSV)

        #saturation distortion
        if random.randrange(2):
            _convert(image[:, :, 1], alpha=random.uniform(0.5, 1.5))

        #hue distortion
        if random.randrange(2):
            tmp = image[:, :, 0].astype(int) + random.randint(-18, 18)
            tmp %= 180
            image[:, :, 0] = tmp

        image = cv2.cvtColor(image, cv2.COLOR_HSV2BGR)

    else:

        #brightness distortion
        if random.randrange(2):
            _convert(image, beta=random.uniform(-32, 32))

        image = cv2.cvtColor(image, cv2.COLOR_BGR2HSV)

        #saturation distortion
        if random.randrange(2):
            _convert(image[:, :, 1], alpha=random.uniform(0.5, 1.5))

        #hue distortion
        if random.randrange(2):
            tmp = image[:, :, 0].astype(int) + random.randint(-18, 18)
            tmp %= 180
            image[:, :, 0] = tmp

        image = cv2.cvtColor(image, cv2.COLOR_HSV2BGR)

        #contrast distortion
        if random.randrange(2):
            _convert(image, alpha=random.uniform(0.5, 1.5))

    return image

def AffineTrans(img):
    rows, cols,_ = np.shape(img)
    rany1=np.random.randint(-2,3)
    rany2=np.random.randint(0,3)
    ranx=np.random.randint(-5,6)
    
    pts1 = np.float32([[20, 20], [30, 20], [20, 0]])  # 源图像中的三角形顶点坐标
    pts2 = np.float32([[20, 20], [30, 20+rany1], [20+ranx, rany2]])  # 目标图像中的三角形顶点坐标
    M = cv2.getAffineTransform(pts1, pts2)  # 计算出仿射变换矩阵    
    dst = cv2.warpAffine(img, M, (cols, rows),borderMode=cv2.INTER_LINEAR, borderValue=cv2.BORDER_REPLICATE)  # 应用仿射变换
    return dst


## GaussianBlur 隨機變換 img=rand_GaussianBlur(img,3)
def rand_GaussianBlur(img,min_size=3):
    addition = random.choice((8, 10, 12))
    size = min_size + addition
    kernel_size = (size, size)
    img = cv2.GaussianBlur(img, kernel_size, 5)
    return img

def rand_Erasing(img):
    h,w,_=np.shape(img)
    x1=w*random.uniform(0, 1)
    y1=h*random.uniform(0, 1)

    aspect=w*h
    aspect_ratio=0.12

    rand_aspect_ratio=1
    while rand_aspect_ratio>aspect_ratio:
        rand_w=w*0.5*random.uniform(0, 1)
        rand_h=h*0.5*random.uniform(0, 1)
        rand_aspect_ratio = (rand_w*rand_h)/aspect

    if x1+rand_w>w:
         x1-=(x1+rand_w)-w
    if y1+rand_h>h:
         y1-=(y1+rand_h)-h
    x2=x1+rand_w
    y2=y1+rand_h
    x1,y1,x2,y2=int(x1),int(y1),int(x2),int(y2)
#     print((x1,y1,x2,y2),(rand_w,rand_h),rand_aspect_ratio)
    img[y1:y2,x1:x2]=np.random.randint(0,256)
    return img