import os
import sys
root_path=os.path.join(os.getcwd(),'data_preprocessing')
sys.path.append(root_path)
import assemble



def assemble_imglist(root_path):
    if (not root_path.startswith('/notebooks')):
        path='/notebooks'
    else:    
        path='/'
    for i in root_path.split('/'):
        path=os.path.join(path,i)
        if i == 'data_preprocessing':
            break
    root_path=path    
    sys.path.append(root_path)
    import assemble
    
    for data_set in ["tra","val"]:
        pnet_postive_file = root_path+'/anno_store/pos_Pnet_%s.txt' %(data_set)
        pnet_part_file = root_path+'/anno_store/part_Pnet_%s.txt' %(data_set)
        pnet_neg_file = root_path+'/anno_store/neg_Pnet_%s.txt' %(data_set)
        pnet_landmark_file = root_path+'/anno_store/land_Pnet_%s.txt' %(data_set)
        imglist_filename = root_path+'/anno_store/imglist_anno_12.txt'
        imglist_filename_val = root_path+'/anno_store/imglist_anno_12_%s.txt' %(data_set)

        try:
            anno_list = []
            anno_list.append(pnet_postive_file)
            anno_list.append(pnet_part_file)
            anno_list.append(pnet_neg_file)
            anno_list.append(pnet_landmark_file)
            if data_set=="tra":
                chose_count = assemble.assemble_data(imglist_filename ,anno_list)
                print("PNet train annotation result file path:%s in total:%d" % (imglist_filename,chose_count))
            if data_set=="val":
                chose_count = assemble.assemble_data(imglist_filename_val ,anno_list)
                print("PNet val annotation result file path:%s in total:%d" % (imglist_filename_val,chose_count))
        except Exception as e:
            raise(e)
            return False
    return True