from imutils import paths
import numpy as np
import shutil
import os
import args
import random

def split_data():
    save_dir_train = args.dir_train
    save_dir_val = args.dir_val
    
    if not os.path.exists(save_dir_train):
        os.makedirs(save_dir_train)
    else:
        shutil.rmtree(save_dir_train)        
        os.makedirs(save_dir_train)
                
    if not os.path.exists(save_dir_val):
        os.makedirs(save_dir_val)
    else:
        shutil.rmtree(save_dir_val)        
        os.makedirs(save_dir_val)

    img_paths = []
    img_paths += [el for el in paths.list_images(args.image)]
    random.shuffle(img_paths)
    print(args.image)
    print('image data processing is kicked off...')
    print("%d images in total" % len(img_paths))

    idx = 0
    idx_train = 0
    idx_val = 0
    for i in range(len(img_paths)):
        filename = img_paths[i]  
        basename = os.path.basename(filename)
        
        idx += 1 
    
        if idx % 100 == 0:
            print("%d images done" % idx)
    
        if idx % 5 == 0:
            save = save_dir_val+'/'+basename
            shutil.move(filename,save)
            idx_val += 1
        else:
            save = save_dir_train+'/'+basename
            shutil.move(filename,save)            
            idx_train += 1
        
    print('image data processing done, write %d training images, %d val images' % (idx_train, idx_val))
    return True