@extends('layouts.default')
@section('header')
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{asset('css/templatemo-style.css')}}">
    {{--引入 jquery 相關套件--}}
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
@endsection
@section('content')
    <div class="container-fluid">
        <div class="tm-bg-light tm-block-taller "style="padding:20px;margin-bottom: 100px">
            <h2 style="font-size: x-large" class="tm-block-title">使用者管理介面</h2>
            <ul class="nav nav-tabs">
                <li class="active"><a data-toggle="tab" href="#home" id="show_account"><span class="glyphicon glyphicon-user"></span>帳號管理</a></li>
                <li><a data-toggle="tab" href="#Edit" id="edit_account" style="display: none"><span class="glyphicon glyphicon-pencil"></span>編輯帳號</a></li>
                <li><a data-toggle="tab" href="#Create" id="create_account"><span class="glyphicon glyphicon-plus"></span>新增帳號</a></li>
            </ul>

            <div class="tab-content">
                <div id="home" class="tab-pane fade in active" style="padding: 20px 20px 20px 20px; background-color: white">
                    <table class="table tm-table-small">
                        <thead>
                        <tr>
                            <th scope="col" style="text-align: center">姓名</th>
                            <th scope="col" style="text-align: center">權限等級</th>
                            <th scope="col" style="text-align: center">狀態</th>
                            <th scope="col" style="text-align: center">群組ID</th>
                            <th scope="col" style="text-align: center">編輯區</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($Users as $user)
                            <form method="post" id="send_S"  onsubmit="return false" style="display: inline-block">
                                @csrf
                                <tr>
                                    <td style="vertical-align: middle;text-align: center" id="id">{{$user -> name}}</td>
                                    <td style="vertical-align: middle;text-align: center" id="Auth_level">{{$user -> Auth_level}}</td>
                                    <td style="vertical-align: middle;text-align: center" id="Status">
                                        <label style="background-color: #2a9055;color: white;border-radius: 45px;padding: 3px;font-family: 'Microsoft JhengHei UI';">{{$user -> Status}}</label>
                                    </td>
                                    <td style="vertical-align: middle;text-align: center" id="Group_ID">{{$user -> Group_ID}}</td>
                                    <td style="vertical-align: middle;text-align: center">
                                        <input type="hidden" value="{{$user -> name}}" name="name">
                                        <input class="btn btn-primary4" type="submit"  value="" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;" id="btn_edit" name="{{$user->name}}">

                            </form>
                            <form method="post" id="send_D"  onsubmit="return false" style="display: inline-block">
                                @csrf
                                        <input type="hidden" value="test2" name="name">
                                        <input class="btn btn-primary3" type="submit"  value="" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;" id="btn_delete">
                                    </td>
                                </tr>
                            </form>
                        @endforeach
                        </tbody>
                    </table>
{{--                    <form method="post" id="send_S"  onsubmit="return false">--}}
{{--                        @csrf--}}
{{--                        --}}
{{--                    </form>--}}
                </div>
                <div id="Edit" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                    <form method="post" id="send_U" onsubmit="return false">
                        @csrf
                        <table class="table tm-table-small" border="1">
                            <thead>
                            <th scope="col">資料欄位</th>
                            <th scope="col"></th>
                            </thead>
                            <tbody>
                            <tr>
                                <td width=20%>
                                    帳號
                                </td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="name" name="name">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    密碼
                                </td>
                                <td width=max>
                                    <input class="" type="password" style="width:80%;color: black" id="password" name="password">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    權限等級
                                </td>
                                <td width=max>
                                    <input class="" type="number" style="width:80%;color: black" id="Auth_level" name="Auth_level">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    群組ID
                                </td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="Group_ID" name="Group_ID">
                                </td>
                            </tr>
                            <tr align="center">
                                <td></td>
                                <td align="left">
                                    <button class="btn btn-danger" style="vertical-align: middle" type="submit"><label style="font-family: 'Microsoft JhengHei UI';font-size: 16px;height: 16px">保存</label></button>
                                    <button class="btn btn-danger" style="vertical-align: middle" type="submit"><label style="font-family: 'Microsoft JhengHei UI';font-size: 16px;height: 16px">取消</label></button>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </form>
                </div>
                <div id="Create" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                    <form id="send_C" method="post" action="{{route('acc_C')}}">
                        {{ csrf_field() }}
                        <table class="table tm-table-small" border="1">
                            <thead>
                            <th scope="col">資料欄位</th>
                            <th scope="col"></th>
                            </thead>
                            <tbody>
                            <tr>
                                <td width=20%>
                                    帳號
                                </td>
                                <td width=max>
{{--                                    <input class="" type="text" style="width:80%;color: black" id="name" name="name">--}}
                                    <input id="name" type="text" class=" @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus style="width:80%;color: black">
                                    @if(session('error'))
                                        <span class="text-danger">
                                            <strong>{{ session('error')}}</strong>
                                        </span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    密碼
                                </td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="password" name="password">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    權限等級
                                </td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="Auth_level" name="Auth_level">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    狀態
                                </td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="Status" name="Status">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    群組ID
                                </td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="Group_ID" name="Group_ID">
                                </td>
                            </tr>
                            <tr align="center">
                                <td></td>
                                <td align="left">
                                    <button class="btn btn-danger" style="vertical-align: middle" type="submit"><label style="font-family: 'Microsoft JhengHei UI';font-size: 16px;height: 16px">新增</label></button>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>

        <form action="{{route('acc_C')}}" method="POST">
            {{ csrf_field() }}
            帳號：<input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>
            @if(session('error'))
                <span class="text-danger">
                    <strong>{{ session('error')}}</strong>
                </span>
            @endif

            密碼：<input type="text" name="password" /><br />
            權限等級：<input type="text" name="Auth_level" /><br />
            狀態：<input type="text" name="Status" /><br />
            群組ID：<input type="text" name="Group_ID" /><br />
            <input type="submit" value="送出" />
        </form>
        <form action="{{route('acc_U')}}" method="POST">
            {{ csrf_field() }}
            帳號：<input type="text" name="name" /><br />
            密碼：<input type="text" name="password" /><br />
            權限等級：<input type="text" name="Auth_level" /><br />
            狀態：<input type="text" name="Status" /><br />
            群組ID：<input type="text" name="Group_ID" /><br />
            <input type="submit" value="修改" />
        </form>
        <form action="{{route('acc_D')}}" method="POST">
            {{ csrf_field() }}
            帳號：<input type="text" name="name" /><br />
            <input type="submit" value="刪除" />
        </form>
    </div>
    <script>
        $("#send_S").submit(function(e) {
            var form = $(this);
            var url = '{{route('acc_R')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    alert(JSON.stringify(data))
                    $('#show_account').hide();
                    $('#create_account').hide();
                    $('#edit_account').show();
                    $('#edit_account').click();
                },
                error:function(data){
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>
    <script>
        $("#send_D").submit(function(e) {
            var form = $(this);
            var url = '{{route('acc_D')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    alert(JSON.stringify(data))
                },
                error:function(data){
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>
    <script>
        $("#send_U").submit(function (e) {
            var form = $(this);
            var url = '{{route('acc_U')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function (data) {
                    alert("success")
                },
                error:function (data) {
                    alert(JSON.stringify(data))
                }
            })
            e.preventDefault(); // avoid to execute the actual submit of the form.
        })
    </script>
{{ $Users }}

@endsection
