<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use function MongoDB\BSON\toJSON;

class AccountController extends Controller
{
    //
    public function show()
    {
        $user = User::all();

        return view('admin_acc',['Users'=>$user,'message'=>'']);
    }

    public function store(Request $request)
    {
        // 新增一筆資料

        $user = new User;
        $user->name = $request->name;
        $user->password = bcrypt($request->password);
        $user->Auth_level = $request->Auth_level;
        $user->Status = $request->Status;
        $user->Group_ID = $request->Group_ID;
        try{
            $user->save();
        }
        catch (\Illuminate\Database\QueryException $e){
            $erro_meg="帳號已重複";
            return back()->withError($erro_meg)->withInput();
            //return redirect()->route('account',["message"=>get_class($e)]);
        }
        return redirect()->route('account');
    }

    public function update(Request $request)
    {
        // 修改資料
        $user = User::where('name',$request->name);
        $user->update([
            'name'=>$request->name,
            'password'=>bcrypt($request->password) == null ? $user->password : bcrypt($request->password),
            'Auth_level'=>$request->Auth_level == null ? $user->Auth_level : $request->Auth_level,
            'Status'=>$request->Status == null ? $user->Status : $request->Status,
            'Group_ID'=> $request->Group_ID == null ? $user->Group_ID : $request->Group_ID,
        ]);
        return redirect()->route('account');
    }

    public function delete(Request $request)
    {
        // 刪除資料
        $user = User::where('name',$request->name);
        $user->delete();
        return redirect()->route('account');
    }

    public function select(Request $request)
    {
        // 查詢
        $user = User::where('name',$request->name)->get();
        return $user ;
    }
}
