<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


/*----------------所有 Route 都要包在 log middleware 中，才會有紀錄log----------------*/
Route :: group (['middleware'=>['log']],function (){
    Route::get('login','Auth\LoginController@loginpage')->name('loginpage');
    Route::post('login','Auth\LoginController@login')->name('login');


    /*---------------------登入後可存取路徑-----------------------------------*/
    Route::group(['middleware' => ['auth:User']],function (){
        /*.........'middleware' => ['can:admin'] admin 可存取的頁面 .........*/
        Route::group(['middleware' => ['can:admin']],function(){
            /*---------------- 帳號管理 ----------------*/
            Route::group(['prefix' => 'admin/account'],function (){
                Route::get('', 'AccountController@show')->name('account');
                Route::post('create','AccountController@store')->name('acc_C');
                Route::post('select','AccountController@select')->name('acc_R');
                Route::post('update','AccountController@update')->name('acc_U');
                Route::post('delete','AccountController@delete')->name('acc_D');
            });
            /*--------------- 群組管理 ----------------待確認作法 */

            /*--------------- 操作日誌頁面 ---------------- */


        });

        /*................. 一般使用者可存取的頁面...............................*/
        Route::get('logout', 'Auth\LoginController@logout')->name('logout');
        Route::get('/plates', function () {return view('plates');});
    });
});
