<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Device;
use App\Device_Group;
class DeviceController extends Controller
{
    //
    public function index(){
        $device=Device::all();
        $group=new Device_Group;
        foreach ($device as $dv){
            $group_name=$group->where("No",$dv["Device_Group_ID"])->get();
            if(!$group_name->isEmpty()) {
                $group_name = $group_name[0]["Group_Name"];
                $dv["Device_Group_ID"] = $group_name;
            }
            else{
                $dv["Device_Group_ID"]="無群組";
            }
        }
        $groups=Device_Group :: all();
        foreach ($groups as $gr){
            if($gr["Point_A_Device"]==null){
                $gr["Point_A_Device"]="無設備";
            }
            if($gr["Point_B_Device"]==null){
                $gr["Point_B_Device"]="無設備";
            }
        }
        return view('device')->with(["Devices"=>$device,"Groups"=>$groups]);
    }
    public function store(Request $request){
        //新增一設備
        $device=new Device;
        $device->ID=str_replace( " ", "",$request->ID);
        $device->Location=$request->Location;
        $device->GPS=$request->GPS;
        $device->Server_ID=$request->Server_ID;
        try{
            $device->save();
        }
        catch (\Illuminate\Database\QueryException $e){
            $erro_meg="設備 名稱/ID 已重複";
            //$e->getMessage(); 真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('device');
    }
    public function select(Request $request){
        $device=Device::all();
        $groups=new Device_Group;

        if ($request->ID != null){
            $device=$device->where('ID',$request->ID);
        }
        if ($request->Location != null){
            $device=$device->where('Location',$request->Location);
        }
        if ($request->Server_ID != null){
            $device=$device->where('Server_ID',$request->Server_ID);
        }
        if ($request->Group_Name != null){
            if ($request->Group_Name != "無群組"){
                $group_id=$groups->where('Group_Name',$request->Group_Name)->get();
                if ($group_id->isEmpty()){
                    $meg = array("error"=>"該群組不存在");
                    $meg = json_encode($meg);
                    return $meg;
                }
                $device=$device->where('Device_Group_ID',$group_id[0]["No"]);
            }
            else{
                $device=$device->where('Device_Group_ID',null);
            }
        }
        if($device->isEmpty()){
            $meg = array("error"=>"查無結果");
            $meg = json_encode($meg);
            return $meg;
        }

        foreach ($device as $dv){
            $group_name=$groups->where("No",$dv["Device_Group_ID"])->get();
            if(!$group_name->isEmpty()) {
                $group_name = $group_name[0]["Group_Name"];
                $dv["Device_Group_ID"] = $group_name;
            }
            else{
                $dv["Device_Group_ID"]="無群組";
            }
        }
        return $device;
    }
    public function update(Request $request){
        // 修改資料
        $devices = Device::where('ID',$request->ID);

        $device=$devices->get();
        try {
            $group=Device_Group :: where("No",$device[0]["Device_Group_ID"]);
            $device_id=$device[0]["ID"];

            if (!$group->where("Point_A_Device",$device_id)->get()->isEmpty()){
                $group->update([
                    "Point_A_Device"=>$request->ID,
                ]);
            }
            else if (!$group->where("Point_B_Device",$device_id)->get()->isEmpty()){
                $group->update([
                    "Point_B_Device"=>$request->ID,
                ]);
            }

            $devices->update([
                'ID'=>str_replace( " ", "",$request->ID2),
                'Location' => $request->Location,
                'GPS' => $request->GPS,
                'Server_ID' => $request->Server_ID,
            ]);
        }
        catch (Exception $e){
            $erro_meg="修改失敗";
            //$e->getMessage(); 真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('device');
    }
    public function delete(Request $request){
        // 刪除設備
        $devices = Device::where('ID',$request->ID);
        $device=$devices->get();
        $group=Device_Group :: where("No",$device[0]["Device_Group_ID"]);
        $device_id=$device[0]["ID"];

        if (!$group->where("Point_A_Device",$device_id)->get()->isEmpty()){
            $group->update([
                "Point_A_Device"=>null,
            ]);
        }
        else if (!$group->where("Point_B_Device",$device_id)->get()->isEmpty()){
            $group->update([
                "Point_B_Device"=>null,
            ]);
        }
        $devices->delete();
        return redirect()->route('device');
    }

}
