<?php

namespace App\Http\Controllers;

use App\User;
use App\Group;
use Illuminate\Http\Request;
use MongoDB\BSON\Type;
use mysql_xdevapi\Collection;
use function MongoDB\BSON\toJSON;

class AccountController extends Controller
{
    //
    public function show()
    {
        $user = User::all();

//        dd($user[0]['Group_ID']);
        $group=new Group;
        $users=collect();
        foreach ($user as $u){
            $temp=array();
            $temp["name"]=$u['name'];
            $temp["Auth_level"]=$u['Auth_level'];
            $temp["Status"]=$u['Status'];
            $group_name=($group->where('ID',$u['Group_ID'])->get())[0]["Group_Name"];
            $temp["Group_Name"]=$group_name;
            $users->add($temp);
        }

        $group=$group->all();
        $groups=collect();
        foreach ($group as $g){
            $temp=array();
            $temp["ID"]=$g["ID"];
            $temp["Group_Name"]=$g["Group_Name"];
            $amount=$user->where('Group_ID',$g['ID'])->count();
            $temp["Amount"]=$amount;
            $temp["Group_Detail"]=$g["Group_Detail"];
            $groups->add($temp);
        }
//        dd($groups);
        return view('admin_acc',['Users'=>$users,'Groups'=>$groups,'message'=>'']);
    }

    public function store(Request $request)
    {
//        if ($request->Group_Name)
//        $request->Group_Name;
//        // 新增一筆資料
//        $group = new Group;
//        $group->Group_Name=$request->Group_Name;
//
//        try{
//            $group->save();
//        }
//        catch (\Illuminate\Database\QueryException $e){
//            $erro_meg="群組名稱已重複";
//            //$e->getMessage(); 真正錯誤原因
//            return back()->withError($erro_meg)->withInput();
//        }

        // 新增一筆資料
        $user = new User;
        $user->name = $request->name;
        $user->password = bcrypt($request->password);
        $user->Auth_level = $request->Auth_level;
        $user->Status = $request->Status;
        // 群組設定
        $group = new Group;
        //dd($request->Group_Name);
        if ($group->where('Group_Name',$request->Group_Name)->get()->isEmpty()){
            $group->Group_Name=$request->Group_Name;
            $group->save();
        }
        $group_id=$group->where('Group_Name',$request->Group_Name)->get();
        $user->Group_ID = $group_id[0]->ID;
        try{
            $user->save();
        }
        catch (\Illuminate\Database\QueryException $e){
            $erro_meg="帳號已重複";
            //$e->getMessage(); 真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('account');
    }

    public function update(Request $request)
    {
        // 修改資料
        $user = User::where('name',$request->name);
        try {
            $user->update([
                'name' => $request->name,
                'password' => bcrypt($request->password),
                'Auth_level' => $request->Auth_level,
                'Status' => $request->Status,
                'Group_ID' => $request->Group_ID,
            ]);
        }
        catch (Exception $e){
            $erro_meg="修改失敗";
            //$e->getMessage(); 真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('account');
    }

    public function delete(Request $request)
    {
        // 刪除資料
        $user = User::where('name',$request->name);
        $user->delete();
        return redirect()->route('account');
    }

    public function select(Request $request)
    {
        // 查詢單筆
        $user = User::where('name',$request->name)->get();
        $datas=collect();
        $groups=new Group;
        foreach ($user as $u){
            $temp=array();
            $temp["name"]=$u['name'];
            $temp["Auth_level"]=$u['Auth_level'];
            $temp["Status"]=$u['Status'];
            $group_name=($groups->where('ID',$u['Group_ID'])->get())[0]["Group_Name"];
            $temp["Group_Name"]=$group_name;
            $temp['Group_ID']=$u['Group_ID'];
            $datas->add($temp);
        }

        return $datas ;
    }

    public function R2_user(Request $request)
    {
        // 查詢多筆
        $user = User::all();
        if ($request->name !=null){
            $user=$user->where("name",$request->name);
        }
        if ($request->Auth_level !=null){
            $user = $user->where('Auth_level',$request->Auth_level);
        }
        if ($request->Status !=null){
            $user = $user->where('Status',$request->Status);
        }

        $group=new Group;
        if ($request->Group_Name !=null){
            if ($group->where('Group_Name',$request->Group_Name)->get()->isEmpty()){
                $meg = array("error"=>"群組名稱不存在");
                $meg = json_encode($meg);
                return $meg;
            }
            else{
                $group_id=$group->where('Group_Name',$request->Group_Name)->get();
                $group_id= $group_id[0]->ID;
                $user = $user->where('Group_ID',$group_id);
            }
        }

        if ($user->isEmpty()){
            $meg = array("error"=>"查無結果");
            $meg = json_encode($meg);
            return $meg;
        }

        $datas=collect();
        foreach ($user as $u){
            $temp=array();
            $temp["name"]=$u['name'];
            $temp["Auth_level"]=$u['Auth_level'];
            $temp["Status"]=$u['Status'];
            $group_name=($group->where('ID',$u['Group_ID'])->get())[0]["Group_Name"];
            $temp["Group_Name"]=$group_name;
            $datas->add($temp);
        }


        return $datas;
    }


    // 使用者群組管理
    public function create_group(Request $request){
        $request->Group_Name;
        // 新增一筆資料
        $group = new Group;
        $group->Group_Name=$request->Group_Name;

        try{
            $group->save();
        }
        catch (\Illuminate\Database\QueryException $e){
            $erro_meg="群組名稱已重複";
            //$e->getMessage(); 真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('account');
    }
}
