@extends('layouts.default')
@section('header')
    <link rel="stylesheet" href="{{asset('css/templatemo-style.css')}}">
    {{--引入 jquery 相關套件--}}
{{--    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>--}}
{{--    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>--}}

@endsection
@section('content')
    <div class="container-fluid">
        <div class="tm-bg-light tm-block-taller "style="padding:20px;margin-bottom: 100px">
            <h2 style="font-size: x-large" class="tm-block-title">使用者管理介面</h2>
            <ul class="nav nav-tabs">
                <li><a class="nav-link active" data-toggle="tab" href="#home" id="show_account"><span class="glyphicon glyphicon-user"></span>帳號管理</a></li>
                <li><a class="nav-link" data-toggle="tab" href="#Create" id="create_account"><span class="glyphicon glyphicon-plus"></span>新增帳號</a></li>
                <li><a class="nav-link" data-toggle="tab" href="#Search" id="search_account">帳號查詢</a> </li>
                <li><a class="nav-link" data-toggle="tab" href="#Group" id="search_account">群組管理</a> </li>
                <li><a class="nav-link" data-toggle="tab" href="#Edit" id="edit_account" style="display: none"><span class="glyphicon glyphicon-pencil"></span>編輯帳號</a></li>
            </ul>
            {{--帳號管理--}}
            <div class="tab-content">
                <div id="home" class="tab-pane fade show active" style="padding: 20px 20px 20px 20px; background-color: white">
                    <table class="table tm-table-small">
                        <thead>
                        <tr>
                            <th scope="col" style="text-align: center">姓名</th>
                            <th scope="col" style="text-align: center">權限等級</th>
                            <th scope="col" style="text-align: center">狀態</th>
                            <th scope="col" style="text-align: center">群組</th>
                            <th scope="col" style="text-align: center">編輯區</th>
                        </tr>
                        </thead>
                        <tbody>
                        <form method="post" id="send_S"  onsubmit="return false" style="display: inline-block">
                            @csrf
                            <input type="hidden" id="name_S" value="" name="name">
                        </form>
                        <form method="post" id="send_D" action="{{route('acc_D')}}" style="display: inline-block">
                            @csrf
                            <input type="hidden" id="name_D" value="" name="name">
                        </form>
                        @foreach($Users as $user)
                                <tr>
                                    <td style="vertical-align: middle;text-align: center" >{{$user['name']}}</td>
                                    <td style="vertical-align: middle;text-align: center" >{{$user['Auth_level']}}</td>
                                    <td style="vertical-align: middle;text-align: center" >
                                        @if($user['Status'] == '停用')
                                            <label style="background-color: red;color: white;border-radius: 45px;padding: 3px;font-family: 'Microsoft JhengHei UI';">{{$user ['Status']}}</label>
                                        @else
                                            <label style="background-color: #2a9055;color: white;border-radius: 45px;padding: 3px;font-family: 'Microsoft JhengHei UI';">{{$user ['Status']}}</label>
                                        @endif
                                    </td>
                                    <td style="vertical-align: middle;text-align: center" >{{$user ['Group_Name']}}</td>
                                    <td style="vertical-align: middle;text-align: center">
                                        <button class="btn btn-primary4"  onclick="go_select('{{$user['name']}}','S')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                        <button class="btn btn-primary3"  onclick="go_select('{{$user['name']}}','D')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                    </td>
                                </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                {{--編輯帳號--}}
                <div id="Edit" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                    <form method="post" action="{{route('acc_U')}}" id="send_U">
                        @csrf
                        <table class="table tm-table-small" border="1">
                            <thead>
                            <th scope="col">資料欄位</th>
                            <th scope="col"></th>
                            </thead>
                            <tbody>
                            <tr>
                                <td width=20%>帳號</td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="name_U_show" readonly="true" required disabled>
                                    <input class="" type="text" style="width:80%;color: black" id="name_U" name="name" readonly="true" hidden>
                                </td>
                            </tr>
                            <tr>
                                <td>密碼</td>
                                <td width=max>
                                    <input class="" type="password" style="width:80%;color: black" id="password_U" name="password" required>
                                </td>
                            </tr>
                            <tr>
                                <td>權限等級</td>
                                <td width=max>
                                    <select id="Auth_level_U" name="Auth_level" style="color: black" required>
                                        <option value="管理者">管理者</option>
                                        <option value="使用者">使用者</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td>群組</td>
                                <td width=max>
                                    <select id="Group_Name_U" name="Group_ID" required>
                                        @foreach($Groups as $group)
                                            <option value="{{$group['ID']}}">{{$group['Group_Name']}}</option>
                                        @endforeach
                                    </select>
{{--                                    <input class="" type="text" style="width:80%;color: black" id="Group_Name_U" name="Group_Name">--}}
                                </td>
                            </tr>
                            <tr>
                                <td>狀態</td>
                                <td width=max>
                                    <select id="Status_U" name="Status" required>
                                        <option value="啟用">啟用</option>
                                        <option value="停用">停用</option>
                                    </select>
{{--                                    <input class="" type="text" style="width:80%;color: black" id="Status_U" name="Status">--}}
                                </td>
                            </tr>
                            <tr align="center">
                                <td/>
                                <td align="left">
                                    <input class="btn btn-danger btn-primary-font" style="height:auto;vertical-align: middle" value="保存" type="submit"/>
                                    <button class="btn btn-danger btn-primary-font" style="height:auto;vertical-align: middle" type="button" onclick="cancel()">取消</button>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </form>
                </div>
                {{--新增帳號--}}
                <div id="Create" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                    <form id="send_C" method="post" action="{{route('acc_C')}}">
                        @csrf
                        <table class="table tm-table-small" border="1">
                            <thead>
                            <th scope="col">資料欄位</th>
                            <th scope="col"></th>
                            </thead>
                            <tbody>
                            <tr>
                                <td width=20%>帳號</td>
                                <td width=max>
{{--                                    <input class="" type="text" style="width:80%;color: black" id="name" name="name">--}}
                                    <input id="name_C" type="text" class=" @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus style="width:80%;color: black">
                                    @if(session('error'))
                                        <span class="text-danger">
                                            <strong>{{ session('error')}}</strong>
                                        </span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td>密碼</td>
                                <td width=max>
                                    <input class="" type="text" style="width:80%;color: black" id="password_C" name="password" required>
                                </td>
                            </tr>
                            <tr>
                                <td>權限等級</td>
                                <td>
                                    <select id="Auth_level_C" name="Auth_level" style="color: black" required>
                                        <option value="管理者">管理者</option>
                                        <option value="使用者">使用者</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td>狀態</td>
                                <td width=max>
                                    <select id="Status_C" name="Status" required>
                                        <option value="啟用">啟用</option>
                                        <option value="停用">停用</option>
                                    </select>
{{--                                    <input class="" type="text" style="width:80%;color: black" id="Status_C" name="Status" required value="正常">--}}
                                </td>
                            </tr>
                            <tr>
                                <td>群組</td>
                                <td width=max>
                                    <select id="Group_Name_C" name="Group_Name" required>
                                        @foreach($Groups as $group)
                                            <option value="{{$group['Group_Name']}}">{{$group['Group_Name']}}</option>
                                        @endforeach
                                    </select>
{{--                                    <input class="" type="text" style="width:80%;color: black" id="Group_Name_C" name="Group_Name" required value="0">--}}
                                </td>
                            </tr>
                            <tr align="center">
                                <td></td>
                                <td align="left">
                                    <input class="btn btn-danger btn-primary-font" style="height:auto;vertical-align: middle" type="submit" value="新增"/>
                                    <button class="btn btn-danger btn-primary-font" style="height:auto;vertical-align: middle" type="button" onclick="cancel()">取消</button>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </form>
                    </div>
                {{--帳號查詢--}}
                <div id="Search" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                    <div class="input-group mb-3 table tm-table-small" style="padding: 5px 5px">
                        <form method="post" id="send_R">
                            @csrf
                            <label>　查詢條件：</label>
                            <input id="name_R" value="" name="name" placeholder="姓名">
                            <select class="form-control-sm" id="Auth_level_R" name="Auth_level" style="font-size:16px;" required>
                                <option value="" selected>--權限等級--</option>
                                <option value="管理者">管理者</option>
                                <option value="使用者">使用者</option>
                            </select>
                            <select class="form-control-sm" id="Status_R" name="Status" style="font-size:16px;">
                                <option value="" selected>--狀態--</option>
                                <option value="啟用">啟用</option>
                                <option value="停用">停用</option>
                            </select>
                            <select class="form-control-sm" id="Group_Name_R" name="Group_Name" style="font-size:16px;">
                                <option value="" selected>--群組--</option>
                                @foreach($Groups as $g)
                                    <option value="{{$g['Group_Name']}}">{{$g['Group_Name']}}</option>
                                @endforeach
                            </select>
{{--                            <input id="Status_R" value="" name="Status" placeholder="狀態">--}}
{{--                            <input id="Group_Name_R" value="" name="Group_Name" placeholder="群組">--}}
                            <button class="btn btn-danger" type="button" onclick="check()">查詢</button>
                        </form>
                    </div>
                    <div style="padding-top: 5px;display: none" id="Search_result">
                        <table class="table tm-table-small info" id="tb_Search_result" border="1">
                            <thead>
                            <tr>
                                <th scope="col" style="text-align: center">姓名</th>
                                <th scope="col" style="text-align: center">權限等級</th>
                                <th scope="col" style="text-align: center">狀態</th>
                                <th scope="col" style="text-align: center">群組</th>
                                <th scope="col" style="text-align: center">編輯區</th>
                            </tr>
                            </thead>
                            <tbody align="center">
                            </tbody>
                        </table>
                    </div>
                </div>

                {{-- 群組 新增 刪除 修改 --}}
                <div id="Group" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                        <form action="{{route('group_D')}}" method="post" id="send_D_group">
                            @csrf
                            <input type="hidden" id="Group_Name_group_D" value="" name="Group_Name">
                            <input type="hidden" type="submit"/>
                        </form>
                    <div style="padding-top: 5px;">
                        <table class="table tm-table-small info" id="tb_Search_result" border="1">
                            <thead>
                            <tr>
                                <th scope="col" style="text-align: center">群組名稱</th>
                                <th scope="col" style="text-align: center">成員人數</th>
                                <th scope="col" style="text-align: center">詳細說明</th>
                                <th scope="col" style="text-align: center">編輯區</th>
                            </tr>
                            </thead>
                            <tbody align="center">
                            @foreach($Groups as $g)
                            <tr>
                                <td scope="col" style="text-align: center">{{$g['Group_Name']}}</td>
                                <td scope="col" style="text-align: center">{{$g['Amount']}}</td>
                                <td scope="col" style="text-align: center">{{$g['Group_Detail']}}</td>
                                <td style="vertical-align: middle;text-align: center">
                                    <button class="btn btn-primary4" data-toggle="modal" data-target="#update_group_modal" onclick="go_update_group('{{$g['ID']}}','{{$g['Group_Name']}}','{{$g['Group_Detail']}}')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                    <button class="btn btn-primary3"  onclick="go_select('{{$g['Group_Name']}}','D_group')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                </td>
                            </tr>
                            @endforeach
                            </tbody>
                        </table>
                        <!-- Button trigger modal -->
                        <button style="width: 100%" type="button" class="btn btn-primary" data-toggle="modal" data-target="#create_group_modal">
                            + 新增群組
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal 編輯群組-->
    <div class="modal fade" id="update_group_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">編輯群組</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{route('group_U')}}" id="send_U_group">
                    @csrf
                <div class="modal-body">
                    <div style="padding: 20px 20px 20px 20px; background-color: white">
                            <table class="table tm-table-small" border="1">
                                <thead>
                                <th scope="col">編輯群組</th>
                                <th scope="col"></th>
                                </thead>
                                <tbody>
                                <tr>
                                    <input class="" type="text" style="width:80%;color: black" id="Group_ID_group"name="ID" hidden required>
                                    <td width=50%>群組名稱</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Group_Name_group"name="Group_Name" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>詳細說明</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Group_Detail_group" name="Group_Detail">
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <input type="submit" value="修改" class="btn btn-primary"/>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal 新增群組-->
    <div class="modal fade" id="create_group_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">新增群組</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{route('group_C')}}" id="send_C_group">
                    @csrf
                <div class="modal-body">
                    <div style="padding: 20px 20px 20px 20px; background-color: white">
                            <table class="table tm-table-small" border="1">
                                <thead>
                                <th scope="col">新增群組</th>
                                <th scope="col"></th>
                                </thead>
                                <tbody>
                                <tr>
                                    <td width=50%>群組名稱</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="Group_Name" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>詳細說明</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="Group_Detail">
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <input type="submit" value="新增" class="btn btn-primary"/>
                </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function go_select(name,type) {
            if (type=="S"){
                var input_name=document.getElementById("name_S");
                input_name.value=name;
                $("#send_S").submit();
                $('.nav-tabs a[href="#Edit"]').tab('show');
            }
            else if (type=="D"){
                var input_name=document.getElementById("name_D");
                input_name.value=name;
                $("#send_D").submit();
            }
            else if (type=="D_group"){
                var input_name=document.getElementById("Group_Name_group_D");
                input_name.value=name;
                $("#send_D_group").submit();
            }
        }
    </script>

    <script>
        function go_update_group(ID,group_name,group_detail) {
            var input_name=document.getElementById("Group_Name_group");
            input_name.value=group_name;
            var input_name=document.getElementById("Group_Detail_group");
            input_name.value=group_detail;
            var input_name=document.getElementById("Group_ID_group");
            input_name.value=ID;
        }
    </script>
    <script>
        $("#send_S").submit(function(e) {
            var form = $(this);
            var url = '{{route('acc_R')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    $("#Edit").show();
                    $("#edit_account").show();
                    $("#home").hide();
                    $("#Create").hide();
                    $("#Search").hide();
                    $("#Group").hide();
                    document.getElementById("name_U").value=data[0]["name"];
                    document.getElementById("name_U_show").value=data[0]["name"];
                    document.getElementById("password_U").value=data[0]["password"];
                    document.getElementById("Auth_level_U").value=data[0]["Auth_level"];
                    document.getElementById("Group_Name_U").value=data[0]["Group_ID"];
                    document.getElementById("Status_U").value=data[0]["Status"];
                },
                error:function(data){
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>
    <script>
        function  cancel() {
            if (Trace_tab=="home"){
                $('.nav-tabs a[href="#home"]').tab('show');
                $("#Edit").hide();
                $("#edit_account").hide();
                $("#Create").hide();
                $("#Group").hide();
                $("#home").show();
            }
            else if (Trace_tab =="Search"){
                $('.nav-tabs a[href="#Search"]').tab('show');
                $("#Edit").hide();
                $("#edit_account").hide();
                $("#Create").hide();
                $("#Group").hide();
                $("#Search").show();
            }
            else if (Trace_tab =="Group"){
                $('.nav-tabs a[href="#Group"]').tab('show');
                $("#Edit").hide();
                $("#edit_account").hide();
                $("#Create").hide();
                $("#Group").show();
                $("#Search").hide();
            }
        }
    </script>

    <script>
        //Trace tab
        var Trace_tab="home";
        $('.nav-tabs a[href="#home"]').on('click',function (e) {
            Trace_tab="home";
            $("#Edit").hide();
            $("#edit_account").hide();
            $("#Create").hide();
            $("#Search").hide();
            $("#Group").hide();
            $("#home").show();
        });
        $('.nav-tabs a[href="#Search"]').on('click',function (e) {
            Trace_tab="Search";
            $("#Edit").hide();
            $("#edit_account").hide();
            $("#Create").hide();
            $("#Search").show();
            $("#home").hide();
            $("#Group").hide();
        });
        $('.nav-tabs a[href="#Create"]').on('click',function (e) {
            $('#Edit').hide();
            $("#edit_account").hide();
            $("#home").hide();
            $("#Create").show();
            $("#Search").hide();
            $("#Group").hide();
        });
        $('.nav-tabs a[href="#Group"]').on('click',function (e) {
            Trace_tab="Group";
            $('#Edit').hide();
            $("#edit_account").hide();
            $("#home").hide();
            $("#Create").hide();
            $("#Search").hide();
            $("#Group").show();
        });
    </script>
    <script>
        function check() {
            $("#tb_Search_result tr:not(:first)").empty("");
            var name_R = document.getElementById("name_R").value;
            var Auth_level_R = document.getElementById("Auth_level_R").value;
            var Group_Name_R = document.getElementById("Group_Name_R").value;
            var Status_R = document.getElementById("Status_R").value;
            var result;
            if (name_R == Auth_level_R && Auth_level_R == Group_Name_R && Group_Name_R == Status_R && Group_Name_R == ""){
                alert("查詢條件不可空白！！")
                return;
            }
            else {
                $("#send_R").submit();
            }
        }
    </script>
    <script>
        $("#send_R").submit(function(e) {
            var form = $(this);
            var url = '{{route('acc_R2')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    //alert(data['error'])
                    if(data['error'] == "查無結果"){
                        document.getElementById("name_R").value="";
                        document.getElementById("Auth_level_R").value="";
                        document.getElementById("Status_R").value="";
                        document.getElementById("Group_Name_R").value="";
                        alert('查無結果！！');
                        $('#Search_result').hide();
                    }else {
                        $.each(data, function(index, element) {
                            $('#tb_Search_result').append(
                                $('<tr></tr>').append(
                                    $('<td></td>',{text:element.name}),
                                    $('<td></td>',{text:element.Auth_level}),
                                    $('<td></td>',{text:element.Status}),
                                    $('<td></td>',{text:element.Group_Name}),
                                    $('<td>' +
                                        '<button class="btn btn-primary4" onclick="go_select(\''+element.name+'\',\'S\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                        '<button class="btn btn-primary3"  onclick="go_select(\''+element.name+'\',\'D\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                        '</td>')
                                )
                            );
                        });
                        document.getElementById("name_R").value="";
                        document.getElementById("Auth_level_R").value="";
                        document.getElementById("Status_R").value="";
                        document.getElementById("Group_Name_R").value="";
                        $('#Search_result').show();
                    }
                },
                error:function(data){
                    console.log(data);
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>
    {{$Groups}}
{{ $Users }}
    <script>
        @if(session('error'))
            alert('{{ session('error')}}')
        @endif
    </script>
{{--    @if(session('error'))--}}
{{--        <span class="text-danger">--}}
{{--            <strong>{{ session('error')}}</strong>--}}
{{--        </span>--}}
{{--    @endif--}}
@endsection
