@extends('layouts.default')
    @section('header')
        <link rel="stylesheet" href="{{asset('css/templatemo-style.css')}}">
    @endsection

@section('content')
    <div class="container-fluid">
        <div class="tm-bg-light tm-block-taller "style="padding:20px;margin-bottom: 100px">
            <h2 style="font-size: x-large" class="tm-block-title">設備管理介面</h2>
            {{--設備查詢--}}
            <div class="input-group mb-3 table tm-table-small" style="padding: 5px 5px;">
                <form method="post" id="send_R" >
                    @csrf
                    <label>　設備查詢：</label>
                    <input class="form-control-sm" id="ID_R" value="" name="ID" placeholder="ID" style="width: 80px;font-size: 16px">
                    <input class="form-control-sm" id="Location_R" value="" name="Location" placeholder="地點名稱" style="font-size: 16px">
                    <input class="form-control-sm" id="Server_ID_R" value="" name="Server_ID" placeholder="所屬伺服器" style="font-size: 16px">
                    <select class="form-control-sm" id="Group_R" name="Group_Name" style="font-size:16px;">
                        <option value="" selected>--所屬群組--</option>
                        <option value="無群組">無群組</option>
                        @foreach($Groups as $Group)
                            <option value="{{$Group->Group_Name}}">{{$Group->Group_Name}}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-danger" type="button" onclick="check()">查詢</button>
                    <button class="btn btn-danger" type="button" data-toggle="modal" data-target="#create_device_modal">新增設備</button>
                    <input type="hidden" data-toggle="modal" data-target="#device_r_Modal" id="show_result_d">
                </form>
            </div>
            {{--設備群組查詢--}}
            <div class="input-group mb-3 table tm-table-small" style="padding: 5px 5px;">
                <form method="post" id="send_G_R">
                    @csrf
                    <label>　設備群組查詢：</label>
                    <input class="form-control-sm" id="Group_Name_R" value="" name="Group_Name" placeholder="群組名稱" style="font-size: 16px">
                    <select class="form-control-sm" id="Point_A_Device_R" name="Point_A_Device" style="font-size:16px;">
                        <option value="" selected>--A點設備--</option>
                        <option value="無">無設備</option>
                        @foreach($Devices as $device)
                            <option value="{{$device->ID}}">{{$device->ID}}</option>
                        @endforeach
                    </select>
                    <select class="form-control-sm" id="Point_B_Device_R" name="Point_B_Device" style="font-size:16px;">
                        <option value="" selected>--B點設備--</option>
                        <option value="無">無設備</option>
                        @foreach($Devices as $device)
                            <option value="{{$device->ID}}">{{$device->ID}}</option>
                        @endforeach
                    </select>
                    <input type="number" class="form-control-sm" id="Distance_R" value="" name="Distance" placeholder="距離" style="font-size: 16px;width: 150px">
                    <input type="number" class="form-control-sm" id="Speed_Limit_R" value="" name="Speed_Limit" placeholder="限速" style="font-size: 16px;width: 150px">
                    <input class="form-control-sm" id="Prohibited_Vehicles_R" value="" name="Prohibited_Vehicles" placeholder="禁行車種" style="font-size: 16px;width: 150px">
                    <button class="btn btn-danger" type="button" onclick="check_G()">查詢</button>
                    <input type="hidden" data-toggle="modal" data-target="#device_group_r_Modal" id="show_result_dg">
{{--                    <button class="btn btn-danger" type="button" data-toggle="modal" data-target="#create_device_modal">新增設備</button>--}}
                </form>
            </div>
            {{--設備查詢結果--}}
{{--            <div style="padding-top: 5px;display: none;padding-bottom: 20px" id="Search_result">--}}
{{--                <h2 style="font-size: x-large" class="tm-block-title">設備查詢結果</h2>--}}
{{--                <table class="table tm-table-small info" id="tb_Search_result" border="1">--}}
{{--                    <thead>--}}
{{--                    <tr>--}}
{{--                        <th scope="col" style="text-align: center">ID</th>--}}
{{--                        <th scope="col" style="text-align: center">地點名稱</th>--}}
{{--                        <th scope="col" style="text-align: center">GPS</th>--}}
{{--                        <th scope="col" style="text-align: center">所屬伺服器</th>--}}
{{--                        <th scope="col" style="text-align: center">所屬群組</th>--}}
{{--                        <th scope="col" style="text-align: center">編輯區</th>--}}
{{--                    </tr>--}}
{{--                    </thead>--}}
{{--                    <tbody align="center">--}}
{{--                    </tbody>--}}
{{--                </table>--}}
{{--            </div>--}}
            {{--設備群組查詢結果--}}
{{--            <div style="padding-top: 5px;display: none;padding-bottom: 20px" id="Search_result_G">--}}
{{--                <h2 style="font-size: x-large" class="tm-block-title">設備群組查詢結果</h2>--}}
{{--                <table class="table tm-table-small info" id="tb_Search_result_G" border="1">--}}
{{--                    <thead>--}}
{{--                    <tr>--}}
{{--                        <th scope="col" style="text-align: center">No</th>--}}
{{--                        <th scope="col" style="text-align: center">群組名稱</th>--}}
{{--                        <th scope="col" style="text-align: center">A點設備</th>--}}
{{--                        <th scope="col" style="text-align: center">B點設備</th>--}}
{{--                        <th scope="col" style="text-align: center">距離</th>--}}
{{--                        <th scope="col" style="text-align: center">限速</th>--}}
{{--                        <th scope="col" style="text-align: center">禁行車種</th>--}}
{{--                        <th scope="col" style="text-align: center">編輯區</th>--}}
{{--                    </tr>--}}
{{--                    </thead>--}}
{{--                    <tbody align="center">--}}
{{--                    </tbody>--}}
{{--                </table>--}}
{{--            </div>--}}
            {{--標籤--}}
            <ul class="nav nav-tabs">
                <li><a class="nav-link active" data-toggle="tab" href="#home" id="show_device"></span>設備管理</a></li>
                <li><a class="nav-link" data-toggle="tab" href="#group" id="group_device">設備群組管理</a></li>
            </ul>

            <div class="tab-content">
                {{--設備管理--}}
                <div id="home" class="tab-pane fade show active" style="padding: 20px 20px 20px 20px; background-color: white">
                    <table class="table tm-table-small">
                        <thead>
                        <tr>
                            <th scope="col" style="text-align: center">ID</th>
                            <th scope="col" style="text-align: center">地點名稱</th>
                            <th scope="col" style="text-align: center">GPS</th>
                            <th scope="col" style="text-align: center">所屬伺服器</th>
                            <th scope="col" style="text-align: center">所屬群組</th>
                            <th scope="col" style="text-align: center">編輯區</th>
                        </tr>
                        </thead>
                        <tbody>
                        <form action="{{route('device_D')}}" method="post" id="send_D_device">
                            @csrf
                            <input type="hidden" id="Device_ID_device_d" value="" name="ID">
                            <input type="hidden" type="submit"/>
                        </form>
                        @foreach($Devices as $d)
                            <tr>
                                <td style="vertical-align: middle;text-align: center" >{{$d['ID']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$d['Location']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$d['GPS']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$d['Server_ID']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$d['Device_Group_ID']}}</td>
                                <td style="vertical-align: middle;text-align: center">
                                    <button type="button" class="btn btn-primary4" data-toggle="modal" data-target="#update_device_modal" onclick="go_update_device('{{$d['ID']}}','{{$d['Location']}}','{{$d['GPS']}}','{{$d['Server_ID']}}','{{$d['Device_Group_ID']}}')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                    <button type="button" class="btn btn-primary3"  onclick="go_select('{{$d['ID']}}','D_Device')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                {{--設備群組--}}
                <div id="group" class="tab-pane fade" style="padding: 20px 20px 20px 20px; background-color: white">
                    <table class="table tm-table-small info" id="tb_Device_Group" border="1">
                        <thead>
                        <tr>
                            <th scope="col" style="text-align: center">No</th>
                            <th scope="col" style="text-align: center">群組名稱</th>
                            <th scope="col" style="text-align: center">A點設備</th>
                            <th scope="col" style="text-align: center">B點設備</th>
                            <th scope="col" style="text-align: center">距離</th>
                            <th scope="col" style="text-align: center">限速</th>
                            <th scope="col" style="text-align: center">禁行車種</th>
                            <th scope="col" style="text-align: center">編輯區</th>
                        </tr>
                        </thead>
                        <tbody align="center">
                        <form action="{{route('device_g_D')}}" method="post" id="send_D_device_g">
                            @csrf
                            <input type="hidden" id="Device_No_Group_d" value="" name="No">
                            <input type="hidden" type="submit"/>
                        </form>
                        @foreach($Groups as $g)
                            <tr>
                                <td style="vertical-align: middle;text-align: center" >{{$g['No']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$g['Group_Name']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$g['Point_A_Device']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$g['Point_B_Device']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$g['Distance']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$g['Speed_Limit']}}</td>
                                <td style="vertical-align: middle;text-align: center" >{{$g['Prohibited_Vehicles']}}</td>
                                <td style="vertical-align: middle;text-align: center">
                                    <button type="button" class="btn btn-primary4" data-toggle="modal" data-target="#update_device_g_modal" onclick="go_update_device_g('{{$g['No']}}','{{$g['Group_Name']}}','{{$g['Point_A_Device']}}','{{$g['Point_B_Device']}}','{{$g['Distance']}}','{{$g['Speed_Limit']}}','{{$g['Prohibited_Vehicles']}}')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                    <button type="button" class="btn btn-primary3"  onclick="go_select('{{$g['No']}}','D_Device_g')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <!-- Button trigger modal -->
                    <button style="width: 100%" type="button" class="btn btn-primary" data-toggle="modal" data-target="#create_device_g_modal">
                        + 新增設備群組
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- 設備查詢_Modal -->
    <div class="modal fade" id="device_r_Modal" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="updateModalLabel">設備查詢結果</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                {{--設備查詢結果--}}
                <div style="padding-top: 5px;display: none;padding-bottom: 20px" id="No_result_D">
                    <div style="width: 100%;text-align: center">
                        <h2 style="font-size: x-large;padding-top: 20px" class="tm-block-title">查無結果！！</h2>
                    </div>
                </div>
                <div style="padding-top: 5px;display: none;padding-bottom: 20px" id="Search_result">
                    <table class="table tm-table-small info" id="tb_Search_result" border="1">
                        <thead>
                        <tr>
                            <th scope="col" style="text-align: center">ID</th>
                            <th scope="col" style="text-align: center">地點名稱</th>
                            <th scope="col" style="text-align: center">GPS</th>
                            <th scope="col" style="text-align: center">所屬伺服器</th>
                            <th scope="col" style="text-align: center">所屬群組</th>
                            <th scope="col" style="text-align: center">編輯區</th>
                        </tr>
                        </thead>
                        <tbody align="center">
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">確認</button>
                    {{--                        <input type="submit" class="btn btn-primary"/>--}}
                </div>
                </form>
            </div>
        </div>
    </div>
    <!-- 設備群組查詢_Modal -->
    <div class="modal fade" id="device_group_r_Modal" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="updateModalLabel">設備群組查詢結果</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                {{--設備群組查詢結果--}}
                <div style="padding-top: 5px;display: none;padding-bottom: 20px" id="No_result_G">
                    <div style="width: 100%;text-align: center">
                        <h2 style="font-size: x-large;padding-top: 20px" class="tm-block-title">查無結果！！</h2>
                    </div>
                </div>
                <div style="padding-top: 5px;display: none;padding-bottom: 20px" id="Search_result_G">
                    <table class="table tm-table-small info" id="tb_Search_result_G" border="1">
                        <thead>
                        <tr>
                            <th scope="col" style="text-align: center">No</th>
                            <th scope="col" style="text-align: center">群組名稱</th>
                            <th scope="col" style="text-align: center">A點設備</th>
                            <th scope="col" style="text-align: center">B點設備</th>
                            <th scope="col" style="text-align: center">距離</th>
                            <th scope="col" style="text-align: center">限速</th>
                            <th scope="col" style="text-align: center">禁行車種</th>
                            <th scope="col" style="text-align: center">編輯區</th>
                        </tr>
                        </thead>
                        <tbody align="center">
                        </tbody>
                    </table>
                </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">確認</button>
{{--                        <input type="submit" class="btn btn-primary"/>--}}
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal 新增設備-->
    <div class="modal fade" id="create_device_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">新增設備</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{route('device_C')}}" id="send_C_device">
                    @csrf
                    <div class="modal-body">
                        <div style="padding: 20px 20px 20px 20px; background-color: white">
                            <table class="table tm-table-small" border="1">
                                <thead>
                                <th scope="col">新增設備</th>
                                <th scope="col"></th>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>ID</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="ID" required maxlength="20" autocomplete="off">
                                    </td>
                                </tr>
                                <tr>
                                    <td>地點名稱</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="Location" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>GPS</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="GPS" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>所屬伺服器</td>
                                    <td width=max>
                                        <input class="" type="number" style="width:80%;color: black" name="Server_ID" required>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <input type="submit" value="新增" class="btn btn-primary"/>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal 編輯設備-->
    <div class="modal fade" id="update_device_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" style="">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">編輯設備</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{route('device_U')}}" id="send_U_device">
                    @csrf
                    <div class="modal-body">
                        <div style="padding: 20px 20px 20px 20px; background-color: white">
                            <table class="table tm-table-small" border="1">
                                <thead>
                                <th scope="col">編輯設備</th>
                                <th scope="col"></th>
                                </thead>
                                <tbody>
                                <tr>
                                    <input class="" type="text" style="width:80%;color: black" id="Device_ID_device"name="ID" required hidden>
                                    <td>ID</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Device_ID2_device"name="ID2" required maxlength="20">
                                    </td>
                                </tr>
                                <tr>
                                    <td width=50%>地點名稱</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Device_Location_device"name="Location" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>GPS</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Device_GPS_device" name="GPS" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>所屬伺服器</td>
                                    <td width=max>
                                        <input class="" type="number" style="width:80%;color: black" id="Device_Server_ID_device" name="Server_ID" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>所屬群組</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Device_Device_Group_ID_device" name="Group_Detail" disabled>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <input type="submit" value="修改" class="btn btn-primary"/>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal 新增設備群組-->
    <div class="modal fade" id="create_device_g_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">新增設備群組</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{route('device_g_C')}}" id="send_C_group">
                    @csrf
                    <div class="modal-body">
                        <div style="padding: 20px 20px 20px 20px; background-color: white">
                            <table class="table tm-table-small" border="1">
                                <thead>
                                <th scope="col">新增設備群組</th>
                                <th scope="col"></th>
                                </thead>
                                <tbody>
                                <tr>
                                    <td width=50%>群組名稱</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="Group_Name" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>A點設備</td>
                                    <td width=max>
                                        <select  name="Point_A_Device">
                                            <option value="無">無</option>
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID == "無群組")
                                                    <option value="{{$device->ID}}">{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID != "無群組")
                                                    <option value="{{$device->ID}}" disabled>{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>B點設備</td>
                                    <td width=max>
                                        <select  name="Point_B_Device">
                                            <option value="無">無</option>
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID == "無群組")
                                                    <option value="{{$device->ID}}">{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID != "無群組")
                                                    <option value="{{$device->ID}}" disabled>{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>距離</td>
                                    <td width=max>
                                        <input class="" type="number" style="width:80%;color: black" name="Distance" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>限速</td>
                                    <td width=max>
                                        <input class="" type="number" style="width:80%;color: black" name="Speed_Limit" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>禁行車種</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" name="Prohibited_Vehicles" required>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <input type="submit" value="新增" class="btn btn-primary"/>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal 編輯設備群組-->
    <div class="modal fade" id="update_device_g_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" style="">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">編輯設備群組</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{route('device_g_U')}}" id="send_U_device_g">
                    @csrf
                    <div class="modal-body">
                        <div style="padding: 20px 20px 20px 20px; background-color: white">
                            <table class="table tm-table-small" border="1">
                                <thead>
                                <th scope="col">編輯設備群組</th>
                                <th scope="col"></th>
                                </thead>
                                <tbody>
                                <tr>
                                    <input class="" type="text" style="width:80%;color: black" id="Device_No_Group"name="No" hidden required>
                                    <td width=50%>群組名稱</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Device_Group_Name"name="Group_Name" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>A點設備</td>
                                    <td width=max>
                                        <select  name="Point_A_Device" id="Device_Point_A_Device">
                                            <option value="無">無</option>
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID == "無群組")
                                                    <option value="{{$device->ID}}">{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID != "無群組")
                                                    <option value="{{$device->ID}}" id="{{$device->ID}}_A" disabled>{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>B點設備</td>
                                    <td width=max>
                                        <select  name="Point_B_Device" id="Device_Point_B_Device">
                                            <option value="無">無</option>
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID == "無群組")
                                                    <option value="{{$device->ID}}">{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                            @foreach($Devices as $device)
                                                @if($device->Device_Group_ID != "無群組")
                                                    <option value="{{$device->ID}}" id="{{$device->ID}}_B" disabled>{{$device->ID}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>距離</td>
                                    <td width=max>
                                        <input class="" type="number" style="width:80%;color: black" id="Device_Distance_Group" name="Distance" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>限速</td>
                                    <td width=max>
                                        <input class="" type="number" style="width:80%;color: black" id="Device_Speed_Limit" name="Speed_Limit" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>禁行車種</td>
                                    <td width=max>
                                        <input class="" type="text" style="width:80%;color: black" id="Device_Prohibited_Vehicles" name="Prohibited_Vehicles" required>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <input type="submit" value="修改" class="btn btn-primary"/>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function check() {
            $("#tb_Search_result tr:not(:first)").empty("");
            var ID_R = document.getElementById("ID_R").value;
            var Location_R = document.getElementById("Location_R").value;
            var Server_ID_R = document.getElementById("Server_ID_R").value;
            var Group_R = document.getElementById("Group_R").value;
            var result;
            if (ID_R == Location_R && Location_R == Server_ID_R && Server_ID_R == "" && Group_R == ""){
                alert("查詢條件不可空白！！")
                return;
            }
            else {
                $("#send_R").submit();
                document.getElementById('show_result_d').click();
            }
        }
        function check_G() {
            $("#tb_Search_result_G tr:not(:first)").empty("");
            var Group_Name_R = document.getElementById("Group_Name_R").value;
            var Point_A_Device_R = document.getElementById("Point_A_Device_R").value;
            var Point_B_Device_R = document.getElementById("Point_B_Device_R").value;
            var Distance_R = document.getElementById("Distance_R").value;
            var Speed_Limit_R = document.getElementById("Speed_Limit_R").value;
            var Prohibited_Vehicles_R = document.getElementById("Prohibited_Vehicles_R").value;
            if (Group_Name_R == Point_A_Device_R && Point_A_Device_R == Point_B_Device_R && Point_B_Device_R == Distance_R
                && Distance_R == Speed_Limit_R && Speed_Limit_R == Prohibited_Vehicles_R && Prohibited_Vehicles_R == ""){
                alert("查詢條件不可空白！！")
                return;
            }
            else {
                $("#send_G_R").submit();
                document.getElementById('show_result_dg').click();
            }
        }
    </script>
    <script>
        $("#send_R").submit(function(e) {
            var form = $(this);
            var url = '{{route('device_R')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    //alert(data['error'])
                    if(data['error'] == "查無結果"){
                        document.getElementById("ID_R").value="";
                        document.getElementById("Location_R").value="";
                        document.getElementById("Server_ID_R").value="";
                        document.getElementById("Group_R").value="";
                        $('#Search_result').hide();
                        $('#No_result_D').show();
                        // alert('查無結果！！')
                    }else {
                        $.each(data, function(index, element) {
                            $('#tb_Search_result').append(
                                $('<tr></tr>').append(
                                    $('<td></td>',{text:element.ID}),
                                    $('<td></td>',{text:element.Location}),
                                    $('<td></td>',{text:element.GPS}),
                                    $('<td></td>',{text:element.Server_ID}),
                                    $('<td></td>',{text:element.Device_Group_ID}),
                                    $('<td>' +
                                        '<button class="btn btn-primary4" data-toggle="modal" data-target="#update_device_modal" onclick="go_update_device(\''+element.ID+'\',\''+element.Location+'\',\''+element.GPS+'\',\''+element.Server_ID+'\',\''+element.Device_Group_ID+'\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                        '<button class="btn btn-primary3"  onclick="go_select(\''+element.ID+'\',\'D_Device\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                        '</td>')
                                )
                            );
                        });
                        document.getElementById("ID_R").value="";
                        document.getElementById("Location_R").value="";
                        document.getElementById("Server_ID_R").value="";
                        document.getElementById("Group_R").value="";
                        $('#No_result_D').hide();
                        $('#Search_result').show();
                    }
                },
                error:function(data){
                    console.log(data);
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>
    <script>
        $("#send_G_R").submit(function(e) {
            var form = $(this);
            var url = '{{route('device_g_R')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    //alert(data['error'])
                    if(data['error'] == "查無結果"){
                        document.getElementById("Group_Name_R").value="";
                        document.getElementById("Point_A_Device_R").value="";
                        document.getElementById("Point_B_Device_R").value="";
                        document.getElementById("Distance_R").value="";
                        document.getElementById("Speed_Limit_R").value="";
                        document.getElementById("Prohibited_Vehicles_R").value="";
                        $('#Search_result_G').hide();
                        $('#No_result_G').show();
                        //alert('查無結果！！')
                    }else {
                        $.each(data, function(index, element) {
                            $('#tb_Search_result_G').append(
                                $('<tr></tr>').append(
                                    $('<td></td>',{text:element.No}),
                                    $('<td></td>',{text:element.Group_Name}),
                                    $('<td></td>',{text:element.Point_A_Device}),
                                    $('<td></td>',{text:element.Point_B_Device}),
                                    $('<td></td>',{text:element.Distance}),
                                    $('<td></td>',{text:element.Speed_Limit}),
                                    $('<td></td>',{text:element.Prohibited_Vehicles}),
                                    $('<td>' +
                                        '<button class="btn btn-primary4" data-toggle="modal" data-target="#update_device_g_modal" onclick="go_update_device_g(\''+element.No+'\',\''+element.Group_Name+'\',\''+element.Point_A_Device+'\',\''+element.Point_B_Device+'\',\''+element.Distance+'\',\''+element.Speed_Limit+'\',\''+element.Prohibited_Vehicles+'\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                        '<button class="btn btn-primary3"  onclick="go_select(\''+element.No+'\',\'D_Device_g\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                        '</td>')
                                )
                            );
                        });
                        document.getElementById("Group_Name_R").value="";
                        document.getElementById("Point_A_Device_R").value="";
                        document.getElementById("Point_B_Device_R").value="";
                        document.getElementById("Distance_R").value="";
                        document.getElementById("Speed_Limit_R").value="";
                        document.getElementById("Prohibited_Vehicles_R").value="";
                        $('#No_result_G').hide();
                        $('#Search_result_G').show();
                    }
                },
                error:function(data){
                    console.log(data);
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>
    <script>
        function go_select(name,type) {
            if (type=="D_Device"){
                var input_name=document.getElementById("Device_ID_device_d");
                input_name.value=name;
                $("#send_D_device").submit();
            }
            else if (type=="D_Device_g"){
                var input_name=document.getElementById("Device_No_Group_d");
                input_name.value=name;
                $("#send_D_device_g").submit();
            }
        }
    </script>
    <script>
        function go_update_device(ID,Location,GPS,Server_ID,Device_Group_ID) {
            var input_name=document.getElementById("Device_ID_device");
            input_name.value=ID;
            var input_name=document.getElementById("Device_ID2_device");
            input_name.value=ID;
            var input_name=document.getElementById("Device_Location_device");
            input_name.value=Location;
            var input_name=document.getElementById("Device_GPS_device");
            input_name.value=GPS;
            var input_name=document.getElementById("Device_Server_ID_device");
            input_name.value=Server_ID;
            var input_name=document.getElementById("Device_Device_Group_ID_device");
            input_name.value=Device_Group_ID;
        }
    </script>
    <script>
        function go_update_device_g(No,Group_Name,Point_A,Point_B,Distance,Speed,Vehicles) {
            var input_name=document.getElementById("Device_No_Group");
            input_name.value=No;
            var input_name=document.getElementById("Device_Group_Name");
            input_name.value=Group_Name;
            var input_name=document.getElementById("Device_Point_A_Device");
            if (Point_A == "無設備")
                input_name.value="無";
            else
                input_name.value=Point_A;
            var input_name=document.getElementById("Device_Point_B_Device");
            if (Point_B == "無設備")
                input_name.value="無";
            else
                input_name.value=Point_B;
            var input_name=document.getElementById("Device_Distance_Group");
            input_name.value=Distance;
            var input_name=document.getElementById("Device_Speed_Limit");
            input_name.value=Speed;
            var input_name=document.getElementById("Device_Prohibited_Vehicles");
            input_name.value=Vehicles;
            var Point_A_D = Point_A + "_A";
            var Point_B_D = Point_B + "_B";
            var input_name=document.getElementById(Point_A_D);
            input_name.disabled=false;
            var input_name=document.getElementById(Point_B_D);
            input_name.disabled=false;
        }
    </script>
    <script>
        @if(session('error'))
            alert('{{ session('error')}}')
        @endif
    </script>
{{$Devices}}
<br></br>
{{$Groups}}

@endsection
