@extends('layouts.default')
    @section('header')
    <link rel="stylesheet" href="{{asset('css/templatemo-style.css')}}">

    <!-- datetimepicker ---------------------------------------------- -->
    {{--    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>--}}
    <script type="text/javascript" src="{{asset('bower_components/moment/moment.js')}}"></script>
    <script type="text/javascript" src="{{asset('/bower_components/moment/locale/zh-tw.js')}}"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    @endsection
@section('content')
        <div class="container-fluid" style="height: auto;">
            <div class="tm-bg-light tm-block-taller "style="padding:20px;margin-bottom: 100px">
                <h2 style="font-size: x-large" class="tm-block-title">違規車輛查詢</h2>
                <form id="send_R" method="post" action="{{route('plates_R')}}">
                    @csrf
                    <div class="input-group mb-3" style="margin-top: 30px"> {{-- 搜尋條件 --}}
                        <input name="Plate_Number" style="width: 150px;margin-right: 10px"  class="inputText text-uppercase" type="text" placeholder="車牌號碼">
                        <button style="width: 110px;margin-right: 10px"  class="inputText text-lg-center" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">選擇時間</button>
                        <select name="Car_Type" style="width: auto;margin-right: 10px" class="inputText">
                            <option value="">--車種--</option>
                            <option value="大客車">大客車</option>
                            <option value="自小客車">自小客車</option>
                            <option value="重型機車">重型機車</option>
                            <option value="普通機車">普通機車</option>
                        </select>
                        <select name="Group_Name" style="width: auto;margin-right: 10px" class="inputText">
                            <option value="">--偵測地點--</option>
                            @foreach($Dgs as $dg)
                                <option value="{{$dg->Group_Name}}">{{$dg->Group_Name}}</option>
                            @endforeach
                        </select>
                        <select name="Violation" style="width: 180px;margin-right: 10px" class="inputText">
                            <option value="">--違規種類--</option>
                            <option value="超速">未依速限行駛</option>
                            <option value="禁行車種">禁行車種</option>
                        </select>
                        <select name="Status" style="width: 180px;margin-right: 10px" class="inputText">
                            <option value="">--案件狀態--</option>
                            <option value="待審核">待審核</option>
                            <option value="已告發">已告發</option>
                            <option value="已註銷">已註銷</option>
                        </select>
                        <div class="input-group-append">
                            <input name="Case_Number" style="width: 110px;" type="text" class="inputText text-uppercase" placeholder="違規案號">
                            <button type="button" class="btn-primary2 btn-primary" onclick="go_select()"></button>
                            <button type="button" class="btn-primary3 btn-primary" onclick="clearform()"></button>
                        </div>
                    </div>
                <div style="position: absolute;left: 15%;right: 15%;" class="collapse" id="collapseExample">   {{-- 時間選擇 --}}
                    <div class="card card-body" style="border: black;border-style: solid;width:40%;background-color: lightsteelblue">
                        <div class="form-group" style="margin-left: 2%" >
                            <h4 style="color: #9561e2;font-weight: 700">起</h4>
                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                <input id='start_time' style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group" style="margin-left: 2%">
                            <h4 style="color: #1d643b;font-weight: 700">訖</h4>
                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <input id='end_time' style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> {{-- 時間選擇 --}}
                </form>
                <table class="table tm-table-small table-hover">
                    <thead>
                    <tr style="text-align: center">
                        <th scope="col">編號</th>
                        <th scope="col">車牌號碼</th>
                        <th scope="col">車種</th>
                        <th scope="col">經過日期</th>
                        <th scope="col">時間</th>
                        <th scope="col">時速</th>
                        <th scope="col">偵測地點</th>
                        <th scope="col">限速</th>
                        <th scope="col">禁行車種</th>
                        <th scope="col">違規項目</th>
                        <th scope="col">違規案號</th>
                        <th scope="col">狀態</th>
                        <th scope="col" style="text-align: center">修改</th>
                    </tr>
                    </thead>
                    <tbody id="result">
                    <form action="{{route('plates_D')}}" method="post" id="send_D_alpr">
                        @csrf
                        <input type="hidden" id="Alpr_No_D" value="" name="No">
                        <input type="hidden" type="submit"/>
                    </form>
                    @php $count=0@endphp
                    @foreach($Alprs as $alpr)
                        @php $count+=1@endphp
                        <tr style="text-align: center" class="car_info{{$count}}">
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')">
                                <div class="tm-status-circle parking">
                                </div>{{$alpr->No}}
                            </td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b><a href="#photos"></a>{{$alpr->Plate_Number}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Car_Type}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{date_format(new DateTime($alpr->Point_A_Enter_DateTime),('Y-m-d'))}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{date_format(new DateTime($alpr->Point_A_Enter_DateTime),('h:i:s'))}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Speed}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Location}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Speed_Limit}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Prohibited_Vehicles}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Violation}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Case_Number}}</b></td>
                            <td onclick="toPhotos('{{asset($alpr->Point_A_Image_Path)}}','{{asset($alpr->Point_B_Image_Path)}}')"><b>{{$alpr->Status}}</b></td>
                            <td>
                                <button class="btn btn-primary4"  data-toggle="modal" data-target="#update_alpr_Modal" onclick="go_update('{{$alpr->No}}','{{$alpr->Plate_Number}}','{{$alpr->Status}}')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                                <button class="btn btn-primary3"  onclick="go_delete('{{$alpr->No}}')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"/>
                            </td>
                            <div class="screenshot" style="visibility: hidden" id='photo{{$count}}'>
                                <img style="float:left;max-width: 450px;height: auto" src="{{asset($alpr->Point_A_Image_Path)}}" />
                            </div>
                            <div class="screenshot" style="visibility: hidden" id='photo{{$count}}-1'>
                                <img style="float:left;max-width: 450px;height: auto" src="{{asset($alpr->Point_B_Image_Path)}}" />
                            </div>
                        </tr>
                    @endforeach
                    </tbody>
                </table>  {{-- 表身 --}}

                <hr style="margin: 0px;">       {{-- 分頁 --}}
                <div class="table d-flex justify-content-center pagination" style="height:70px;padding-top: 15px">
                    {{ $Alprs->links() }}
                </div> {{-- 表尾 --}}
            </div>
        </div>

    <div id="photos" style="display: none;text-align: center">
        <div style="padding:10px;background-color: #38c172">
            <button class="btn-primary3" style="float:right;" onclick="closePhotos()"></button>
            <h2 style="font-size: x-large" class="tm-block-title">經過偵測點影像</h2>
        </div>
        <div class="box1">
            <img id="image_A" style="height: auto" src=""  class="img-fluid" alt="Responsive image">
        </div>
        <div class="box1">
            <img id="image_B" style="height: auto" src=""  class="img-fluid" alt="Responsive image">
        </div>
    </div>

        <!-- Update_Modal -->
        <div class="modal fade" id="update_alpr_Modal" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="updateModalLabel">修改違規車輛資料</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="post" action="{{route('plates_U')}}" id="send_U_alpr">
                        @csrf
                        <div class="modal-body">
                            <div style="">
                                <table class="table">
                                    <tbody>
                                    <tr>
                                        <input class="" type="text" style="width:80%;color: black" id="Alpr_No_U" name="No" hidden required>
                                        <td>車牌號碼</td>
                                        <td width="max">
                                            <input class="" type="text" style="width:80%;color: black" id="Alpr_Plate_U" name="Plate_Number" required>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>案件進度</td>
                                        <td width="max">
                                            <select id="Alpr_Status_U" name="Status" required>
                                                <option value="待審核">待審核</option>
                                                <option value="已告發">已告發</option>
                                                <option value="已註銷">已註銷</option>
                                            </select>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                            <input type="submit" class="btn btn-primary"/>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    {{-- 送出表單 send_R --}}
    <script>
        function go_select() {
            if(document.getElementById("start_time").value=="" || document.getElementById("end_time").value==""){
                $("#collapseExample").collapse('show');
                alert('請選擇時間');
            }
            else
                $("#send_R").submit();
        }
    </script>
    {{-- 更改 send_U --}}
    <script>
        function go_update(No,Plate_Number,Status) {
            var input = document.getElementById('Alpr_No_U');
            input.value=No;
            var input = document.getElementById('Alpr_Plate_U');
            input.value=Plate_Number;
            var input = document.getElementById('Alpr_Status_U');
            input.value=Status;
        }
    </script>
    {{-- 刪除 send_D --}}
    <script>
        function go_delete(No) {
            var input = document.getElementById('Alpr_No_D');
            input.value=No;
            $("#send_D_alpr").submit();
        }
    </script>
    {{-- 下方顯示圖片區--}}
    <script>
        function toPhotos($img_A,$img_B){
            $('#photos').css("display","block");
            document.getElementById("image_A").setAttribute("src",$img_A);
            document.getElementById("image_B").setAttribute("src",$img_B);
            window.location.href="#photos"
        }
        function closePhotos(){
            $('#photos').css("display","none");
            window.location.href="#photos"
        }
    </script>

    {{--清空input--}}
    <script>
        function clearform() {
            document.getElementById("send_R").reset();
        }
    </script>

    <!-- 時間選擇器 -->
    <!-- datetimepicker1 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD HH:mm:ss ',
                weekStart: 1,
                autoclose: 0,
                todayHighlight: 1,
                // sideBySide:true,
                stepping:0,
                minView:0,
                maxView:0,
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>

    <!-- datetimepicker2 物件  -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD HH:mm:ss ',
                weekStart: 1,
                autoclose: 0,
                todayHighlight: 1,
                // sideBySide:true,
                stepping:0,
                minView:0,
                maxView:0,
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
    {{--    浮動照片--}}
    <script type="text/javascript">
    this.screenshotPreview=function(){
        xOffset = 10;
        yOffset = 30;
        $(".car_info1").hover(function(e){
                {{--var img='{{asset("/img/test_car.jpeg")}}';--}}
                // document.getElementById("fluid-photo").innerHTML+="<p id='screenshot'><img style=\"max-width: 500px;height: auto\" src='"+img+"' /></p>";
                $("#photo1")
                    .css("visibility","visible")
                    .css("top",(e.pageY - xOffset) + "px")
                    .css("left",(e.pageX + yOffset) + "px")
                    .fadeIn("fast");
                $("#photo1-1")
                    .css("visibility","visible")
                    .css("top",(e.pageY - xOffset) + "px")
                    .css("left",(e.pageX + yOffset) + "px")
                    .fadeIn("fast");
            },
            function(){
                $("#photo1").css("visibility","hidden");
                $("#photo1-1").css("visibility","hidden");
            });
        $(".car_info1").mousemove(function(e){
            $("#photo1")
                .css("top",(e.pageY-xOffset)+"px")
                .css("left",(e.pageX+yOffset)+"px");
            $("#photo1-1")
                .css("top",(e.pageY-xOffset)+"px")
                .css("left",(e.pageX+500)+"px");
        });
        @include('layouts.screenshotJS')
    };
    $(document).ready(function(){
        screenshotPreview();
    });
</script>
        {{$Alprs[0]}}
@endsection

