<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('plates');
});

/*----------------所有 Route 都要包在 log middleware 中，才會有紀錄log----------------*/
Route :: group (['middleware'=>['log']],function (){
    Route::get('login','Auth\LoginController@loginpage')->name('loginpage');
    Route::post('login','Auth\LoginController@login')->name('login');

    /*---------------------登入後可存取路徑-----------------------------------*/
    Route::group(['middleware' => ['auth:User']],function (){
        /*.........'middleware' => ['can:admin'] admin 可存取的頁面 .........*/
        Route::group(['middleware' => ['can:admin']],function(){
            /*---------------- 帳號管理 ----------------*/
            Route::group(['prefix' => 'admin/account'],function (){
                Route::get('', 'AccountController@show')->name('account');
                Route::post('create','AccountController@store')->name('acc_C');
                Route::post('select','AccountController@select')->name('acc_R');
                Route::post('update','AccountController@update')->name('acc_U');
                Route::post('delete','AccountController@delete')->name('acc_D');
                Route::post('select/where','AccountController@R2_user')->name('acc_R2');
                /*--------------- 帳號群組管理 ----------------*/
                Route::group(['prefix'=>'group'],function (){
                    Route::post('create','UserGroupController@store')->name('group_C');
                    Route::post('update','UserGroupController@update')->name('group_U');
                    Route::post('delete','UserGroupController@delete')->name('group_D');
                });
            });
        });
        /*................. 一般使用者可存取的頁面...............................*/
            Route::get('logout', 'Auth\LoginController@logout')->name('logout');

            /*--------------- 車輛查尋頁面 ---------------- */
            Route::group(['prefix' => 'plates' ],function () {
                Route::get('/','AlprController@index')->name('plates');
                Route::post('/select','AlprController@select')->name('plates_R');
                Route::post('/update','AlprController@update')->name('plates_U');
                Route::post('/delete','AlprController@delete')->name('plates_D');
            });

            /*--------------- 操作日誌頁面 ---------------- */
            Route::group(['prefix' => 'dashboard' ],function () {
                Route::get('/', 'InfluxdbController@dashboard_index')->name('dashboard');
                Route::post('select','InfluxdbController@Log_select')->name('dash_R');
            });

            /*--------------- 設備管理 ---------------- */
            Route::group(['prefix' => 'device' ],function () {
                Route::get('/', 'DeviceController@index')->name('device');
                Route::post('create','DeviceController@store')->name('device_C');
                Route::post('select','DeviceController@select')->name('device_R');
                Route::post('update','DeviceController@update')->name('device_U');
                Route::post('delete','DeviceController@delete')->name('device_D');
            });
            Route::group(['prefix' => 'device/group' ],function () {
                Route::post('create','DeviceGroupController@store')->name('device_g_C');
                Route::post('select','DeviceGroupController@select')->name('device_g_R');
                Route::post('update','DeviceGroupController@update')->name('device_g_U');
                Route::post('delete','DeviceGroupController@delete')->name('device_g_D');
            });
    });
});

