<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Device_Group;
use App\Device;

class DeviceGroupController extends Controller
{
    //
    public function store(Request $request){
        //新增一群組設備
        $group=new Device_Group;
        $group->Group_Name=$request->Group_Name;
        if ($request->Point_A_Device==$request->Point_B_Device && $request->Point_A_Device != "無"){
            $erro_meg="A、B兩點設備不可相同";
            return back()->withError($erro_meg)->withInput();
        }
        $group->Point_A_Device=$request->Point_A_Device == "無" ? null : $request->Point_A_Device;
        $group->Point_B_Device=$request->Point_B_Device == "無" ? null : $request->Point_B_Device;
        $group->Distance=$request->Distance;
        $group->Speed_Limit=$request->Speed_Limit;
        $group->Prohibited_Vehicles=$request->Prohibited_Vehicles;

        try{
            $group->save();
            $group_id=$group->get();
            $group_id=$group_id[count($group_id)-1]["No"];
            $device=Device ::where("ID",$request->Point_A_Device == "無" ? null : $request->Point_A_Device);
            $device->update(["Device_Group_ID"=>$group_id]);
            $device=Device ::where("ID",$request->Point_B_Device == "無" ? null : $request->Point_B_Device);
            $device->update(["Device_Group_ID"=>$group_id]);
        }
        catch (\Illuminate\Database\QueryException $e){
            $erro_meg="設備群組名稱已重複";
//            $e->getMessage(); //真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('device');
    }
    public function select(Request $request){
        $group=Device_Group::all();
        if ($request->Group_Name != null){
            $group=$group->where('Group_Name',$request->Group_Name);
        }
        if ($request->Point_A_Device != null){
            $group=$group->where('Point_A_Device',$request->Point_A_Device == "無" ? null : $request->Point_A_Device);
        }
        if ($request->Point_B_Device != null){
            $group=$group->where('Point_B_Device',$request->Point_B_Device =="無" ? null : $request->Point_B_Device);
        }
        if ($request->Distance != null){
            $group=$group->where('Distance',$request->Distance);
        }
        if ($request->Speed_Limit != null){
            $group=$group->where('Speed_Limit',$request->Speed_Limit);
        }
        if ($request->Prohibited_Vehicles != null){
            $group=$group->where('Prohibited_Vehicles',$request->Prohibited_Vehicles);
        }
        if($group->isEmpty()){
            $meg = array("error"=>"查無結果");
            $meg = json_encode($meg);
            return $meg;
        }
        foreach ($group as $gp){
            $gp["Point_A_Device"]=$gp["Point_A_Device"]== null ? "無設備" :$gp["Point_A_Device"];
            $gp["Point_B_Device"]=$gp["Point_B_Device"]== null ? "無設備" :$gp["Point_B_Device"];
        }

        return $group;
    }
    public function update(Request $request){
        // 修改資料
        $group = Device_Group::where('No',$request->No);
        if ($request->Point_A_Device==$request->Point_B_Device && $request->Point_A_Device != "無" && $request->Point_A_Device !=null){
            $erro_meg="A、B兩點設備不可相同";
            return back()->withError($erro_meg)->withInput();
        }

        $pa=$group->get()[0]["Point_A_Device"];
        $pb=$group->get()[0]["Point_B_Device"];

        try {
            $group->update([
                'Group_Name' => $request->Group_Name,
                'Point_A_Device' => $request->Point_A_Device == "無" ? null : $request->Point_A_Device,
                'Point_B_Device' => $request->Point_B_Device == "無" ? null : $request->Point_B_Device,
                'Distance'=>$request->Distance,
                'Speed_Limit'=>$request->Speed_Limit,
                'Prohibited_Vehicles'=>$request->Prohibited_Vehicles,
            ]);
            $group=$group->get();
            $group_id=$group[0]["No"];
            $group_a=$group[0]["Point_A_Device"];
            $group_b=$group[0]["Point_B_Device"];

            if ($group_a != $pa){
                $device=Device ::where("ID",$pa);
                $device->update(["Device_Group_ID"=>null]);

                $device=Device ::where("ID",$group_a);
                $device->update(["Device_Group_ID"=>$group_id]);
            }

            if ($group_b != $pb){
                $device=Device ::where("ID",$pb);
                $device->update(["Device_Group_ID"=>null]);

                $device=Device ::where("ID",$group_b);
                $device->update(["Device_Group_ID"=>$group_id]);
            }
        }
        catch (Exception $e){
            $erro_meg="修改失敗";
            //$e->getMessage(); 真正錯誤原因
            return back()->withError($erro_meg)->withInput();
        }
        return redirect()->route('device');
    }
    public function delete(Request $request){
        // 刪除設備
        $groups = Device_Group::where('No',$request->No);
        $group=$groups->get();
        $device=Device :: where("ID",$group[0]["Point_A_Device"]);
        $device->update(["Device_Group_ID"=>null]);
        $device=Device :: where("ID",$group[0]["Point_B_Device"]);
        $device->update(["Device_Group_ID"=>null]);

        $groups->delete();

        return redirect()->route('device');
    }

}
