<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeviceGroupTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('Device_Group', function (Blueprint $table) {
            $table->bigIncrements('No');
            $table->string("Group_Name")->unique();
            $table->string("Point_A_Device",20)->nullable();
            $table->string("Point_B_Device",20)->nullable();
            $table->float("Distance");
            $table->integer("Speed_Limit");
            $table->string("Prohibited_Vehicles");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('Device_Group');
    }
}
