@extends('layouts.default')
@section('header')
    <link rel="stylesheet" href="{{asset('css/templatemo-style.css')}}">
    <!-- Chart.js v2.8.0 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js"></script>
    <!-- Include Bootstrap Datepicker -->
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

@endsection
@section('content')
    <style>
        #chart_wrapper{
            position  : static;
            width     : 100%;
            height    : 100%;
            text-align: center;
        }
    </style>
    <div class="container-fluid">
        <div class="tm-bg-light tm-block-taller "style="padding:20px;margin-bottom: 100px">
            <h2 style="font-size: x-large" class="tm-block-title">操作日誌</h2>
            <div>
                <form method="post" action="{{route('dash_R')}}" id="send_R">
                    @csrf
                    <label style="font-size: large" class="tm-block-title">使用者：</label>
                    <select class="form-control-lg" id="chosen" name="name" style="font-size:16px;">
                        <option value="all">所有使用者</option>
                        @foreach($Users as $user)
                            <option value="{{$user->name}}">{{$user->name}}</option>
                        @endforeach
                    </select>
                    <label style="font-size: large;margin-left: 10px" class="tm-block-title">操作：</label>
                    <select class="form-control-lg" id="page" name="page" style="font-size:16px;">
                        <option value="all">所有操作</option>
                        @foreach($Pages as $page)
                            <option value="{{$page->Route}}">{{$page->Page_Name}}</option>
                        @endforeach
                    </select>
                    <label style="font-size: large;margin-left: 30px" class="tm-block-title" >時間範圍：</label>
                    <input type="text" id="dateStart" name="dateS" style="text-align: center" autocomplete="off">
                    <label style="font-size: large" class="tm-block-title">　至　</label>
                    <input type="text" id="dateEnd" name="dateE" style="text-align: center" autocomplete="off">
                    <button class="btn-sm btn-primary" type="button" style="margin-left: 30px" onclick="check()">查詢</button>
                </form>
            </div>
            {{--查詢--}}
            <div class="tab-content">
                <div id="home" class="tab-pane fade show active" style="padding: 20px 20px 20px 20px; background-color: white">
                    <table class="table tm-table-small" id="tb_Search_result">
                        <thead align="center">
                            <th>操作時間</th>
                            <th>操作頁面</th>
                            <th>操作人員</th>
                            <th>IP</th>
                            <th>日誌詳情</th>
                        </thead>
                        <tbody align="center">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="tab-content" style="padding-top: 30px">
                <table style="width: 100%;height: 500px;" border="0">
                    <tr>
{{--                        rgb(20,22,25)--}}
                        <td style="width: 85%;text-align: center;vertical-align: middle;background-color:rgb(20,22,25)">
                            <div id="chart_wrapper">
                                <canvas id="myChart"></canvas>
                            </div>
                        </td>
                        <td style="width: 15%;background-color: rgb(20,22,25);text-align: center;">
                            <button class="btn btn-primary" id="website_all">網站統計數據</button>
                            <button class="btn btn-primary" id="admin_acc">帳號管理</button>
                            <button class="btn btn-primary" id="group">帳號群組管理</button>
                            <button class="btn btn-primary" id="plates">車輛查詢</button>
                            <button class="btn btn-primary" id="device">設備管理</button>
                            <button class="btn btn-primary" id="device_group">設備群組管理</button>
                            <button class="btn btn-primary" id="login">登錄</button>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <input type="hidden" id="0" value="hello">
    {{--Modal Log_detail--}}
    <div class="modal fade" id="show_detail_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">日誌詳情</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="show_detail_f">
                    <div class="modal-body">
                        <div style="padding: 20px 20px 20px 20px; background-color: white">
{{--                            <label id="lab_show"></label>--}}
                            <textarea id="lab_show" wrap=true readonly style="width: 100%;height: 250px"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">確定</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- datepicker 設定-->
    <script>
        $(function() {
            $("#dateStart").datepicker({
                changeYear : true,
                changeMonth : true,
                numberOfMonths : 1,
                dateFormat: 'yy-mm-dd',
                maxDate: new Date(),
                onSelect : function(selectedDate) {
                    $("#dateEnd").datepicker("option", "minDate", selectedDate);  }
            });
            $("#dateEnd").datepicker({
                changeYear : true,
                changeMonth : true,
                numberOfMonths : 1,
                dateFormat: 'yy-mm-dd',
                maxDate: new Date(),
                onSelect : function(selectedDate) {
                    $("#dateStart").datepicker("option", "maxDate", selectedDate);  }
            });
        });
    </script>
    <!-- datepicker 改為中文-->
    <script>
        $(function() {
            ( function( factory ) {
                if ( typeof define === "function" && define.amd ) {
    // AMD. Register as an anonymous module.
                    define( [ "../widgets/datepicker" ], factory );
                } else {
    // Browser globals
                    factory( jQuery.datepicker );
                }
            }( function( datepicker ) {
                datepicker.regional[ "zh-TW" ] = {
                    closeText: "關閉",
                    prevText: "&#x3C;上個月",
                    nextText: "下個月&#x3E;",
                    currentText: "今天",
                    monthNames: [ "一月","二月","三月","四月","五月","六月",
                        "七月","八月","九月","十月","十一月","十二月" ],
                    monthNamesShort: [ "一月","二月","三月","四月","五月","六月",
                        "七月","八月","九月","十月","十一月","十二月" ],
                    dayNames: [ "星期日","星期一","星期二","星期三","星期四","星期五","星期六" ],
                    dayNamesShort: [ "週日","週一","週二","週三","週四","週五","週六" ],
                    dayNamesMin: [ "日","一","二","三","四","五","六" ],
                    weekHeader: "週",
                    dateFormat: "yy-mm-dd",
                    firstDay: 1,
                    isRTL: false,
                    showMonthAfterYear: true,
                    yearSuffix: "年" };
                datepicker.setDefaults( datepicker.regional[ "zh-TW" ] );
                return datepicker.regional[ "zh-TW" ];
            } ) );
        });
    </script>
    <!-- Chart.js -->
    <script>
        var dd = new Date();
        var months = "1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月".split(",");
        var date = (new Date(dd.getFullYear(),dd.getMonth(),0).getDate());
        var data_label = new Array(date);
        for( i = 1;i <= date;i++)
        {
            var str_year = dd.getFullYear().toString();
            var str_full_date = i.toString().concat('日');
            data_label[i-1]=str_full_date;
        }
        var config = {
            type: 'line',
            data: {
                // 要呈現的資料
                labels: data_label,  // 水平軸
                datasets: [
                    {
                        label: 'dashboard',  // 資料的標題標籤
                        pointHoverRadius:10,
                        backgroundColor:'rgba(255,99,132,1)',
                        borderColor: 'rgba(255,99,132,1)',
                        data: [],
                        fill: false,
                        pointBorderWidth: 0,
                        pointRadius:4,
                    },
                ]
            },
            options: {
                // 自訂屬性設定
                title: {
                    display: true,
                    text: '網站統計圖表',
                    fontColor: 'rgba(255,255,250,1)',
                    fontSize: '24',
                    position: 'top',  // 標題位置
                },
                legend: {  // 資料標籤的位置
                    display: true,
                    position: 'bottom',
                    labels: {
                        fontColor: '#FFF',
                        fontSize: 16,
                    },
                },
                scales: {
                    xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: '日期',
                            fontColor: '#FFF',
                            fontSize: 16,
                        },
                        gridLines:{
                            display: true,
                            color: 'rgba(44,45,48,1)'
                        },
                        ticks:{
                            fontColor: '#FFF',
                            fontSize: 16,
                        }
                    }],
                    yAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: '人數',
                            fontColor: '#FFF',
                            fontSize: 16,
                        },
                        ticks:{
                            min: 0,
                            sampleSize: 1,
                            fontColor: '#FFF',
                            fontSize: 16,
                        },
                        gridLines:{
                            display: true,
                            color: 'rgba(44,45,48,1)'
                        },
                    }]
                },
                // scales: {  // 縮放屬性
                //     yAxes: [{  // 設定垂直軸 [使用陣列方式]
                //         //type: 'line', // this is the same key that was passed to the registerScaleType function
                //         ticks: {  // 設定間隔數值
                //             // 固定數值
                //             min: 0,  // 最小是 0
                //             max: 100,
                //
                //             // 建議數值
                //             suggestedMin: 0,
                //             suggestedMax: 2000,
                //
                //             // 值間隔
                //             stepSize: 5,
                //
                //             // 增加數值文字
                //             callback: function (value, index, values) {
                //                 return value + '萬顆';
                //             }
                //         }
                //     }]
                // },
                animation: {
                    duration: 1000,
                    easing: 'easeOutQuart'
                }
            }
        };

        window.onload = function () {
            $("#home").hide();
            var ctx = document.getElementById('myChart').getContext('2d');
            Window.myChart = new Chart(ctx, config);
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '帳號管理';
                dataset.data = count_acc();
            });
            var G_Dataset = {
                label: '群組管理',
                backgroundColor:'rgba(70,99,200,1)',
                borderColor: 'rgba(70,99,200,1)',
                data: count_group(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var L_Dataset = {
                label: '登錄',
                backgroundColor:'rgba(255,236,139,1)',
                borderColor: 'rgba(255,236,139,1)',
                data: count_login(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var P_Dataset = {
                label: '車輛查詢',
                backgroundColor:'rgba(0,236,139,1)',
                borderColor: 'rgba(0,236,139,1)',
                data: count_plate(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var Device_Dataset = {
                label: '設備管理',
                backgroundColor:'rgba(228,112,214,1)',
                borderColor: 'rgba(228,112,214,1)',
                data: count_device(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var Device_group_Dataset = {
                label: '設備群組',
                backgroundColor:'rgba(255,228,196,1)',
                borderColor: 'rgba(255,228,196,1)',
                data: count_device_group(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            config.data.datasets.push(G_Dataset);
            config.data.datasets.push(P_Dataset);
            config.data.datasets.push(Device_Dataset);
            config.data.datasets.push(Device_group_Dataset);
            config.data.datasets.push(L_Dataset);
            Window.myChart.update();
        };
        document.getElementById('admin_acc').addEventListener('click',function () {
            var datsets = data_acc_d();
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '新增帳號';
                dataset.data = datsets[0];
                dataset.backgroundColor = 'rgba(255,99,132,1)',
                dataset.borderColor = 'rgba(255,99,132,1)'
            });
            var U_Dataset = {
                label: '修改帳號',
                backgroundColor:'rgba(67,205,128,1)',
                borderColor: 'rgba(67,205,128,1)',
                data: datsets[1],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var D_Dataset = {
                label: '刪除帳號',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[2],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            var R_Dataset = {
                label: '查詢帳號',
                backgroundColor:'rgba(255,215,0,1)',
                borderColor: 'rgba(255,215,0,1)',
                data: datsets[3],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            config.data.datasets.push(U_Dataset);
            config.data.datasets.push(D_Dataset);
            config.data.datasets.push(R_Dataset);
            config.options.title.text ='帳號管理統計圖表';
            Window.myChart.update();
        })
        document.getElementById('group').addEventListener('click',function () {
            var datsets = data_group_d();
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '新增群組';
                dataset.data = datsets[0];
                dataset.backgroundColor = 'rgba(70,99,200,1)',
                dataset.borderColor = 'rgba(70,99,200,1)'
            });
            var U_Dataset = {
                label: '修改群組',
                backgroundColor:'rgba(67,205,128,1)',
                borderColor: 'rgba(67,205,128,1)',
                data: datsets[1],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var D_Dataset = {
                label: '刪除群組',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[2],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            config.data.datasets.push(U_Dataset);
            config.data.datasets.push(D_Dataset);
            config.options.title.text ='群組管理頁面統計圖表';
            Window.myChart.update();
        })
        document.getElementById('website_all').addEventListener('click',function () {
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '帳號管理';
                dataset.data = count_acc();
                dataset.backgroundColor = 'rgba(255,99,132,1)',
                dataset.borderColor = 'rgba(255,99,132,1)'
            });
            var newDataset = {
                label: '群組管理',
                backgroundColor:'rgba(70,99,200,1)',
                borderColor: 'rgba(70,99,200,1)',
                data: count_group(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var L_Dataset = {
                label: '登錄',
                backgroundColor:'rgba(255,236,139,1)',
                borderColor: 'rgba(255,236,139,1)',
                data: count_login(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var P_Dataset = {
                label: '車輛查詢',
                backgroundColor:'rgba(0,236,139,1)',
                borderColor: 'rgba(0,236,139,1)',
                data: count_login(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var Device_Dataset = {
                label: '設備管理',
                backgroundColor:'rgba(228,112,214,1)',
                borderColor: 'rgba(228,112,214,1)',
                data: count_device(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var Device_group_Dataset = {
                label: '設備群組',
                backgroundColor:'rgba(255,228,196,1)',
                borderColor: 'rgba(255,228,196,1)',
                data: count_device_group(),
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            config.data.datasets.push(newDataset);
            config.data.datasets.push(P_Dataset);
            config.data.datasets.push(Device_Dataset);
            config.data.datasets.push(Device_group_Dataset);
            config.data.datasets.push(L_Dataset);
            config.options.title.text ='網站統計圖表';
            Window.myChart.update();
        })
        document.getElementById('login').addEventListener('click',function () {
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '登錄';
                dataset.data = count_login();
                dataset.backgroundColor = 'rgba(255,236,139,1)',
                dataset.borderColor = 'rgba(255,236,139,1)'
            });
            config.options.title.text ='登錄頁面統計圖表';
            Window.myChart.update();
        })
        document.getElementById('plates').addEventListener('click',function () {
            var datsets = data_plate_d();
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '修改車輛';
                dataset.data = datsets[0];
                dataset.backgroundColor = 'rgba(70,99,200,1)',
                    dataset.borderColor = 'rgba(70,99,200,1)'
            });
            var D_Dataset = {
                label: '刪除車輛',
                backgroundColor:'rgba(67,205,128,1)',
                borderColor: 'rgba(67,205,128,1)',
                data: datsets[1],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var R_Dataset = {
                label: '查詢車輛',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[2],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            config.data.datasets.push(D_Dataset);
            config.data.datasets.push(R_Dataset);
            config.options.title.text ='車輛查詢頁面統計圖表';
            Window.myChart.update();
        })
        document.getElementById('device').addEventListener('click',function () {
            var datsets = data_device_d();
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '新增設備';
                dataset.data = datsets[0];
                dataset.backgroundColor = 'rgba(70,99,200,1)',
                    dataset.borderColor = 'rgba(70,99,200,1)'
            });
            var U_Dataset = {
                label: '修改設備',
                backgroundColor:'rgba(67,205,128,1)',
                borderColor: 'rgba(67,205,128,1)',
                data: datsets[1],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var D_Dataset = {
                label: '刪除設備',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[2],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            var S_Dataset={
                label: '查詢設備',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[3],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            config.data.datasets.push(U_Dataset);
            config.data.datasets.push(D_Dataset);
            config.data.datasets.push(S_Dataset);
            config.options.title.text ='群組管理頁面統計圖表';
            Window.myChart.update();
        })
        document.getElementById('device_group').addEventListener('click',function () {
            var datsets = data_device_group_d();
            while( config.data.datasets.length != 1){
                config.data.datasets.splice(config.data.datasets.length-1, 1);
            }
            config.data.datasets.forEach(function(dataset) {
                dataset.label = '新增設備群組';
                dataset.data = datsets[0];
                dataset.backgroundColor = 'rgba(70,99,200,1)',
                    dataset.borderColor = 'rgba(70,99,200,1)'
            });
            var U_Dataset = {
                label: '修改設備群組',
                backgroundColor:'rgba(67,205,128,1)',
                borderColor: 'rgba(67,205,128,1)',
                data: datsets[1],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            };
            var D_Dataset = {
                label: '刪除設備群組',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[2],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            var S_Dataset={
                label: '查詢設備群組',
                backgroundColor:'rgba(238,220,130,1)',
                borderColor: 'rgba(238,220,130,1)',
                data: datsets[2],
                fill: false,
                pointBorderWidth: 0,
                pointRadius:4,
                pointHoverRadius:10,
            }
            config.data.datasets.push(U_Dataset);
            config.data.datasets.push(D_Dataset);
            config.data.datasets.push(S_Dataset);
            config.options.title.text ='群組管理頁面統計圖表';
            Window.myChart.update();
        })
    </script>
    <script>
        function full_date() {
            var dd = new Date();
            var months = "1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月".split(",");
            var month = months[dd.getMonth()];
            var str_full_date = str_year.concat('年',month);
            return str_full_date;
        }
    </script>
    <!-- Chart.js 計算頁面操作次數-->
    <script>
        function count_acc() {
            var data_acc = [] ;
            var all = 0;
            var times = 0
            var dd = new Date();
            var month = dd.getMonth()+1;
            var date=new Date(dd.getFullYear(),dd.getMonth(),0);
            var days=date.getDate();
            var number = 0;
            @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["帳號管理"] as $log) //CRUD
                    @foreach($log as $lo)
                        @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                            all = all +1;
                        @endif
                    @endforeach
                @endforeach
                if(all != 0){
                    data_acc[number] = all;
                }
                number++;
                all = 0;
            }
            @endfor
            return data_acc;
        }
        function count_login() {
            var data_login = [] ;
            var all = 0;
            var times = 0
            var dd = new Date();
            var month = dd.getMonth()+1;
            var date=new Date(dd.getFullYear(),dd.getMonth(),0);
            var days=date.getDate();
            var number = 0;
            @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["登錄"] as $log)
                    @if(substr($log['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                        all = all +1;
                    @endif
                @endforeach
                if(all != 0){
                    data_login[number] = all;
                }
                number++;
                all = 0;
            }
            @endfor
            return data_login;
        }
        function count_group() {
            var data_group = [] ;
            var all = 0;
            var times = 0
            var dd = new Date();
            var month = dd.getMonth()+1;
            var date=new Date(dd.getFullYear(),dd.getMonth(),0);
            var days=date.getDate();
            var number=0;
            ckc_month = month.toString();
            @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["群組管理"] as $log) //CRUD
                    @foreach($log as $lo)
                        @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                            all = all +1;
                        @endif
                    @endforeach
                @endforeach
                if(all!=0){
                    data_group[number] = all;
                }
                number++;
                all = 0;
            }
            @endfor
            return data_group;
        }
        function count_device() {
            var data_device = [] ;
            var all = 0;
            var number=0;
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["設備管理"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                    @endforeach
                if(all!=0){
                    data_device[number] = all;
                }
                number++;
                all = 0;
            }
            @endfor
                return data_device;
        }
        function count_device_group() {
            var data_device = [] ;
            var all = 0;
            var number=0;
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["設備群組"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                    @endforeach
                if(all!=0){
                    data_device[number] = all;
                }
                number++;
                all = 0;
            }
            @endfor
                return data_device;
        }
        function count_plate() {
            var data_plate = [] ;
            var all = 0;
            var number=0;
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["車輛查詢"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                    @endforeach
                if(all!=0){
                    data_plate[number] = all;
                }
                number++;
                all = 0;
            }
            @endfor
                return data_plate;
        }
        function data_group_d(){
            var all = 0;
            var times = 1;
            var number = 0;
            var create = 0;
            var read = 0;
            var update = 0;
            var del = 0;
            var data_C = [],data_U = [],data_D = [];
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["群組管理"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                if (times == 1)
                    create = all;
                if (times == 2)
                    update = all;
                if (times == 3)
                    del = all;
                times ++;
                all = 0;
                @endforeach
                if (create != 0){
                    data_C[number]=create;
                    create = 0;
                }
                if (del != 0){
                    data_D[number]=del;
                    del = 0;
                }
                if (update != 0){
                    data_U[number]=update;
                    update = 0;
                }
                times = 1;
                number++;
            }
            @endfor
            var datasets = [data_C,data_U,data_D];
            return datasets;
        }
        function data_acc_d(){
            var all = 0;
            var times = 1;
            var number = 0;
            var create = 0;
            var read = 0;
            var update = 0;
            var del = 0;
            var data_C = [],data_U = [],data_D = [],data_R = [];
                @for($i=0; $i<date('t');$i++ ){
                    @foreach($Logs["帳號管理"] as $log) //CRUD
                        @foreach($log as $lo)
                            @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                                all = all +1;
                            @endif
                        @endforeach
                        if (times == 1)
                            create = all;
                        if (times == 2)
                            update = all;
                        if (times == 3)
                            del = all;
                        if (times == 4)
                            read = all;
                        times ++;
                        all = 0;
                    @endforeach
                if (create != 0){
                    data_C[number]=create;
                    create = 0;
                }
                if (del != 0){
                    data_D[number]=del;
                    del = 0;
                }
                if (update != 0){
                    data_U[number]=update;
                    update = 0;
                }
                if (read != 0){
                    data_R[number]=read;
                    read = 0;
                }
                times = 1;
                number++;
            }
            @endfor
            var datasets = [data_C,data_U,data_D,data_R];
            return datasets;
        }
        function data_plate_d(){
            var all = 0;
            var times = 1;
            var number = 0;
            var create = 0;
            var read = 0;
            var update = 0;
            var del = 0;
            var data_U = [],data_D = [],data_R = [];
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["車輛查詢"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                if (times == 1)
                    read = all;
                if (times == 2)
                    update = all;
                if (times == 3)
                    del = all;
                times ++;
                all = 0;
                @endforeach
                if (del != 0){
                    data_D[number]=del;
                    del = 0;
                }
                if (update != 0){
                    data_U[number]=update;
                    update = 0;
                }
                if (read != 0){
                    data_R[number]=read;
                    read = 0;
                }
                times = 1;
                number++;
            }
                @endfor
            var datasets = [data_U,data_D,data_R];
            return datasets;
        }
        function data_device_d(){
            var all = 0;
            var times = 1;
            var number = 0;
            var create = 0;
            var read = 0;
            var update = 0;
            var del = 0;
            var data_C = [],data_U = [],data_D = [],data_R = [];
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["設備管理"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                if (times == 1)
                    create = all;
                if (times == 2)
                    update = all;
                if (times == 3)
                    del = all;
                if (times == 4)
                    read = all;
                times ++;
                all = 0;
                @endforeach
                if (create != 0){
                    data_C[number]=create;
                    create = 0;
                }
                if (del != 0){
                    data_D[number]=del;
                    del = 0;
                }
                if (update != 0){
                    data_U[number]=update;
                    update = 0;
                }
                if (read != 0){
                    data_R[number]=read;
                    read = 0;
                }
                times = 1;
                number++;
            }
                @endfor
            var datasets = [data_C,data_U,data_D,data_R];
            return datasets;
        }
        function data_device_group_d(){
            var all = 0;
            var times = 1;
            var number = 0;
            var create = 0;
            var read = 0;
            var update = 0;
            var del = 0;
            var data_C = [],data_U = [],data_D = [],data_R = [];
                @for($i=0; $i<date('t');$i++ ){
                @foreach($Logs["設備群組"] as $log) //CRUD
                @foreach($log as $lo)
                    @if(substr($lo['time'],5,5) == date('m')."-".str_pad((string)($i+1),2,"0",STR_PAD_LEFT))
                    all = all +1;
                @endif
                    @endforeach
                if (times == 1)
                    create = all;
                if (times == 2)
                    update = all;
                if (times == 3)
                    del = all;
                if (times == 4)
                    read = all;
                times ++;
                all = 0;
                @endforeach
                if (create != 0){
                    data_C[number]=create;
                    create = 0;
                }
                if (del != 0){
                    data_D[number]=del;
                    del = 0;
                }
                if (update != 0){
                    data_U[number]=update;
                    update = 0;
                }
                if (read != 0){
                    data_R[number]=read;
                    read = 0;
                }
                times = 1;
                number++;
            }
                @endfor
            var datasets = [data_C,data_U,data_D,data_R];
            return datasets;
        }
    </script>
    <!-- 查詢 -->
    <script>
        function show_detail(detail) {
            document.getElementById("lab_show").innerHTML=unescape(detail);
        }
    </script>
    <script>
        function check() {
            $("#tb_Search_result tr:not(:first)").empty("");
            var name_R = document.getElementById("chosen").value;
            var date_start_R = document.getElementById("dateStart").value;
            var date_end_R = document.getElementById("dateEnd").value;
            var result;
            if (date_start_R == "" && date_end_R != ""){
                alert("請選取時間範圍！！")
                return;
            }
            if (date_start_R != "" && date_end_R == ""){
                alert("請選取時間範圍！！")
                return;
            }
            else {
                $("#send_R").submit();
            }
        }
    </script>
    <script>
        $("#send_R").submit(function(e) {
            var form = $(this);
            var url = '{{route('dash_R')}}';
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    //alert(data['error'])
                    if(data['error'] == "查無結果"){
                        document.getElementById("page").value="all";
                        document.getElementById("chosen").value="all";
                        document.getElementById("dateEnd").value="";
                        document.getElementById("dateStart").value="";
                        alert('查無結果！！')
                    }else {
                        $.each(data, function(index, element) {
                            $('#tb_Search_result').append(
                                $('<tr></tr>').append(
                                    $('<td></td>',{text:element.time}),
                                    $('<td></td>',{text:element.Operate_Page}),
                                    $('<td></td>',{text:element.Operator}),
                                    $('<td></td>',{text:element.IP}),
                                    $('<td><button class="btn btn-primary" type="button" data-toggle="modal" data-target="#show_detail_modal" onclick="show_detail(\''+escape(element.Operate_Detail)+'\')" style="border-color: white">查看</button>'),
                                    //$('<td></td>',{text:element.Operate_Detail}),
                                    // $('<td>' +
                                    //     '<button class="btn btn-primary4" onclick="go_select(\''+element.name+'\',\'S\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                    //     '<button class="btn btn-primary3"  onclick="go_select(\''+element.name+'\',\'D\')" style="width: auto;height:40px;text-align: center;font-weight:bold;display: inline-block;"></button>' +
                                    //     '</td>')
                                )
                            );
                        });
                        document.getElementById("page").value="all";
                        document.getElementById("chosen").value="all";
                        document.getElementById("dateEnd").value="";
                        document.getElementById("dateStart").value="";
                        $('#home').show();
                    }
                },
                error:function(data){
                    console.log(data);
                    alert(JSON.stringify(data))
                }
            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
    </script>


{{--    @foreach($Logs as $k )--}}
{{--        {{ $k }}--}}
{{--    @endforeach--}}

{{--    @foreach($Logs as $log)--}}
{{--        @foreach($log as $lo)--}}
{{--            @foreach($lo as $l)--}}
{{--                {{$l['time']}}--}}
{{--            @endforeach--}}
{{--        @endforeach--}}
{{--    @endforeach--}}

{{--    @foreach($Logs["帳號管理"] as $log)--}}
{{--        @foreach($log as $lo)--}}
{{--            帳號:{{substr($lo['time'],5,5)}}--}}
{{--        @endforeach--}}
{{--    @endforeach--}}

    {{$Logs["帳號管理"]["刪除帳號"][0]["time"]}}
    {{$Users[0]->name}}
    {{$Pages[0]}}
@endsection
