<?php

namespace App\Http\Controllers;

use App\Camdb;
use App\CamType;
use App\CamGoup;
use Illuminate\Http\Request;
use function MongoDB\BSON\toJSON;

class CamdbController extends Controller
{

    public function config()
    {
        //
        $type_id=CamType::all('type_id');
        $goups=CamGoup::all();
        return view('configcam',['title'=>'新增攝影機','Types'=>$type_id,'Goups'=>$goups]);
    }

    public function play()
    {
        //
        $goups=CamGoup::all();
        return view('playrealtime',['title'=>'攝影機現場調閱','Goups'=>$goups]);
    }


    public function create()
    {
        //
    }


    public function replay()
    {
        //
        $goups=CamGoup::all();
        return view('replay',['title'=>'攝影機回放','Goups'=>$goups]);
    }

    public function record()
    {
        $goups=CamGoup::all();
        return view('recordconfig',['title'=>'選擇攝影機錄製','Goups'=>$goups]);
    }
    public function find_channel($cam_id)
    {
        $Channel=Camdb::all('camera_id','camera_path')->where('camera_id',$cam_id);
        return $Channel;
    }
    public function get_info($cam_list)
    {
        $Cam_list=collect(Camdb::where('camera_id',$cam_list)->first());
        $Goup_name=collect(CamGoup::where('goup_id',$Cam_list['camera_goup'])->first());

        $info_list=$Cam_list->merge($Goup_name);

        return $info_list;

    }

    public function show_in_playrealtime($goup_id)
    {
        $Cam_list=Camdb::all('camera_id','camera_goup','camera_path','camera_startime')->where('camera_goup',$goup_id);
        return $Cam_list;
    }

    public function show_in_replay($goup_id)
    {
        //
        $Cam_list=Camdb::all('camera_id','camera_goup','camera_path','camera_startime')->where('camera_goup',$goup_id)->where('camera_startime','!=',null);
        return $Cam_list;

    }

    public function show_in_recordconfig($goup_id)
    {
        //
        $Cam_list=Camdb::all('camera_id','camera_goup','camera_path','camera_startime')->where('camera_goup',$goup_id);
        return $Cam_list;
    }

    public function edit(Camdb $camdb)
    {
        //
    }


    public function update(Request $request, Camdb $camdb)
    {
        //
    }

    public function destroy(Camdb $camdb)
    {
        //
    }
}
